/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.cache;

import java.io.InvalidObjectException;
import java.util.Arrays;

abstract class AbstractWikiStringBuilder {
    static final int INITIAL_CAPACITY = 16;
    private char[] value;
    private int count;
    private boolean shared;

    final char[] getValue() {
        return this.value;
    }

    final char[] shareValue() {
        this.shared = true;
        return this.value;
    }

    final void set(char[] val, int len) throws InvalidObjectException {
        if (val == null) {
            val = new char[]{};
        }
        if (val.length < len) {
            throw new InvalidObjectException("val.length < len");
        }
        this.shared = false;
        this.value = val;
        this.count = len;
    }

    AbstractWikiStringBuilder() {
        this.value = new char[16];
    }

    AbstractWikiStringBuilder(int capacity) {
        if (capacity < 0) {
            throw new NegativeArraySizeException();
        }
        this.value = new char[capacity];
    }

    AbstractWikiStringBuilder(String string) {
        this.count = string.length();
        this.shared = false;
        this.value = new char[this.count + 16];
        string.getChars(0, this.count, this.value, 0);
    }

    private void enlargeBuffer(int min) {
        int twice = (this.value.length << 1) + 2;
        char[] newData = new char[min > twice ? min : twice];
        System.arraycopy(this.value, 0, newData, 0, this.count);
        this.value = newData;
        this.shared = false;
    }

    final void appendNull() {
        int newSize = this.count + 4;
        if (newSize > this.value.length) {
            this.enlargeBuffer(newSize);
        } else if (this.shared) {
            this.value = (char[])this.value.clone();
            this.shared = false;
        }
        this.value[this.count++] = 110;
        this.value[this.count++] = 117;
        this.value[this.count++] = 108;
        this.value[this.count++] = 108;
    }

    final void append0(char[] chars) {
        int newSize = this.count + chars.length;
        if (newSize > this.value.length) {
            this.enlargeBuffer(newSize);
        } else if (this.shared) {
            this.value = (char[])this.value.clone();
            this.shared = false;
        }
        System.arraycopy(chars, 0, this.value, this.count, chars.length);
        this.count = newSize;
    }

    final void append0(char[] chars, int start, int length) {
        int newSize;
        if (chars == null) {
            throw new NullPointerException();
        }
        if (start >= 0 && length >= 0 && length <= chars.length - start) {
            newSize = this.count + length;
            if (newSize > this.value.length) {
                this.enlargeBuffer(newSize);
            } else if (this.shared) {
                this.value = (char[])this.value.clone();
                this.shared = false;
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(chars, start, this.value, this.count, length);
        this.count = newSize;
    }

    final void append0(char ch) {
        if (this.count == this.value.length) {
            this.enlargeBuffer(this.count + 1);
        }
        if (this.shared) {
            this.value = (char[])this.value.clone();
            this.shared = false;
        }
        this.value[this.count++] = ch;
    }

    final void append0(String string) {
        if (string == null) {
            this.appendNull();
            return;
        }
        int adding = string.length();
        int newSize = this.count + adding;
        if (newSize > this.value.length) {
            this.enlargeBuffer(newSize);
        } else if (this.shared) {
            this.value = (char[])this.value.clone();
            this.shared = false;
        }
        string.getChars(0, adding, this.value, this.count);
        this.count = newSize;
    }

    final void append0(CharSequence s, int start, int end) {
        if (s == null) {
            s = "null";
        }
        if (start < 0 || end < 0 || start > end || end > s.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.append0(s.subSequence(start, end).toString());
    }

    public int capacity() {
        return this.value.length;
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    final void delete0(int start, int end) {
        if (start >= 0) {
            if (end > this.count) {
                end = this.count;
            }
            if (end == start) {
                return;
            }
            if (end > start) {
                int length = this.count - end;
                if (length > 0) {
                    if (!this.shared) {
                        System.arraycopy(this.value, end, this.value, start, length);
                    } else {
                        char[] newData = new char[this.value.length];
                        System.arraycopy(this.value, 0, newData, 0, start);
                        System.arraycopy(this.value, end, newData, start, length);
                        this.value = newData;
                        this.shared = false;
                    }
                }
                this.count -= end - start;
                return;
            }
        }
        throw new StringIndexOutOfBoundsException();
    }

    final void deleteCharAt0(int location) {
        if (location < 0 || location >= this.count) {
            throw new StringIndexOutOfBoundsException(location);
        }
        int length = this.count - location - 1;
        if (length > 0) {
            if (!this.shared) {
                System.arraycopy(this.value, location + 1, this.value, location, length);
            } else {
                char[] newData = new char[this.value.length];
                System.arraycopy(this.value, 0, newData, 0, location);
                System.arraycopy(this.value, location + 1, newData, location, length);
                this.value = newData;
                this.shared = false;
            }
        }
        --this.count;
    }

    public void ensureCapacity(int min) {
        if (min > this.value.length) {
            this.enlargeBuffer(min);
        }
    }

    public void getChars(int start, int end, char[] dest, int destStart) {
        if (start > this.count || end > this.count || start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.value, start, dest, destStart, end - start);
    }

    final void insert0(int index, char[] chars) {
        if (index < 0 || index > this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (chars.length != 0) {
            this.move(chars.length, index);
            System.arraycopy(chars, 0, this.value, index, chars.length);
            this.count += chars.length;
        }
    }

    final void insert0(int index, char[] chars, int start, int length) {
        if (index >= 0 && index <= this.count) {
            if (start >= 0 && length >= 0 && length <= chars.length - start) {
                if (length != 0) {
                    this.move(length, index);
                    System.arraycopy(chars, start, this.value, index, length);
                    this.count += length;
                }
                return;
            }
            throw new StringIndexOutOfBoundsException("offset " + start + ", length " + length + ", char[].length " + chars.length);
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    final void insert0(int index, char ch) {
        if (index < 0 || index > this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.move(1, index);
        this.value[index] = ch;
        ++this.count;
    }

    final void insert0(int index, String string) {
        if (index >= 0 && index <= this.count) {
            int min;
            if (string == null) {
                string = "null";
            }
            if ((min = string.length()) != 0) {
                this.move(min, index);
                string.getChars(0, min, this.value, index);
                this.count += min;
            }
        } else {
            throw new StringIndexOutOfBoundsException(index);
        }
    }

    final void insert0(int index, CharSequence s, int start, int end) {
        if (s == null) {
            s = "null";
        }
        if (index < 0 || index > this.count || start < 0 || end < 0 || start > end || end > s.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.insert0(index, s.subSequence(start, end).toString());
    }

    public int length() {
        return this.count;
    }

    private void move(int size, int index) {
        int newSize;
        if (this.value.length - this.count >= size) {
            if (!this.shared) {
                System.arraycopy(this.value, index, this.value, index + size, this.count - index);
                return;
            }
            newSize = this.value.length;
        } else {
            int a = this.count + size;
            int b = (this.value.length << 1) + 2;
            newSize = a > b ? a : b;
        }
        char[] newData = new char[newSize];
        System.arraycopy(this.value, 0, newData, 0, index);
        System.arraycopy(this.value, index, newData, index + size, this.count - index);
        this.value = newData;
        this.shared = false;
    }

    final void replace0(int start, int end, String string) {
        if (start >= 0) {
            if (end > this.count) {
                end = this.count;
            }
            if (end > start) {
                int stringLength = string.length();
                int diff = end - start - stringLength;
                if (diff > 0) {
                    if (!this.shared) {
                        System.arraycopy(this.value, end, this.value, start + stringLength, this.count - end);
                    } else {
                        char[] newData = new char[this.value.length];
                        System.arraycopy(this.value, 0, newData, 0, start);
                        System.arraycopy(this.value, end, newData, start + stringLength, this.count - end);
                        this.value = newData;
                        this.shared = false;
                    }
                } else if (diff < 0) {
                    this.move(-diff, end);
                } else if (this.shared) {
                    this.value = (char[])this.value.clone();
                    this.shared = false;
                }
                string.getChars(0, stringLength, this.value, start);
                this.count -= diff;
                return;
            }
            if (start == end) {
                if (string == null) {
                    throw new NullPointerException();
                }
                this.insert0(start, string);
                return;
            }
        }
        throw new StringIndexOutOfBoundsException();
    }

    final void reverse0() {
        if (this.count < 2) {
            return;
        }
        if (!this.shared) {
            int i = 0;
            int end = this.count;
            int mid = this.count / 2;
            while (i < mid) {
                char temp = this.value[--end];
                this.value[end] = this.value[i];
                this.value[i] = temp;
                ++i;
            }
        } else {
            char[] newData = new char[this.value.length];
            int i = 0;
            int end = this.count;
            while (i < this.count) {
                newData[--end] = this.value[i];
                ++i;
            }
            this.value = newData;
            this.shared = false;
        }
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (this.shared) {
            this.value = (char[])this.value.clone();
            this.shared = false;
        }
        this.value[index] = ch;
    }

    public final void setCharactersAt(int index, char[] chars) {
        if (index < 0 || index + chars.length >= this.count) {
            throw new StringIndexOutOfBoundsException(index + chars.length);
        }
        System.arraycopy(chars, 0, this.value, index, chars.length);
    }

    public void setLength(int length) {
        if (length < 0) {
            throw new StringIndexOutOfBoundsException(length);
        }
        if (this.count < length) {
            if (length > this.value.length) {
                this.enlargeBuffer(length);
            } else if (this.shared) {
                char[] newData = new char[this.value.length];
                System.arraycopy(this.value, 0, newData, 0, this.count);
                this.value = newData;
                this.shared = false;
            } else {
                Arrays.fill(this.value, this.count, length, '\u0000');
            }
        }
        this.count = length;
    }

    public String substring(int start) {
        if (start >= 0 && start <= this.count) {
            if (start == this.count) {
                return "";
            }
            this.shared = true;
            return new String(this.value, start, this.count - start);
        }
        throw new StringIndexOutOfBoundsException(start);
    }

    public String substring(int start, int end) {
        if (start >= 0 && start <= end && end <= this.count) {
            if (start == end) {
                return "";
            }
            this.shared = true;
            return new String(this.value, start, end - start);
        }
        throw new StringIndexOutOfBoundsException();
    }

    public String toString() {
        if (this.count == 0) {
            return "";
        }
        if (this.count >= 256 && this.count <= this.value.length >> 1) {
            return new String(this.value, 0, this.count);
        }
        this.shared = true;
        return new String(this.value, 0, this.count);
    }

    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String subString, int start) {
        int subCount;
        if (start < 0) {
            start = 0;
        }
        if ((subCount = subString.length()) > 0) {
            if (subCount + start > this.count) {
                return -1;
            }
            char firstChar = subString.charAt(0);
            while (true) {
                int i = start;
                boolean found = false;
                while (i < this.count) {
                    if (this.value[i] == firstChar) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found || subCount + i > this.count) {
                    return -1;
                }
                int o1 = i;
                int o2 = 0;
                while (++o2 < subCount && this.value[++o1] == subString.charAt(o2)) {
                }
                if (o2 == subCount) {
                    return i;
                }
                start = i + 1;
            }
        }
        return start < this.count || start == 0 ? start : this.count;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public int lastIndexOf(String subString, int start) {
        int subCount = subString.length();
        if (subCount <= this.count && start >= 0) {
            if (subCount > 0) {
                if (start > this.count - subCount) {
                    start = this.count - subCount;
                }
                char firstChar = subString.charAt(0);
                while (true) {
                    int i = start;
                    boolean found = false;
                    while (i >= 0) {
                        if (this.value[i] == firstChar) {
                            found = true;
                            break;
                        }
                        --i;
                    }
                    if (!found) {
                        return -1;
                    }
                    int o1 = i;
                    int o2 = 0;
                    while (++o2 < subCount && this.value[++o1] == subString.charAt(o2)) {
                    }
                    if (o2 == subCount) {
                        return i;
                    }
                    start = i - 1;
                }
            }
            return start < this.count ? start : this.count;
        }
        return -1;
    }

    public void trimToSize() {
        if (this.count < this.value.length) {
            char[] newValue = new char[this.count];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
            this.shared = false;
        }
    }

    public int codePointAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return Character.codePointAt(this.value, index, this.count);
    }

    public int codePointBefore(int index) {
        if (index < 1 || index > this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return Character.codePointBefore(this.value, index);
    }

    public int codePointCount(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.count || beginIndex > endIndex) {
            throw new StringIndexOutOfBoundsException();
        }
        return Character.codePointCount(this.value, beginIndex, endIndex - beginIndex);
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        return Character.offsetByCodePoints(this.value, 0, this.count, index, codePointOffset);
    }
}

