/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.latex.PropertyManager;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.model.ImageFormat;
import info.bliki.wiki.tags.BrTag;
import info.bliki.wiki.tags.HTMLTag;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.EndTagToken;
import org.htmlcleaner.TagNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaTeXConverter
implements ITextConverter {
    public static final String TEMP_BRACES = "TEMP-BRACES";
    static final String[] CHAR_REPLACEMENTS = new String[]{"\\textbackslashTEMP-BRACES", "\\textasciitildeTEMP-BRACES", "\\textasciicircumTEMP-BRACES", "\\textbarTEMP-BRACES", "\\textlessTEMP-BRACES", "\\textgreaterTEMP-BRACES", "\\$", "$\\{$", "$\\}$", "\\%", "\\&", "\\#", "\\_{}", "''"};
    static final String CHARS_TO_REPLACE = "\\~^|<>${}%&#_\"";
    static final String[] STRING_REPLACEMENTS = new String[]{"\\dots{}"};
    static final String[] STRINGS_TO_REPLACE = new String[]{"..."};

    @Override
    public void nodesToText(List<BaseToken> nodes, Appendable resultBuffer, IWikiModel model) throws IOException {
        if (nodes != null && !nodes.isEmpty()) {
            for (BaseToken item : nodes) {
                if (item == null) continue;
                if (item instanceof List) {
                    this.nodesToText((List)((Object)item), resultBuffer, model);
                    continue;
                }
                if (item instanceof ContentToken) {
                    ContentToken contentToken = (ContentToken)item;
                    resultBuffer.append(LaTeXConverter.texEscapeString(contentToken.getContent()));
                    continue;
                }
                if (item instanceof HTMLTag) {
                    ((HTMLTag)item).renderLaTeX(this, resultBuffer, model);
                    continue;
                }
                if (item instanceof TagNode) {
                    TagNode node = (TagNode)item;
                    Map<String, Object> map = node.getObjectAttributes();
                    if (map != null && map.size() > 0) {
                        Object attValue = map.get("wikiobject");
                        if (!(attValue instanceof ImageFormat)) continue;
                        this.imageNodeToText(node, (ImageFormat)attValue, resultBuffer, model);
                        continue;
                    }
                    this.nodeToLaTeX(node, resultBuffer, model);
                    continue;
                }
                if (!(item instanceof EndTagToken) || !(item instanceof BrTag)) continue;
                resultBuffer.append(PropertyManager.get("LineBreak"));
            }
        }
    }

    protected void nodeToLaTeX(TagNode node, Appendable resultBuffer, IWikiModel model) throws IOException {
        List children;
        String name = node.getName();
        if (name.equals("div") || name.equals("p") || name.equals("table") || name.equals("ul") || name.equals("ol") || name.equals("li") || name.equals("th") || name.equals("tr") || name.equals("td") || name.equals("pre")) {
            resultBuffer.append('\n');
        }
        if ((children = node.getChildren()).size() != 0) {
            this.nodesToText(children, resultBuffer, model);
        }
    }

    @Override
    public void imageNodeToText(TagNode imageTagNode, ImageFormat imageFormat, Appendable resultBuffer, IWikiModel model) throws IOException {
        Map<String, String> map = imageTagNode.getAttributes();
        String caption = imageFormat.getCaption();
        String location = imageFormat.getLocation();
        String type = imageFormat.getType();
        int pxSize = imageFormat.getSize();
        if (pxSize != -1) {
            resultBuffer.append("<div style=\"");
            resultBuffer.append("wigth:");
            resultBuffer.append(Integer.toString(pxSize));
            resultBuffer.append("px");
            resultBuffer.append("\">");
        }
        resultBuffer.append("<a class=\"internal\" href=\"");
        resultBuffer.append(map.get("href").toString());
        resultBuffer.append("\" title=\"");
        resultBuffer.append(caption);
        resultBuffer.append("\">");
        resultBuffer.append("<img src=\"");
        resultBuffer.append(map.get("src").toString());
        resultBuffer.append("\"");
        if (caption != null && caption.length() > 0) {
            resultBuffer.append(" alt=\"").append(caption).append("\"");
            resultBuffer.append(" title=\"").append(caption).append("\"");
        }
        resultBuffer.append(" class=\"");
        if (location != null) {
            resultBuffer.append(" location-").append(location);
        }
        if (type != null) {
            resultBuffer.append(" type-").append(type);
        }
        resultBuffer.append("\"");
        if (pxSize != -1) {
            resultBuffer.append(" width=\"").append(Integer.toString(pxSize)).append("px\"");
        }
        resultBuffer.append(" />\n");
        resultBuffer.append("</a>");
        List children = imageTagNode.getChildren();
        if (children.size() != 0) {
            this.nodesToText(children, resultBuffer, model);
        }
        if (pxSize != -1) {
            resultBuffer.append("</div>\n");
        }
    }

    public static String verbToText(String s) {
        String text = LaTeXConverter.texEscapeString(s);
        text = text.replace("\r", "");
        text = text.replace("\n", PropertyManager.get("LineBreak"));
        return text;
    }

    public static String texEscapeString(String s) {
        int i = 0;
        while (i < CHARS_TO_REPLACE.length()) {
            s = s.replace(String.valueOf(CHARS_TO_REPLACE.charAt(i)), CHAR_REPLACEMENTS[i]);
            ++i;
        }
        i = 0;
        while (i < STRINGS_TO_REPLACE.length) {
            s = s.replace(STRINGS_TO_REPLACE[i], STRING_REPLACEMENTS[i]);
            ++i;
        }
        s = s.replace(TEMP_BRACES, "{}");
        return s;
    }

    @Override
    public boolean noLinks() {
        return true;
    }
}

