/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.model;

public class ImageFormat {
    private String fFilename;
    private String fType;
    private String fLocation = "none";
    private String fSizeStr = null;
    private int fSize = -1;
    private String fCaption;
    private String fNamespace;

    public String getCaption() {
        return this.fCaption;
    }

    public void setCaption(String caption) {
        this.fCaption = caption;
    }

    public String getFilename() {
        return this.fFilename;
    }

    public void setFilename(String filename) {
        this.fFilename = filename;
    }

    public String getLocation() {
        return this.fLocation;
    }

    public void setLocation(String location) {
        this.fLocation = location.toLowerCase();
    }

    public int getSize() {
        return this.fSize;
    }

    public String getSizeStr() {
        return this.fSizeStr;
    }

    public void setSize(String size) {
        this.fSizeStr = size.toLowerCase();
        if (this.fSizeStr.endsWith("px")) {
            try {
                this.fSize = Integer.parseInt(this.fSizeStr.substring(0, this.fSizeStr.length() - 2));
            }
            catch (NumberFormatException e) {
                this.fSize = -1;
                this.fSizeStr = null;
            }
        }
    }

    public String getType() {
        return this.fType;
    }

    public void setType(String type) {
        this.fType = type.toLowerCase();
    }

    public static ImageFormat getImageFormat(String rawImageLink, String imageNamespace) {
        ImageFormat img = new ImageFormat();
        int level = 0;
        String rawLink = rawImageLink;
        int i = rawLink.length() - 1;
        while (i >= 1) {
            char ch = rawLink.charAt(i);
            if (ch == '[' && level > 0 && rawLink.charAt(i - 1) == '[') {
                --i;
                --level;
            } else if (ch == ']' && rawLink.charAt(i - 1) == ']') {
                --i;
                ++level;
            }
            if (level == 0 && rawLink.charAt(i) == '|') {
                img.setCaption(rawLink.substring(i + 1));
                rawLink = rawLink.substring(0, i);
                break;
            }
            --i;
        }
        String[] tokens = rawLink.split("\\|");
        String token = tokens[0].trim();
        img.setFilename("");
        if (token.length() > imageNamespace.length() && token.charAt(imageNamespace.length()) == ':' && imageNamespace.equalsIgnoreCase(token.substring(0, imageNamespace.length()))) {
            img.setFilename(token.substring(imageNamespace.length() + 1));
            img.setNamespace(imageNamespace);
        }
        int j = 1;
        while (j < tokens.length) {
            token = tokens[j].trim().toLowerCase();
            if (token.equalsIgnoreCase("frame") || token.equalsIgnoreCase("thumb") || token.equalsIgnoreCase("thumbnail")) {
                img.setType(token);
            } else if (token.equalsIgnoreCase("right") || token.equalsIgnoreCase("left") || token.equalsIgnoreCase("center") || token.equalsIgnoreCase("none")) {
                img.setLocation(token);
            } else if (token.toLowerCase().endsWith("px")) {
                img.setSize(token);
            }
            ++j;
        }
        return img;
    }

    public String getNamespace() {
        return this.fNamespace;
    }

    public void setNamespace(String namespace) {
        this.fNamespace = namespace;
    }
}

