/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags.code;

import info.bliki.wiki.tags.code.AbstractCPPBasedCodeFilter;
import info.bliki.wiki.tags.code.SourceCodeFormatter;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPCodeFilter
extends AbstractCPPBasedCodeFilter
implements SourceCodeFormatter {
    private static HashMap<String, String> KEYWORD_SET = new HashMap();
    private static final String[] KEYWORDS = new String[]{"if", "elseif", "else", "endif", "for", "endfor", "while", "endwhile", "switch", "case", "endswitch", "break", "continue", "return", "include", "include_once", "require", "require_once", "function", "class", "new", "do", "old_function", "default", "global", "static", "foreach", "endforeach", "extends", "empty", "array", "echo", "var", "as", "print", "unset", "exit", "and", "or", "xor", "list", "null", "false", "true", "abstract", "catch", "finally", "try", "private", "protected", "public", "interface", "implements", "instanceof", "super", "throw", "const", "declare", "enddeclare", "eval", "use", "isset", "final"};

    static {
        int i = 0;
        while (i < KEYWORDS.length) {
            PHPCodeFilter.createHashMap(KEYWORD_SET, KEYWORDS[i]);
            ++i;
        }
    }

    @Override
    public HashMap<String, String> getKeywordSet() {
        return KEYWORD_SET;
    }

    @Override
    public HashSet<String> getObjectSet() {
        return null;
    }

    @Override
    public String filter(String input) {
        char[] source = input.toCharArray();
        int currentPosition = 0;
        int identStart = 0;
        char currentChar = ' ';
        HashMap<String, String> keywordsSet = this.getKeywordSet();
        HashSet<String> objectsSet = this.getObjectSet();
        StringBuilder result = new StringBuilder(input.length() + input.length() / 4);
        boolean identFound = false;
        try {
            while (true) {
                if ((currentChar = source[currentPosition++]) >= 'A' && currentChar <= 'Z' || currentChar == '_' || currentChar >= 'a' && currentChar <= 'z') {
                    identStart = currentPosition - 1;
                    identFound = true;
                    while (currentChar >= 'a' && currentChar <= 'z' || currentChar >= 'A' && currentChar <= 'Z' || currentChar == '_') {
                        currentChar = source[currentPosition++];
                    }
                    currentPosition = this.appendIdentifier(input, identStart, currentPosition, keywordsSet, objectsSet, result);
                    identFound = false;
                    continue;
                }
                if (currentChar == '\"') {
                    result.append("<font color=\"#2A00FF\">");
                    PHPCodeFilter.appendChar(result, currentChar);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        PHPCodeFilter.appendChar(result, currentChar);
                        if (currentChar == '\"' && source[currentPosition - 2] != '\\') break;
                    }
                    result.append("</font>");
                    continue;
                }
                if (currentChar == '\'') {
                    result.append("<font color=\"#2A00FF\">");
                    PHPCodeFilter.appendChar(result, currentChar);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        PHPCodeFilter.appendChar(result, currentChar);
                        if (currentChar == '\'' && source[currentPosition - 2] != '\\') break;
                    }
                    result.append("</font>");
                    continue;
                }
                if (currentChar == '/' && currentPosition < input.length() && source[currentPosition] == '/') {
                    result.append("<font color=\"#3F7F5F\">");
                    PHPCodeFilter.appendChar(result, currentChar);
                    PHPCodeFilter.appendChar(result, source[currentPosition++]);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        PHPCodeFilter.appendChar(result, currentChar);
                        if (currentChar == '\n') break;
                    }
                    result.append("</font>");
                    continue;
                }
                if (currentChar == '/' && currentPosition < input.length() && source[currentPosition] == '*') {
                    if (currentPosition < input.length() - 1 && source[currentPosition + 1] == '*') {
                        result.append("<font color=\"#3F5FBF\">");
                    } else {
                        result.append("<font color=\"#3F7F5F\">");
                    }
                    PHPCodeFilter.appendChar(result, currentChar);
                    PHPCodeFilter.appendChar(result, source[currentPosition++]);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        PHPCodeFilter.appendChar(result, currentChar);
                        if (currentChar == '/' && source[currentPosition - 2] == '*') break;
                    }
                    result.append("</font>");
                    continue;
                }
                if (currentChar == '<' && this.isPHPTag() && currentPosition + 3 < input.length() && source[currentPosition] == '?' && source[currentPosition + 1] == 'p' && source[currentPosition + 2] == 'h' && source[currentPosition + 3] == 'p') {
                    currentPosition += 4;
                    result.append("<font color=\"#7F0055\">&#60;?php</font>");
                    continue;
                }
                if (currentChar == '?' && this.isPHPTag() && currentPosition < input.length() && source[currentPosition] == '>') {
                    ++currentPosition;
                    result.append("<font color=\"#7F0055\">?&#62;</font>");
                    continue;
                }
                PHPCodeFilter.appendChar(result, currentChar);
            }
        }
        catch (IndexOutOfBoundsException e) {
            if (identFound) {
                currentPosition = this.appendIdentifier(input, identStart, currentPosition, keywordsSet, null, result);
            }
            return result.toString();
        }
    }

    @Override
    public boolean isKeywordLowerCase() {
        return false;
    }

    @Override
    public boolean isPHPTag() {
        return true;
    }
}

