/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client;

import java.io.IOException;
import org.alfresco.jlan.client.SMBPacket;
import org.alfresco.jlan.client.Session;
import org.alfresco.jlan.client.SessionFactory;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.netbios.NetworkSession;
import org.alfresco.jlan.smb.NTTime;
import org.alfresco.jlan.smb.PCShare;
import org.alfresco.jlan.smb.SMBDate;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.util.DataPacker;
import org.alfresco.jlan.util.HexDump;

public class AuthenticateSession
extends Session {
    protected AuthenticateSession(PCShare shr, NetworkSession sess, int dialect, SMBPacket pkt) {
        super(shr, dialect, pkt);
        this.setSession(sess);
        this.processNegotiateResponse();
    }

    public final void doSessionSetup(String userName, byte[] ascPwd, byte[] uniPwd, int vc) throws IOException, SMBException {
        int pos;
        SMBPacket pkt = new SMBPacket();
        pkt.setCommand(115);
        if (this.getDialect() == 7) {
            pkt.setParameterCount(13);
            pkt.setAndXCommand(255);
            pkt.setParameter(1, 0);
            pkt.setParameter(2, SessionFactory.DefaultPacketSize());
            pkt.setParameter(3, this.getMaximumMultiplexedRequests());
            pkt.setParameter(4, vc);
            pkt.setParameterLong(5, 0);
            pkt.setParameter(7, ascPwd != null ? ascPwd.length : 0);
            pkt.setParameter(8, uniPwd != null ? uniPwd.length : 0);
            pkt.setParameter(9, 0);
            pkt.setParameter(10, 0);
            int caps = 124;
            pkt.setParameterLong(11, caps);
            pos = pkt.getByteOffset();
            pkt.setPosition(pos);
            if (ascPwd != null) {
                pkt.packBytes(ascPwd, ascPwd.length);
            }
            if (uniPwd != null) {
                pkt.packBytes(uniPwd, uniPwd.length);
            }
            pkt.packString(userName, false);
            if (this.getPCShare().hasDomain()) {
                pkt.packString(this.getPCShare().getDomain(), false);
            } else {
                pkt.packString(SessionFactory.getDefaultDomain(), false);
            }
            pkt.packString("Java VM", false);
            pkt.packString("JLAN", false);
            pkt.setByteCount(pkt.getPosition() - pos);
        } else {
            pkt.setUserId(1);
            pkt.setParameterCount(10);
            pkt.setAndXCommand(255);
            pkt.setParameter(1, 0);
            pkt.setParameter(2, SessionFactory.DefaultPacketSize());
            pkt.setParameter(3, 2);
            pkt.setParameter(4, 0);
            pkt.setParameter(5, 0);
            pkt.setParameter(6, 0);
            pkt.setParameter(7, ascPwd != null ? ascPwd.length : 0);
            pkt.setParameter(8, 0);
            pkt.setParameter(9, 0);
            byte[] buf = pkt.getBuffer();
            pos = pkt.getByteOffset();
            if (ascPwd != null) {
                for (int i = 0; i < ascPwd.length; ++i) {
                    buf[pos++] = ascPwd[i];
                }
            }
            StringBuffer clbuf = new StringBuffer();
            clbuf.append(this.getPCShare().getUserName());
            clbuf.append('\u0000');
            if (this.getPCShare().hasDomain()) {
                clbuf.append(this.getPCShare().getDomain());
            } else {
                clbuf.append(SessionFactory.getDefaultDomain());
            }
            clbuf.append('\u0000');
            clbuf.append("Java VM");
            clbuf.append('\u0000');
            clbuf.append("JLAN");
            clbuf.append('\u0000');
            byte[] byts = clbuf.toString().getBytes();
            for (int i = 0; i < byts.length; ++i) {
                buf[pos++] = byts[i];
            }
            int pwdLen = ascPwd != null ? ascPwd.length : 0;
            pkt.setByteCount(pwdLen + byts.length);
        }
        pkt.ExchangeSMB(this, pkt, true);
        this.setUserId(pkt.getUserId());
        if (pkt.getParameterCount() >= 3) {
            this.setGuest(pkt.getParameter(2) != 0);
        }
        if (pkt.getByteCount() > 0) {
            byte[] buf = pkt.getBuffer();
            int offset = pkt.getByteOffset();
            int maxlen = offset + pkt.getByteCount();
            String srvOS = DataPacker.getString(buf, offset, maxlen);
            this.setOperatingSystem(srvOS);
            String lanman = DataPacker.getString(buf, offset += srvOS.length() + 1, maxlen -= srvOS.length() + 1);
            this.setLANManagerType(lanman);
            if (this.getDomain() == null || this.getDomain().length() == 0) {
                String dom = DataPacker.getString(buf, offset += lanman.length() + 1, maxlen += lanman.length() + 1);
                this.setDomain(dom);
            }
        }
        if (this.getDialect() == 0 || this.getDialect() == 1) {
            this.setMaximumPacketSize(pkt.getParameter(2));
        }
    }

    private void processNegotiateResponse() {
        int keyLen = 0;
        boolean unicodeStr = false;
        boolean encAlgorithm = false;
        int defFlags2 = 0;
        if (this.getDialect() == 7) {
            this.m_pkt.resetParameterPointer();
            this.m_pkt.skipBytes(2);
            this.setSecurityMode(this.m_pkt.unpackByte());
            this.setMaximumMultiplexedRequests(this.m_pkt.unpackWord());
            this.setMaximumVirtualCircuits(this.m_pkt.unpackWord());
            this.setMaximumPacketSize(this.m_pkt.unpackInt());
            this.m_pkt.skipBytes(8);
            this.setCapabilities(this.m_pkt.unpackInt());
            SMBDate srvTime = NTTime.toSMBDate(this.m_pkt.unpackLong());
            int tzone = this.m_pkt.unpackWord();
            keyLen = this.m_pkt.unpackByte();
            unicodeStr = true;
            encAlgorithm = true;
            defFlags2 = 49153;
        } else if (this.getDialect() > 1) {
            int secMode = this.m_pkt.getParameter(1);
            this.setSecurityMode((secMode & 1) != 0 ? 1 : 2);
            if (this.m_pkt.getParameterCount() >= 11) {
                keyLen = this.m_pkt.getParameter(11) & 0xFF;
            }
            this.setMaximumMultiplexedRequests(this.m_pkt.getParameter(3));
            this.setMaximumVirtualCircuits(this.m_pkt.getParameter(4));
            if (this.m_pkt.isUnicode()) {
                unicodeStr = true;
            }
            defFlags2 = 1;
        }
        this.setDefaultFlags2(defFlags2);
        if (this.m_pkt.getByteCount() > 0) {
            int bytsiz = this.m_pkt.getByteCount();
            int bytpos = this.m_pkt.getByteOffset();
            byte[] buf = this.m_pkt.getBuffer();
            if (keyLen > 0) {
                byte[] encryptKey = new byte[keyLen];
                for (int keyIdx = 0; keyIdx < keyLen; ++keyIdx) {
                    encryptKey[keyIdx] = buf[bytpos++];
                }
                this.setEncryptionKey(encryptKey);
                if (Session.hasDebugOption(2)) {
                    Debug.print("** Encryption Key: ");
                    Debug.print(HexDump.hexString(encryptKey));
                    Debug.println(", length = " + keyLen);
                }
            }
            String dom = !unicodeStr ? DataPacker.getString(buf, bytpos, bytsiz) : DataPacker.getUnicodeString(buf, bytpos, bytsiz / 2);
            this.setDomain(dom);
            if (Session.hasDebugOption(2)) {
                Debug.println("** Server domain : " + this.getDomain() + ".");
            }
        }
    }
}

