/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.alfresco.jlan.client.PasswordEncryptor;

public class JCEPasswordEncryptor
extends PasswordEncryptor {
    public static final int LANMAN = 0;
    public static final int NTLM1 = 1;
    public static final int NTLM2 = 2;
    public static final int MD4 = 3;
    private static final String[] _algNames = new String[]{"LanMan", "NTLMv1", "NTLMv2", "MD4"};

    @Override
    public boolean checkEncryptionAlgorithms() {
        boolean algOK = false;
        try {
            MessageDigest.getInstance("MD4");
            Cipher.getInstance("DES");
        }
        catch (NoSuchAlgorithmException ex) {
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            // empty catch block
        }
        return algOK;
    }

    @Override
    public byte[] generateEncryptedPassword(String plainPwd, byte[] encryptKey, int alg) throws NoSuchAlgorithmException {
        String pwd = plainPwd;
        if (pwd == null) {
            pwd = "";
        }
        byte[] encPwd = null;
        MessageDigest md4 = null;
        int len = 0;
        byte[] pwdBytes = null;
        switch (alg) {
            case 0: {
                encPwd = this.P24(pwd, encryptKey);
                break;
            }
            case 1: {
                md4 = MessageDigest.getInstance("MD4");
                try {
                    pwdBytes = pwd.getBytes("UnicodeLittleUnmarked");
                }
                catch (UnsupportedEncodingException ex) {
                    // empty catch block
                }
                md4.update(pwdBytes);
                byte[] p21 = new byte[21];
                System.arraycopy(md4.digest(), 0, p21, 0, 16);
                encPwd = this.P24(p21, encryptKey);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                md4 = MessageDigest.getInstance("MD4");
                len = pwd.length();
                pwdBytes = new byte[len * 2];
                for (int i = 0; i < len; ++i) {
                    char ch = pwd.charAt(i);
                    pwdBytes[i * 2] = (byte)ch;
                    pwdBytes[i * 2 + 1] = (byte)(ch >> 8 & 0xFF);
                }
                md4.update(pwdBytes);
                encPwd = new byte[16];
                System.arraycopy(md4.digest(), 0, encPwd, 0, 16);
            }
        }
        return encPwd;
    }

    @Override
    public byte[] generateSessionKey(String plainPwd, byte[] encryptKey, int alg) throws NoSuchAlgorithmException {
        byte[] sessKey = null;
        MessageDigest md4 = null;
        String pwd = plainPwd;
        if (pwd == null) {
            pwd = "";
        }
        switch (alg) {
            case 1: {
                byte[] pwdBytes = new byte[pwd.length() * 2];
                for (int i = 0; i < pwd.length(); ++i) {
                    char ch = plainPwd.charAt(i);
                    pwdBytes[i * 2] = (byte)ch;
                    pwdBytes[i * 2 + 1] = (byte)(ch >> 8 & 0xFF);
                }
                md4 = MessageDigest.getInstance("MD4");
                md4.update(pwdBytes);
                md4.update(md4.digest());
                sessKey = new byte[40];
                System.arraycopy(md4.digest(), 0, sessKey, 0, 16);
                byte[] ntlmHash = this.generateEncryptedPassword(plainPwd, encryptKey, 1);
                System.arraycopy(ntlmHash, 0, sessKey, 16, 24);
            }
        }
        return sessKey;
    }

    @Override
    public final byte[] P16(String pwd, byte[] s8) throws NoSuchAlgorithmException {
        StringBuffer p14str = new StringBuffer();
        p14str.append(pwd.toUpperCase());
        if (p14str.length() > 14) {
            p14str.setLength(14);
        }
        while (p14str.length() < 14) {
            p14str.append('\u0000');
        }
        byte[] p14 = p14str.toString().getBytes();
        byte[] p16 = new byte[16];
        try {
            Cipher des = Cipher.getInstance("DES");
            byte[] key = this.generateKey(p14, 0);
            SecretKeySpec chKey = new SecretKeySpec(key, 0, key.length, "DES");
            des.init(1, chKey);
            byte[] res = des.doFinal(s8);
            System.arraycopy(res, 0, p16, 0, 8);
            key = this.generateKey(p14, 7);
            chKey = new SecretKeySpec(key, 0, key.length, "DES");
            des.init(1, chKey);
            res = des.doFinal(s8);
            System.arraycopy(res, 0, p16, 8, 8);
        }
        catch (NoSuchPaddingException ex) {
            p16 = null;
        }
        catch (IllegalBlockSizeException ex) {
            p16 = null;
        }
        catch (BadPaddingException ex) {
            p16 = null;
        }
        catch (InvalidKeyException ex) {
            p16 = null;
        }
        return p16;
    }

    private final byte[] P24(String pwd, byte[] c8) throws NoSuchAlgorithmException {
        byte[] s8 = "KGS!@#$%".getBytes();
        byte[] p16 = this.P16(pwd, s8);
        return this.P24(p16, c8);
    }

    @Override
    protected byte[] P24(byte[] p21, byte[] ch) throws NoSuchAlgorithmException {
        byte[] enc = null;
        try {
            Cipher des = Cipher.getInstance("DES");
            enc = new byte[24];
            byte[] key = this.generateKey(p21, 0);
            SecretKeySpec chKey = new SecretKeySpec(key, 0, key.length, "DES");
            des.init(1, chKey);
            byte[] res = des.doFinal(ch);
            System.arraycopy(res, 0, enc, 0, 8);
            key = this.generateKey(p21, 7);
            chKey = new SecretKeySpec(key, 0, key.length, "DES");
            des.init(1, chKey);
            res = des.doFinal(ch);
            System.arraycopy(res, 0, enc, 8, 8);
            key = this.generateKey(p21, 14);
            chKey = new SecretKeySpec(key, 0, key.length, "DES");
            des.init(1, chKey);
            res = des.doFinal(ch);
            System.arraycopy(res, 0, enc, 16, 8);
        }
        catch (NoSuchPaddingException ex) {
            ex.printStackTrace();
            enc = null;
        }
        catch (IllegalBlockSizeException ex) {
            ex.printStackTrace();
            enc = null;
        }
        catch (BadPaddingException ex) {
            ex.printStackTrace();
            enc = null;
        }
        catch (InvalidKeyException ex) {
            ex.printStackTrace();
            enc = null;
        }
        return enc;
    }

    public static String getAlgorithmName(int alg) {
        if (alg >= 0 && alg < _algNames.length) {
            return _algNames[alg];
        }
        return "Unknown";
    }

    private byte[] generateKey(byte[] byt, int off) {
        byte[] key = new byte[]{(byte)(byt[off + 0] >> 1), (byte)((byt[off + 0] & 1) << 6 | (byt[off + 1] & 0xFF) >> 2), (byte)((byt[off + 1] & 3) << 5 | (byt[off + 2] & 0xFF) >> 3), (byte)((byt[off + 2] & 7) << 4 | (byt[off + 3] & 0xFF) >> 4), (byte)((byt[off + 3] & 0xF) << 3 | (byt[off + 4] & 0xFF) >> 5), (byte)((byt[off + 4] & 0x1F) << 2 | (byt[off + 5] & 0xFF) >> 6), (byte)((byt[off + 5] & 0x3F) << 1 | (byt[off + 6] & 0xFF) >> 7), (byte)(byt[off + 6] & 0x7F)};
        for (int i = 0; i < 8; ++i) {
            key[i] = (byte)(key[i] << 1);
        }
        return key;
    }
}

