/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client.admin;

import java.io.IOException;
import org.alfresco.jlan.client.IPCSession;
import org.alfresco.jlan.client.admin.IPCPipeFile;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.smb.dcerpc.DCEBuffer;
import org.alfresco.jlan.smb.dcerpc.DCEBufferException;
import org.alfresco.jlan.smb.dcerpc.client.DCEPacket;

public class InitShutPipeFile
extends IPCPipeFile {
    public InitShutPipeFile(IPCSession sess, DCEPacket pkt, int handle, String name, int maxTx, int maxRx) {
        super(sess, pkt, handle, name, maxTx, maxRx);
    }

    public final void shutdownServer(String msg, int tmo, boolean reboot, boolean force) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putPointer(true);
        buf.putPointer(true);
        buf.putPointer(true);
        buf.putUnicodeHeader(msg, false);
        buf.putString(msg, 1);
        buf.putInt(tmo);
        buf.putByte(force ? 1 : 0);
        buf.putByte(reboot ? 1 : 0);
        buf.putInt(0);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 0, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        buf = this.getRxBuffer();
        try {
            this.checkStatus(buf.getInt());
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
    }

    public final void abortShutdown() throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putPointer(true);
        buf.putPointer(true);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 1, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        buf = this.getRxBuffer();
        try {
            this.checkStatus(buf.getInt());
        }
        catch (DCEBufferException dCEBufferException) {
            // empty catch block
        }
    }
}

