/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client.admin;

import java.io.IOException;
import java.util.Enumeration;
import org.alfresco.jlan.client.IPCSession;
import org.alfresco.jlan.client.admin.IPCPipeFile;
import org.alfresco.jlan.client.admin.SamrPolicyHandle;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.smb.dcerpc.DCEBuffer;
import org.alfresco.jlan.smb.dcerpc.DCEBufferException;
import org.alfresco.jlan.smb.dcerpc.DCEException;
import org.alfresco.jlan.smb.dcerpc.PolicyHandle;
import org.alfresco.jlan.smb.dcerpc.PolicyHandleCache;
import org.alfresco.jlan.smb.dcerpc.client.DCEPacket;
import org.alfresco.jlan.smb.dcerpc.client.SIDCache;
import org.alfresco.jlan.smb.dcerpc.info.UserInfo;
import org.alfresco.jlan.smb.nt.LoadException;
import org.alfresco.jlan.smb.nt.RID;
import org.alfresco.jlan.smb.nt.RIDList;
import org.alfresco.jlan.smb.nt.SID;
import org.alfresco.jlan.smb.nt.SaveException;
import org.alfresco.jlan.smb.nt.WellKnownRID;
import org.alfresco.jlan.smb.nt.WellKnownSID;
import org.alfresco.jlan.util.StringList;

public class SamrPipeFile
extends IPCPipeFile {
    public static final int DefaultBufferSize = 65535;
    private SamrPolicyHandle m_handle;
    private SIDCache m_domainSIDs = new SIDCache();
    private PolicyHandleCache m_domainHandles = new PolicyHandleCache();

    public SamrPipeFile(IPCSession sess, DCEPacket pkt, int handle, String name, int maxTx, int maxRx) throws IOException, SMBException, DCEException {
        super(sess, pkt, handle, name, maxTx, maxRx);
        this.openService();
    }

    protected final SamrPolicyHandle openService() throws IOException, SMBException {
        if (this.m_handle != null) {
            return this.m_handle;
        }
        String remName = this.getSession().getPCShare().getNodeName();
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putPointer(true);
        buf.putString(remName, 1, true);
        buf.putInt(63);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 57, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        DCEBuffer rxBuf = this.getRxBuffer();
        this.m_handle = new SamrPolicyHandle();
        try {
            this.checkStatus(rxBuf.getStatusCode());
            rxBuf.getHandle(this.m_handle);
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        return this.m_handle;
    }

    public final StringList enumerateDomains() throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(this.getSamrHandle());
        buf.putInt(0);
        buf.putInt(8192);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 6, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        DCEBuffer rxBuf = this.getRxBuffer();
        StringList domains = new StringList();
        try {
            this.checkStatus(rxBuf.getStatusCode());
            int resume = rxBuf.getInt();
            if (rxBuf.getPointer() != 0) {
                int cnt = rxBuf.getInt();
                if (rxBuf.getPointer() != 0) {
                    rxBuf.skipBytes(4);
                    rxBuf.skipBytes(cnt * 12);
                    for (int i = 0; i < cnt; ++i) {
                        String name = rxBuf.getString(1);
                        if (name == null || name.equals("Builtin")) continue;
                        domains.addString(name);
                    }
                }
            }
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        return domains;
    }

    public final StringList enumerateGroups(String domain) throws IOException, SMBException {
        SID domSID = this.lookupDomain(domain);
        PolicyHandle domHandle = this.openDomain(domSID);
        DCEBuffer buf = this.getBuffer();
        int resumeId = 0;
        StringList groups = new StringList();
        boolean moreGroups = true;
        while (moreGroups) {
            buf.resetBuffer();
            buf.putHandle(domHandle);
            buf.putInt(resumeId);
            buf.putInt(-1);
            DCEPacket pkt = this.getPacket();
            try {
                pkt.initializeDCERequest(this.getHandle(), 11, buf, this.getMaximumTransmitSize(), this.getNextCallId());
            }
            catch (DCEBufferException ex) {
                ex.printStackTrace();
            }
            this.doDCERequest(pkt);
            DCEBuffer rxBuf = this.getRxBuffer();
            try {
                if (!rxBuf.hasMoreEntries()) {
                    moreGroups = false;
                } else {
                    this.checkStatus(rxBuf.getStatusCode());
                }
                resumeId = rxBuf.getInt();
                if (rxBuf.getPointer() == 0) continue;
                int cnt = rxBuf.getInt();
                if (rxBuf.getPointer() == 0) continue;
                rxBuf.skipBytes(4);
                rxBuf.skipBytes(cnt * 12);
                for (int i = 0; i < cnt; ++i) {
                    String name = rxBuf.getString(1);
                    if (name == null) continue;
                    groups.addString(name);
                }
            }
            catch (DCEBufferException ex) {
            }
        }
        return groups;
    }

    public final StringList enumerateUsers(String domain) throws IOException, SMBException {
        SID domSID = this.lookupDomain(domain);
        PolicyHandle domHandle = this.openDomain(domSID);
        DCEBuffer buf = this.getBuffer();
        int resumeId = 0;
        StringList users = new StringList();
        boolean moreUsers = true;
        while (moreUsers) {
            buf.resetBuffer();
            buf.putHandle(domHandle);
            buf.putInt(resumeId);
            buf.putInt(16);
            buf.putInt(65535);
            DCEPacket pkt = this.getPacket();
            try {
                pkt.initializeDCERequest(this.getHandle(), 13, buf, this.getMaximumTransmitSize(), this.getNextCallId());
            }
            catch (DCEBufferException ex) {
                ex.printStackTrace();
            }
            this.doDCERequest(pkt);
            DCEBuffer rxBuf = this.getRxBuffer();
            try {
                if (rxBuf.hasSuccessStatus()) {
                    moreUsers = false;
                }
                if (rxBuf.hasMoreEntries()) {
                    moreUsers = true;
                } else {
                    this.checkStatus(rxBuf.getStatusCode());
                }
                resumeId = rxBuf.getInt();
                if (rxBuf.getPointer() == 0) continue;
                int cnt = rxBuf.getInt();
                if (rxBuf.getPointer() == 0) continue;
                rxBuf.skipBytes(4);
                rxBuf.skipBytes(cnt * 12);
                for (int i = 0; i < cnt; ++i) {
                    String name = rxBuf.getString(1);
                    if (name == null) continue;
                    users.addString(name);
                }
            }
            catch (DCEBufferException ex) {
            }
        }
        return users;
    }

    public final StringList enumerateAliases(String domain) throws IOException, SMBException {
        SID domSID = this.lookupDomain(domain);
        PolicyHandle domHandle = this.openDomain(domSID);
        DCEBuffer buf = this.getBuffer();
        int resumeId = 0;
        StringList aliases = new StringList();
        boolean moreAliases = true;
        while (moreAliases) {
            buf.resetBuffer();
            buf.putHandle(domHandle);
            buf.putInt(resumeId);
            buf.putInt(-1);
            DCEPacket pkt = this.getPacket();
            try {
                pkt.initializeDCERequest(this.getHandle(), 15, buf, this.getMaximumTransmitSize(), this.getNextCallId());
            }
            catch (DCEBufferException ex) {
                ex.printStackTrace();
            }
            this.doDCERequest(pkt);
            DCEBuffer rxBuf = this.getRxBuffer();
            try {
                if (rxBuf.hasSuccessStatus()) {
                    moreAliases = false;
                }
                if (rxBuf.hasMoreEntries()) {
                    moreAliases = true;
                } else {
                    this.checkStatus(rxBuf.getStatusCode());
                }
                resumeId = rxBuf.getInt();
                if (rxBuf.getPointer() == 0) continue;
                int cnt = rxBuf.getInt();
                if (rxBuf.getPointer() == 0) continue;
                rxBuf.skipBytes(4);
                rxBuf.skipBytes(cnt * 12);
                for (int i = 0; i < cnt; ++i) {
                    String name = rxBuf.getString(1);
                    if (name == null) continue;
                    aliases.addString(name);
                }
            }
            catch (DCEBufferException ex) {
            }
        }
        return aliases;
    }

    public final SID lookupDomain(String domain) throws IOException, SMBException {
        SID sid = this.m_domainSIDs.findSID(domain);
        if (sid != null) {
            return sid;
        }
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(this.getSamrHandle());
        buf.putUnicodeHeader(domain.length());
        buf.putString(domain, 1, false);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 5, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        DCEBuffer rxBuf = this.getRxBuffer();
        sid = new SID();
        try {
            this.checkStatus(rxBuf.getStatusCode());
            rxBuf.skipBytes(8);
            try {
                sid.loadSID(rxBuf.getBuffer(), rxBuf.getReadPosition(), true);
            }
            catch (LoadException ex) {
                throw new IOException("Failed to load SID object");
            }
            sid.setName(domain);
            this.m_domainSIDs.addSID(domain, sid);
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        return sid;
    }

    public final PolicyHandle openDomain(String domain) throws IOException, SMBException {
        PolicyHandle domHandle = this.m_domainHandles.findHandle(domain);
        if (domHandle != null) {
            return domHandle;
        }
        SID domSID = this.lookupDomain(domain);
        domHandle = this.openDomain(domSID);
        this.m_domainHandles.addHandle(domain, domHandle);
        return domHandle;
    }

    public final PolicyHandle openBuiltinDomain() throws IOException, SMBException {
        return this.openDomain(WellKnownSID.SIDBuiltinDomain);
    }

    public final PolicyHandle openDomain(SID domainSID) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(this.getSamrHandle());
        buf.putInt(773);
        buf.putInt(domainSID.getSubauthorityCount());
        int off = -1;
        try {
            off = domainSID.saveSID(buf.getBuffer(), buf.getWritePosition());
        }
        catch (SaveException ex) {
            throw new IOException("Failed to save SID object");
        }
        buf.setWritePosition(off);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 7, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        DCEBuffer rxBuf = this.getRxBuffer();
        PolicyHandle domHandle = new PolicyHandle();
        try {
            this.checkStatus(rxBuf.getStatusCode());
            rxBuf.getHandle(domHandle);
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        return domHandle;
    }

    public final RIDList lookupName(PolicyHandle domHandle, String name) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(domHandle);
        buf.putInt(1);
        buf.putInt(1000);
        buf.putInt(0);
        buf.putInt(1);
        buf.putUnicodeHeader(name.length());
        buf.putString(name, -1, false);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 17, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        DCEBuffer rxBuf = this.getRxBuffer();
        if (rxBuf.getStatusCode() != 0 && rxBuf.getStatusCode() != -1073741709) {
            this.checkStatus(rxBuf.getStatusCode());
        }
        RIDList rids = this.unpackRIDList(rxBuf, name);
        return rids;
    }

    public final RIDList lookupName(SID sid) throws IOException, SMBException {
        if (this.m_domainSIDs.numberOfSIDs() == 0) {
            this.populateDomainSIDCache();
        }
        if (WellKnownSID.getSIDName(sid) != null) {
            return null;
        }
        String domainName = this.m_domainSIDs.findName(sid);
        if (domainName == null) {
            return null;
        }
        if (!sid.hasRID()) {
            sid.setName(domainName);
            RIDList list = new RIDList();
            list.addRID(new RID(-1, 3, domainName));
            return list;
        }
        PolicyHandle handle = this.openDomain(domainName);
        int[] ids = new int[]{sid.getRID()};
        RIDList list = this.lookupIds(handle, ids);
        StringBuffer objName = new StringBuffer();
        objName.append(domainName);
        objName.append("\\");
        objName.append(list.getRIDAt(0).getName());
        sid.setName(objName.toString());
        return list;
    }

    public final String lookupDomainName(SID sid) throws IOException, SMBException {
        if (this.m_domainSIDs.numberOfSIDs() == 0) {
            this.populateDomainSIDCache();
        }
        return this.m_domainSIDs.findName(sid);
    }

    public final RIDList lookupIds(PolicyHandle domHandle, RIDList rids) throws IOException, SMBException {
        int[] ids = rids.getIdList();
        RIDList nameList = this.lookupIds(domHandle, ids, ids.length);
        for (int i = 0; i < nameList.numberOfRIDs(); ++i) {
            RID nameRID = nameList.getRIDAt(i);
            RID idRID = rids.findRID(nameRID.getRID());
            if (idRID == null) continue;
            idRID.setName(nameRID.getName());
            idRID.setType(nameRID.isType());
        }
        return rids;
    }

    public final RIDList lookupIds(PolicyHandle domHandle, int[] ids) throws IOException, SMBException {
        return this.lookupIds(domHandle, ids, ids.length);
    }

    public final RIDList lookupIds(PolicyHandle domHandle, int[] ids, int count) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(domHandle);
        buf.putInt(count);
        buf.putInt(1000);
        buf.putInt(0);
        buf.putInt(count);
        for (int i = 0; i < count; ++i) {
            buf.putInt(ids[i]);
        }
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 18, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        DCEBuffer rxBuf = this.getRxBuffer();
        this.checkStatus(rxBuf.getStatusCode());
        RIDList rids = this.unpackRIDNameList(rxBuf, ids, count);
        return rids;
    }

    public final PolicyHandle openUser(PolicyHandle domHandle, RID rid) throws IOException, SMBException {
        return this.openUser(domHandle, rid.getRID());
    }

    public final PolicyHandle openUser(String domain, String userName) throws IOException, SMBException {
        PolicyHandle domainHandle = this.openDomain(domain);
        RIDList rids = this.lookupName(domainHandle, userName);
        RID userRID = rids.findRID(userName, 1);
        PolicyHandle userHandle = null;
        if (userRID == null) {
            throw new SMBException(6, -1073741772);
        }
        userHandle = this.openUser(domainHandle, userRID);
        return userHandle;
    }

    public final PolicyHandle openUser(PolicyHandle domHandle, int rid) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(domHandle);
        buf.putInt(795);
        buf.putInt(rid);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 34, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        DCEBuffer rxBuf = this.getRxBuffer();
        PolicyHandle usrHandle = new PolicyHandle();
        try {
            this.checkStatus(rxBuf.getStatusCode());
            rxBuf.getHandle(usrHandle);
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        return usrHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RIDList getGroupsForUser(String domain, String userName) throws IOException, SMBException {
        PolicyHandle userHandle = this.openUser(domain, userName);
        RIDList groups = null;
        try {
            groups = this.getGroupsForUser(userHandle);
            if (groups != null) {
                groups = this.lookupIds(this.openDomain(domain), groups);
            }
        }
        finally {
            if (userHandle != null) {
                this.closeHandle(userHandle);
            }
        }
        return groups;
    }

    public final RIDList getGroupsForUser(PolicyHandle usrHandle) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(usrHandle);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 39, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        DCEBuffer rxBuf = this.getRxBuffer();
        RIDList rids = new RIDList();
        try {
            int cnt;
            this.checkStatus(rxBuf.getStatusCode());
            if (rxBuf.getPointer() != 0 && (cnt = rxBuf.getInt()) > 0 && rxBuf.getPointer() != 0) {
                rxBuf.skipBytes(4);
                for (int i = 0; i < cnt; ++i) {
                    int rid = rxBuf.getInt();
                    int attr = rxBuf.getInt();
                    rids.addRID(new RID(rid, WellKnownRID.isWellKnownGroup(rid) ? 5 : 2, WellKnownRID.getWellKnownGroupName(rid)));
                }
            }
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        return rids;
    }

    public final RIDList getAliasesForUser(String domain, String userName) throws IOException, SMBException {
        SID domSID = this.lookupDomain(domain);
        PolicyHandle domHandle = this.openDomain(domSID);
        PolicyHandle builtinHandle = this.openBuiltinDomain();
        RIDList rids = this.lookupName(domHandle, userName);
        RID userRID = rids.findRID(userName, 1);
        if (userRID == null) {
            throw new SMBException(6, -1073741772);
        }
        SID userSID = new SID(domSID);
        userSID.setRID(userRID.getRID());
        RIDList domAliasList = this.getAliasesForUser(domHandle, userSID);
        domAliasList = domAliasList != null ? this.lookupIds(domHandle, domAliasList) : new RIDList();
        RIDList builtinList = this.getAliasesForUser(builtinHandle, userSID);
        if (builtinList != null) {
            builtinList = this.lookupIds(builtinHandle, builtinList);
        }
        domAliasList.addRIDs(builtinList);
        return domAliasList;
    }

    public final RIDList getAliasesForUser(PolicyHandle domHandle, SID userSID) throws IOException, SMBException {
        SID usersGroupSID = new SID(userSID);
        usersGroupSID.setRID(513);
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(domHandle);
        buf.putInt(1);
        buf.putPointer(true);
        buf.putInt(1);
        buf.putPointer(true);
        buf.putInt(userSID.getSubauthorityCount());
        int off = -1;
        try {
            off = userSID.saveSID(buf.getBuffer(), buf.getWritePosition());
        }
        catch (SaveException ex) {
            throw new IOException("Failed to save user SID object");
        }
        buf.setWritePosition(off);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 16, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        DCEBuffer rxBuf = this.getRxBuffer();
        RIDList rids = new RIDList();
        try {
            this.checkStatus(rxBuf.getStatusCode());
            int cnt = rxBuf.getInt();
            if (cnt > 0 && rxBuf.getPointer() != 0) {
                rxBuf.skipBytes(4);
                for (int i = 0; i < cnt; ++i) {
                    int rid = rxBuf.getInt();
                    rids.addRID(new RID(rid, 4, WellKnownRID.getWellKnownAliasName(rid)));
                }
            }
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        return rids;
    }

    public final UserInfo queryUserInformation(PolicyHandle usrHandle, int infoLevel) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(usrHandle);
        buf.putShort(infoLevel);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 36, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        DCEBuffer rxBuf = this.getRxBuffer();
        UserInfo usrInfo = null;
        try {
            this.checkStatus(rxBuf.getStatusCode());
            int ptr = rxBuf.getPointer();
            int lev = rxBuf.getShort(1);
            if (ptr != 0) {
                usrInfo = new UserInfo(lev);
                usrInfo.readObject(rxBuf);
                usrInfo.readStrings(rxBuf);
            }
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        return usrInfo;
    }

    public final void closeHandle(PolicyHandle handle) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(handle);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 1, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.getSession().SendTransaction(pkt, pkt);
        if (!pkt.isValidResponse()) {
            throw new SMBException(6, pkt.getLongErrorCode());
        }
    }

    @Override
    public void ClosePipe() throws IOException, SMBException {
        if (this.getSamrHandle() != null) {
            this.closeHandle(this.m_handle);
            this.m_handle = null;
        }
        super.ClosePipe();
    }

    private final RIDList unpackRIDList(DCEBuffer buf, String rscName) {
        RIDList rids = null;
        try {
            int i;
            rids = new RIDList();
            int cnt = buf.getInt();
            if (cnt > 0 && buf.getPointer() != 0) {
                buf.skipBytes(4);
                for (i = 0; i < cnt; ++i) {
                    int id = buf.getInt();
                    RID rid = new RID(id, -1, rscName);
                    rids.addRID(rid);
                }
            }
            if ((cnt = buf.getInt()) > 0 && buf.getPointer() != 0) {
                buf.skipBytes(4);
                for (i = 0; i < cnt; ++i) {
                    RID curRID = rids.getRIDAt(i);
                    int typ = buf.getInt();
                    curRID.setType(typ);
                }
            }
        }
        catch (DCEBufferException ex) {
            rids = null;
        }
        return rids;
    }

    private final RIDList unpackRIDNameList(DCEBuffer buf, int[] ids, int count) {
        RIDList rids = null;
        try {
            int i;
            rids = new RIDList();
            int cnt = buf.getInt();
            if (cnt > 0 && buf.getPointer() != 0) {
                buf.skipBytes(4 + 8 * cnt);
                for (i = 0; i < cnt; ++i) {
                    String rscName = buf.getCharArray(1);
                    RID rid = new RID(ids[i], -1, rscName);
                    rids.addRID(rid);
                }
            }
            if ((cnt = buf.getInt()) > 0 && buf.getPointer() != 0) {
                buf.skipBytes(4);
                for (i = 0; i < cnt; ++i) {
                    RID curRID = rids.getRIDAt(i);
                    int typ = buf.getInt();
                    curRID.setType(typ);
                }
            }
        }
        catch (DCEBufferException ex) {
            rids = null;
        }
        return rids;
    }

    private final SamrPolicyHandle getSamrHandle() {
        return this.m_handle;
    }

    public final void clearCaches() throws IOException, SMBException {
        this.m_domainSIDs.removeAllSIDs();
        Enumeration<PolicyHandle> enm = this.m_domainHandles.enumerateHandles();
        while (enm.hasMoreElements()) {
            PolicyHandle domainHandle = enm.nextElement();
            this.closeHandle(domainHandle);
        }
        this.m_domainHandles.removeAllHandles();
    }

    private final void populateDomainSIDCache() throws IOException, SMBException {
        StringList domains = this.enumerateDomains();
        for (int i = 0; i < domains.numberOfStrings(); ++i) {
            String name = domains.getStringAt(i);
            SID domSid = this.lookupDomain(name);
            this.m_domainSIDs.addSID(name, domSid);
        }
        SID builtin = WellKnownSID.SIDBuiltinDomain;
        this.m_domainSIDs.addSID(builtin.getName(), builtin);
    }
}

