/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client.demo;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.alfresco.jlan.client.SessionFactory;
import org.alfresco.jlan.client.admin.AdminSession;
import org.alfresco.jlan.client.admin.WinregPipeFile;
import org.alfresco.jlan.client.demo.jlanApp;
import org.alfresco.jlan.smb.PCShare;
import org.alfresco.jlan.smb.dcerpc.client.Winreg;
import org.alfresco.jlan.smb.dcerpc.info.RegistryKey;
import org.alfresco.jlan.smb.dcerpc.info.RegistryValue;
import org.alfresco.jlan.util.HexDump;
import org.alfresco.jlan.util.NameValue;
import org.alfresco.jlan.util.NameValueList;

public class jlanRegistry
extends jlanApp {
    private int m_rootKey;
    private String m_subKey;

    public jlanRegistry() {
        super("jlanRegistry", "Display remote registry keys/values");
    }

    @Override
    protected void outputCommandHelp(PrintStream out) {
        out.println("Usage: jlanRegistry <host>|<ip_address> <key_name> -username=<username> -password=<password>");
        out.println("The <key_name> must start with one of the following root key names :-");
        out.println("  HKEY_LOCAL_MACHINE or HKLM");
        out.println("  HKEY_USERS or HKU");
        out.println("  HKEY_CLASSES_ROOT or HKCR");
        out.println("  HKEY_CURRENT_USER or HKCU");
    }

    @Override
    protected void doCommand(PrintStream out) throws Exception {
        AdminSession sess = SessionFactory.OpenAdminSession(this.getShare());
        this.setSession(sess.getSession());
        WinregPipeFile regPipe = sess.openWindowsRegistryPipe();
        if (regPipe == null) {
            throw new Exception("Failed to open service control pipe, WinReg");
        }
        RegistryKey rootKey = regPipe.openRootKey(this.getRootKey());
        if (rootKey == null) {
            throw new IOException("Failed to open root registry key");
        }
        RegistryKey subKey = null;
        subKey = this.hasSubkeyPath() ? regPipe.openKey(rootKey, this.getSubkeyPath()) : rootKey;
        out.print("Registry key ");
        out.print(Winreg.getRootIdAsLongName(this.getRootKey()));
        out.print("\\");
        out.println(this.getSubkeyPath());
        out.println();
        List<RegistryKey> keys = regPipe.getKeysForKey(subKey);
        out.println("Keys:");
        if (keys != null && keys.size() > 0) {
            for (int i = 0; i < keys.size(); ++i) {
                RegistryKey key = keys.get(i);
                out.println("  " + key.getFullName());
            }
        } else {
            out.println("  None");
        }
        out.println();
        List<RegistryValue> values = regPipe.getValuesForKey(subKey);
        out.println("Values:");
        out.println();
        if (values != null && values.size() > 0) {
            this.formatOutput(out, "Name", 30, "Type", 15, "Value", -1);
            this.formatOutput(out, "----", 30, "----", 15, "-----", -1);
            for (int i = 0; i < values.size(); ++i) {
                RegistryValue value = values.get(i);
                if (value.getDataType() == 1 || value.getDataType() == 4 || value.getDataType() == 7) {
                    this.formatOutput(out, value.getName(), 30, value.getDataTypeString(), 15, value.getValue().toString(), 55);
                    continue;
                }
                byte[] val = (byte[])value.getValue();
                this.formatOutput(out, value.getName(), 30, value.getDataTypeString(), 15, HexDump.hexString(val, val.length < 20 ? val.length : 20, " "), -1);
            }
        } else {
            out.println("  None");
        }
        regPipe.closeHandle(subKey);
        if (rootKey.isOpen()) {
            regPipe.closeHandle(rootKey);
        }
        regPipe.ClosePipe();
        sess.CloseSession();
        this.setSession(null);
    }

    @Override
    protected boolean validateCommandLine(NameValueList cmdLine, PrintStream out) {
        if (cmdLine.numberOfItems() == 0) {
            out.println("%% Host name or address must be specified");
            return false;
        }
        if (cmdLine.numberOfItems() > 4) {
            out.println("%% Too many command line arguments");
            return false;
        }
        NameValue arg1 = cmdLine.findItem("Arg1");
        if (arg1 == null || arg1.getValue() == null || arg1.getValue().length() == 0) {
            out.println("%% Invalid host name specified, " + arg1 != null ? arg1.getValue() : "");
            return false;
        }
        NameValue arg2 = cmdLine.findItem("Arg2");
        if (arg2 == null || arg2.getValue() == null || arg2.getValue().length() == 0) {
            out.println("%% Invalid key name specified, " + (arg2 != null ? arg2.getValue() : ""));
            return false;
        }
        String keyName = arg2.getValue();
        keyName = keyName.replace('/', '\\');
        String keyPath = "";
        int pos = keyName.indexOf("\\");
        if (pos != -1) {
            keyPath = keyName.substring(pos + 1);
            keyName = keyName.substring(0, pos);
        }
        PCShare share = new PCShare(arg1.getValue(), "IPC$", this.getUserName(), this.getPassword());
        int rootId = -1;
        if (keyName.equalsIgnoreCase("HKEY_LOCAL_MACHINE") || keyName.equalsIgnoreCase("HKLM")) {
            rootId = 0;
        } else if (keyName.equalsIgnoreCase("HKEY_USERS") || keyName.equalsIgnoreCase("HKU")) {
            rootId = 3;
        } else if (keyName.equalsIgnoreCase("HKEY_CLASSES_ROOT") || keyName.equalsIgnoreCase("HKCR")) {
            rootId = 1;
        } else if (keyName.equalsIgnoreCase("HKEY_CURRENT_USER") || keyName.equalsIgnoreCase("HKCU")) {
            rootId = 2;
        }
        if (rootId == -1) {
            out.println("%% Invalid root key name, " + keyName);
            return false;
        }
        this.setRootKey(rootId);
        this.setSubkeyPath(keyPath);
        this.setShare(share);
        return true;
    }

    protected final int getRootKey() {
        return this.m_rootKey;
    }

    protected final boolean hasSubkeyPath() {
        return this.m_subKey != null && this.m_subKey.length() > 0;
    }

    protected final String getSubkeyPath() {
        return this.m_subKey;
    }

    protected final void setRootKey(int root) {
        this.m_rootKey = root;
    }

    protected final void setSubkeyPath(String subkey) {
        this.m_subKey = subkey;
    }

    public static void main(String[] args) {
        jlanRegistry cmd = new jlanRegistry();
        cmd.runCommand(args);
    }
}

