/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client.demo;

import java.io.PrintStream;
import org.alfresco.jlan.client.SessionFactory;
import org.alfresco.jlan.client.admin.AdminSession;
import org.alfresco.jlan.client.admin.SvcctlPipeFile;
import org.alfresco.jlan.client.demo.jlanApp;
import org.alfresco.jlan.smb.PCShare;
import org.alfresco.jlan.smb.dcerpc.info.NTService;
import org.alfresco.jlan.smb.dcerpc.info.ServiceStatusInfo;
import org.alfresco.jlan.smb.dcerpc.info.ServiceStatusList;
import org.alfresco.jlan.util.NameValue;
import org.alfresco.jlan.util.NameValueList;

public class jlanServices
extends jlanApp {
    private static final String[] _svcTypesStr = new String[]{"All", "Driver", "FileSys", "Adapter", "Interactive"};
    private static final int[] _svcTypes = new int[]{63, 15, 2, 4, 256};
    private int m_serviceType = 63;

    public jlanServices() {
        super("jlanServices", "List services on a remote server");
    }

    @Override
    protected void outputCommandHelp(PrintStream out) {
        out.println("Usage: jlanServices <host>|<ip_address> [<service_type>] -username=<username> -password=<password>");
        out.println("  <service_type> may be one of the following :-");
        out.println("    All         Display all services. [Default]");
        out.println("    Driver      Device driver services");
        out.println("    FileSys     Filesystem services");
        out.println("    Adapter     Network adapter services");
        out.println("    Interactive Services that interact with the desktop");
    }

    @Override
    protected void doCommand(PrintStream out) throws Exception {
        AdminSession sess = SessionFactory.OpenAdminSession(this.getShare());
        this.setSession(sess.getSession());
        SvcctlPipeFile svcPipe = sess.openServiceManagerPipe();
        if (svcPipe == null) {
            throw new Exception("Failed to open service control pipe, SvcCtl");
        }
        ServiceStatusList stsList = svcPipe.getServiceList(this.getServiceType(), 3);
        if (stsList != null && stsList.numberOfServices() > 0) {
            this.formatOutput(System.out, "Display Name", 40, "Name", 20, "Type", 15, "State", -1);
            this.formatOutput(System.out, "------------", 40, "----", 20, "----", 15, "-----", -1);
            for (int i = 0; i < stsList.numberOfServices(); ++i) {
                ServiceStatusInfo stsInfo = stsList.getInfo(i);
                this.formatOutput(System.out, stsInfo.getDisplayName(), 40, stsInfo.getName(), 20, NTService.getTypeAsString(stsInfo.getType()), 15, NTService.getStateAsString(stsInfo.getCurrentState()), 20);
            }
        } else {
            out.println("No services to display");
        }
        svcPipe.ClosePipe();
        sess.CloseSession();
        this.setSession(null);
    }

    @Override
    protected boolean validateCommandLine(NameValueList cmdLine, PrintStream out) {
        if (cmdLine.numberOfItems() == 0) {
            out.println("%% Host name or address must be specified");
            return false;
        }
        if (cmdLine.numberOfItems() > 5) {
            out.println("%% Too many command line arguments");
            return false;
        }
        NameValue arg1 = cmdLine.findItem("Arg1");
        if (arg1 == null || arg1.getValue() == null || arg1.getValue().length() == 0) {
            out.println("%% Invalid host name specified, " + arg1 != null ? arg1.getValue() : "");
            return false;
        }
        NameValue arg2 = cmdLine.findItem("Arg2");
        if (arg2 != null) {
            int svcType = -1;
            for (int i = 0; i < _svcTypesStr.length; ++i) {
                if (!_svcTypesStr[i].equalsIgnoreCase(arg2.getValue())) continue;
                svcType = _svcTypes[i];
            }
            if (svcType == -1) {
                out.println("%% Invalid service type - " + arg2.getValue());
                return false;
            }
            this.setServiceType(svcType);
        }
        PCShare share = new PCShare(arg1.getValue(), "IPC$", this.getUserName(), this.getPassword());
        this.setShare(share);
        return true;
    }

    protected final int getServiceType() {
        return this.m_serviceType;
    }

    protected final void setServiceType(int filter) {
        this.m_serviceType = filter;
    }

    public static void main(String[] args) {
        jlanServices cmd = new jlanServices();
        cmd.runCommand(args);
    }
}

