/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client.demo;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import org.alfresco.jlan.client.CIFSDiskSession;
import org.alfresco.jlan.client.CIFSFile;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.client.SessionFactory;
import org.alfresco.jlan.client.admin.AdminSession;
import org.alfresco.jlan.client.admin.SamrPipeFile;
import org.alfresco.jlan.client.demo.jlanApp;
import org.alfresco.jlan.client.info.DeviceAttributesInfo;
import org.alfresco.jlan.client.info.DiskInfo;
import org.alfresco.jlan.client.info.ExtendedFileInfo;
import org.alfresco.jlan.client.info.FileInfo;
import org.alfresco.jlan.client.info.StreamInfo;
import org.alfresco.jlan.server.filesys.FileAttribute;
import org.alfresco.jlan.smb.InvalidUNCPathException;
import org.alfresco.jlan.smb.PCShare;
import org.alfresco.jlan.smb.SMBDate;
import org.alfresco.jlan.smb.nt.ACE;
import org.alfresco.jlan.smb.nt.ACL;
import org.alfresco.jlan.smb.nt.SecurityDescriptor;
import org.alfresco.jlan.util.MemorySize;
import org.alfresco.jlan.util.NameValue;
import org.alfresco.jlan.util.NameValueList;

public class jlanStat
extends jlanApp {
    private boolean m_basicInfo = false;
    private SimpleDateFormat m_formatter;

    public jlanStat() {
        super("jlanStat", "Remote file/folder detailed information");
    }

    @Override
    protected void outputCommandHelp(PrintStream out) {
        out.println("Usage: jlanStat \\\\<host>|<ip_address>\\<share_name>[\\<path\\<file>");
        out.println("  The UNC path to the file/folder may use forward or backslash characters.");
        out.println("  Access control may be embedded in the UNC path using:-");
        out.println("    \\\\<host>\\<share>[%username][:<password.]\\<path>\\...");
    }

    @Override
    protected void doCommand(PrintStream out) throws Exception {
        PCShare share = this.getShare();
        DiskSession sess = SessionFactory.OpenDisk(share);
        this.setSession(sess);
        String path = share.getRelativePath();
        if (!sess.FileExists(path) && !sess.isDirectory(path)) {
            out.println("%% File/folder does not exist - " + path);
        } else if (!this.m_basicInfo && sess instanceof CIFSDiskSession) {
            CIFSDiskSession cifsSess = (CIFSDiskSession)sess;
            DeviceAttributesInfo fileSys = cifsSess.NTGetDeviceAttributes();
            DiskInfo diskInfo = cifsSess.getDiskInformation();
            CIFSFile statFile = cifsSess.NTCreate(path, 131209, 128, 3, 1, 0L, 0);
            FileInfo fInfo = cifsSess.NTGetFileInformation(statFile.getFileId(), 263);
            out.println("File name : " + path);
            out.println();
            out.println("Creation date : " + this.formatDate(fInfo.getCreationDateTime()));
            out.println("Last access   : " + this.formatDate(fInfo.getAccessDateTime()));
            out.println("Last write    : " + this.formatDate(fInfo.getModifyDateTime()));
            out.println();
            out.println("File size       : " + MemorySize.asScaledString(fInfo.getSize()) + " (" + fInfo.getSize() + " bytes)");
            out.println("Allocation size : " + MemorySize.asScaledString(fInfo.getAllocationSize()) + " (" + fInfo.getAllocationSize() + " bytes)");
            out.println();
            out.println("Attributes : " + FileAttribute.getNTAttributesAsString(fInfo.getFileAttributes()));
            out.println("Filesystem : " + fileSys.getFileSystemName() + ", Free space " + MemorySize.asScaledString(diskInfo.getDiskFreeSizeBytes()) + ", Total space " + MemorySize.asScaledString(diskInfo.getDiskSizeBytes()));
            if (fileSys.getFileSystemName().equals("NTFS")) {
                ExtendedFileInfo streamInfo = (ExtendedFileInfo)cifsSess.NTGetFileInformation(statFile.getFileId(), 265);
                if (streamInfo != null && streamInfo.hasNTFSStreams()) {
                    out.println();
                    out.println("NTFS Streams :");
                    for (int i = 0; i < streamInfo.numberOfNTFSStreams(); ++i) {
                        StreamInfo sInfo = streamInfo.getNTFSStreams().getStreamAt(i);
                        out.println("  Name : " + sInfo.getName());
                        out.println("    Size       : " + MemorySize.asScaledString(sInfo.getSize()) + " (" + sInfo.getSize() + " bytes)");
                        out.println("    Allocation : " + MemorySize.asScaledString(sInfo.getAllocationSize()) + " (" + sInfo.getAllocationSize() + " bytes)");
                    }
                    out.println();
                }
                int flags = 7;
                SecurityDescriptor secDesc = cifsSess.NTQuerySecurityDescriptor(statFile.getFileId(), flags);
                if (secDesc != null) {
                    AdminSession admSess = SessionFactory.OpenAdminSession(this.getShare());
                    SamrPipeFile samr = admSess.openSecurityAccountsManagerPipe();
                    samr.lookupName(secDesc.getOwner());
                    samr.lookupName(secDesc.getGroup());
                    out.println("Security descriptor:");
                    out.println("  Owner : " + secDesc.getOwner());
                    out.println("  Group : " + secDesc.getGroup());
                    out.println("  DACL:");
                    ACL acl = secDesc.getDACL();
                    for (int i = 0; i < acl.numberOfEntries(); ++i) {
                        ACE ace = acl.getACE(i);
                        samr.lookupName(ace.getSID());
                        out.print("     ");
                        this.formatOutput(out, ace.getTypeAsString(), 10, ace.getAccessMaskAsString(), 14, ace.getSID().toString(), -1);
                    }
                    admSess.CloseSession();
                }
            }
            statFile.Close();
        } else {
            DiskInfo diskInfo = sess.getDiskInformation();
            FileInfo fInfo = sess.getFileInformation(path);
            out.println("File name : " + path);
            out.println();
            out.println("Creation date : " + this.formatDate(fInfo.getCreationDateTime()));
            out.println("Last access   : " + this.formatDate(fInfo.getAccessDateTime()));
            out.println("Last write    : " + this.formatDate(fInfo.getModifyDateTime()));
            out.println();
            out.println("File size       : " + MemorySize.asScaledString(fInfo.getSize()) + " (" + fInfo.getSize() + " bytes)");
            out.println("Allocation size : " + MemorySize.asScaledString(fInfo.getAllocationSize()) + " (" + fInfo.getAllocationSize() + " bytes)");
            out.println();
            out.println("Attributes : " + FileAttribute.getNTAttributesAsString(fInfo.getFileAttributes()));
            out.println("Filesystem : Free space " + MemorySize.asScaledString(diskInfo.getDiskFreeSizeBytes()) + ", Total space " + MemorySize.asScaledString(diskInfo.getDiskSizeBytes()));
        }
        sess.CloseSession();
        this.setSession(null);
    }

    @Override
    protected boolean validateCommandLine(NameValueList cmdLine, PrintStream out) {
        if (cmdLine.numberOfItems() < 1) {
            out.println("%% Wrong number of command line arguments");
            return false;
        }
        NameValue arg1 = cmdLine.findItem("Arg1");
        if (arg1 == null || arg1.getValue() == null || arg1.getValue().length() == 0) {
            out.println("%% Invalid command line argument, " + arg1 != null ? arg1.getValue() : "");
            return false;
        }
        PCShare share = null;
        try {
            share = new PCShare(arg1.getValue());
            this.setShare(share);
        }
        catch (InvalidUNCPathException ex) {
            out.println("%% Invalid UNC path, " + ex.toString());
            return false;
        }
        if (cmdLine.findItemCaseless("basic") != null) {
            this.m_basicInfo = true;
        }
        return true;
    }

    private final String formatDate(SMBDate date) {
        if (this.m_formatter == null) {
            this.m_formatter = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss.SSS");
        }
        if (date == null) {
            return "<Not Specified>";
        }
        return this.m_formatter.format(date);
    }

    public static void main(String[] args) {
        jlanStat cmd = new jlanStat();
        cmd.runCommand(args);
    }
}

