/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.debug;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import org.alfresco.jlan.debug.ConsoleDebug;
import org.alfresco.jlan.debug.DebugInterface;

public final class Debug {
    public static final boolean EnableInfo = true;
    public static final boolean EnableWarn = true;
    public static final boolean EnableError = true;
    public static final boolean EnableDbg = true;
    private static final String LineSeperator = System.getProperty("line.separator");
    public static final int Fatal = 0;
    public static final int Error = 1;
    public static final int Warn = 2;
    public static final int Info = 3;
    public static final int Debug = 4;
    private static DebugInterface m_debug = new ConsoleDebug();

    private Debug() {
    }

    public static final DebugInterface getDebugInterface() {
        return m_debug;
    }

    public static final void setDebugInterface(DebugInterface dbg) {
        m_debug = dbg;
    }

    public static final void print(String str) {
        m_debug.debugPrint(str);
    }

    public static final void print(String str, int level) {
        m_debug.debugPrint(str, level);
    }

    public static final void println(String str) {
        m_debug.debugPrintln(str);
    }

    public static final void println(String str, int level) {
        m_debug.debugPrintln(str, level);
    }

    public static final void println(Exception ex) {
        org.alfresco.jlan.debug.Debug.println(ex, 1);
    }

    public static final void println(Exception ex, int level) {
        m_debug.debugPrintln(ex, level);
    }

    public static final void println(Throwable ex) {
        org.alfresco.jlan.debug.Debug.println(ex, 1);
    }

    public static final void println(Throwable ex, int level) {
        StringWriter strWrt = new StringWriter();
        ex.printStackTrace(new PrintWriter((Writer)strWrt, true));
        StringTokenizer strTok = new StringTokenizer(strWrt.toString(), LineSeperator);
        while (strTok.hasMoreTokens()) {
            m_debug.debugPrintln(strTok.nextToken(), level);
        }
    }
}

