/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server;

public abstract class RequestPostProcessor {
    private static ThreadLocal<RequestPostProcessor> m_postProcessorList = new ThreadLocal();
    private RequestPostProcessor m_nextLink;

    private void linkPostProcessor(RequestPostProcessor postProc) {
        this.m_nextLink = postProc;
    }

    private boolean hasLinkedPostProcessor() {
        return this.m_nextLink != null;
    }

    private RequestPostProcessor getLinkedPostProcessor() {
        return this.m_nextLink;
    }

    public abstract void runProcessor();

    public static void queuePostProcessor(RequestPostProcessor postProc) {
        RequestPostProcessor curProc = m_postProcessorList.get();
        if (curProc == null) {
            m_postProcessorList.set(postProc);
        } else {
            while (curProc.hasLinkedPostProcessor()) {
                curProc = curProc.getLinkedPostProcessor();
            }
            curProc.linkPostProcessor(postProc);
        }
    }

    public static boolean hasPostProcessor() {
        return m_postProcessorList.get() != null;
    }

    public static RequestPostProcessor dequeuePostProcessor() {
        RequestPostProcessor headProc = m_postProcessorList.get();
        if (headProc != null) {
            m_postProcessorList.set(headProc.getLinkedPostProcessor());
        }
        return headProc;
    }

    public static RequestPostProcessor findPostProcessor(Class postProcClass) {
        RequestPostProcessor postProc;
        if (!RequestPostProcessor.hasPostProcessor()) {
            return null;
        }
        for (postProc = m_postProcessorList.get(); postProc != null && postProc.getClass() != postProcClass; postProc = postProc.getLinkedPostProcessor()) {
        }
        return postProc;
    }

    public static void removePostProcessorFromQueue(RequestPostProcessor postProcessor) {
        RequestPostProcessor curPostProc;
        RequestPostProcessor prevPostProc = null;
        for (curPostProc = m_postProcessorList.get(); curPostProc != null && curPostProc != postProcessor; curPostProc = curPostProc.getLinkedPostProcessor()) {
            prevPostProc = curPostProc;
        }
        if (curPostProc != null) {
            if (prevPostProc == null) {
                m_postProcessorList.set(postProcessor.getLinkedPostProcessor());
            } else {
                prevPostProc.linkPostProcessor(postProcessor.getLinkedPostProcessor());
            }
        }
    }
}

