/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.RealmCallback;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.auth.AuthenticatorException;
import org.alfresco.jlan.server.auth.CifsAuthenticator;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.auth.NTLanManAuthContext;
import org.alfresco.jlan.server.auth.UserAccount;
import org.alfresco.jlan.server.auth.kerberos.KerberosApReq;
import org.alfresco.jlan.server.auth.kerberos.KerberosDetails;
import org.alfresco.jlan.server.auth.kerberos.KrbAuthContext;
import org.alfresco.jlan.server.auth.kerberos.SessionSetupPrivilegedAction;
import org.alfresco.jlan.server.auth.ntlm.NTLM;
import org.alfresco.jlan.server.auth.ntlm.NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.NTLMv2Blob;
import org.alfresco.jlan.server.auth.ntlm.TargetInfo;
import org.alfresco.jlan.server.auth.ntlm.Type1NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.Type2NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.Type3NTLMMessage;
import org.alfresco.jlan.server.auth.spnego.NegTokenInit;
import org.alfresco.jlan.server.auth.spnego.NegTokenTarg;
import org.alfresco.jlan.server.auth.spnego.OID;
import org.alfresco.jlan.server.auth.spnego.SPNEGO;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.NoPooledMemoryException;
import org.alfresco.jlan.smb.dcerpc.UUID;
import org.alfresco.jlan.smb.server.CIFSConfigSection;
import org.alfresco.jlan.smb.server.SMBSrvException;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.jlan.smb.server.VirtualCircuit;
import org.alfresco.jlan.util.DataPacker;
import org.alfresco.jlan.util.HexDump;
import org.ietf.jgss.Oid;
import org.springframework.extensions.config.ConfigElement;

public class EnterpriseCifsAuthenticator
extends CifsAuthenticator
implements CallbackHandler {
    private static final String LoginConfigEntry = "JLANServerCIFS";
    private static final int NTLM_FLAGS = -1610087807;
    private boolean m_useRawNTLMSSP;
    private boolean m_acceptNTLMv1;
    private String m_accountName;
    private String m_password;
    private String m_krbRealm;
    private String m_loginEntryName = "JLANServerCIFS";
    private boolean m_enableTicketCracking;
    private LoginContext m_loginContext;
    private byte[] m_negTokenInit;

    public EnterpriseCifsAuthenticator() {
        this.setExtendedSecurity(true);
    }

    @Override
    public void initialize(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        super.initialize(config, params);
        if (params.getChild("disableSessionCleanup") != null) {
            this.setSessionCleanup(false);
            if (this.hasDebug()) {
                Debug.println("[SMB] Disabled session cleanup (for virtual circuit zero logons)");
            }
        }
        if (params.getChild("kerberosDebug") != null) {
            System.setProperty("sun.security.jgss.debug", "true");
            System.setProperty("sun.security.krb5.debug", "true");
            System.setProperty("com.ibm.security.jgss.debug", "all");
        }
        CIFSConfigSection cifsConfig = (CIFSConfigSection)config.getConfigSection("CIFS");
        ConfigElement krbRealm = params.getChild("Realm");
        if (krbRealm != null && krbRealm.getValue() != null && krbRealm.getValue().length() > 0) {
            StringBuffer cifsAccount;
            ConfigElement principal;
            this.m_krbRealm = krbRealm.getValue();
            ConfigElement srvPassword = params.getChild("Password");
            if (srvPassword == null || srvPassword.getValue() == null || srvPassword.getValue().length() <= 0) {
                throw new InvalidConfigurationException("CIFS service account password not specified");
            }
            this.m_password = srvPassword.getValue();
            ConfigElement loginEntry = params.getChild("LoginEntry");
            if (loginEntry != null) {
                if (loginEntry.getValue() != null && loginEntry.getValue().length() > 0) {
                    this.m_loginEntryName = loginEntry.getValue();
                } else {
                    throw new InvalidConfigurationException("Invalid login entry specified");
                }
            }
            if ((principal = params.getChild("Principal")) != null) {
                cifsAccount = new StringBuffer();
                cifsAccount.append(principal.getValue());
                cifsAccount.append("@");
                cifsAccount.append(this.m_krbRealm);
                this.m_accountName = cifsAccount.toString();
            } else {
                cifsAccount = new StringBuffer();
                cifsAccount.append("cifs/");
                cifsAccount.append(cifsConfig.getServerName().toLowerCase());
                cifsAccount.append("@");
                cifsAccount.append(this.m_krbRealm);
                this.m_accountName = cifsAccount.toString();
            }
            if (this.hasDebug()) {
                Debug.println("[SMB] Using principal - " + this.m_accountName);
            }
            try {
                this.m_loginContext = new LoginContext(this.m_loginEntryName, this);
                this.m_loginContext.login();
            }
            catch (LoginException ex) {
                if (this.hasDebug()) {
                    Debug.println("[SMB] CIFS Kerberos authenticator error - " + ex.getMessage());
                }
                throw new InvalidConfigurationException("Failed to login CIFS server service");
            }
            if (this.hasDebug()) {
                Debug.println("[SMB] Enabling mechTypes :-");
                Debug.println("       Kerberos5");
                Debug.println("       MS-Kerberos5");
            }
            Vector<Oid> mechTypes = new Vector<Oid>();
            mechTypes.add(OID.KERBEROS5);
            mechTypes.add(OID.MSKERBEROS5);
            if (params.getChild("disableNTLM") == null) {
                mechTypes.add(OID.NTLMSSP);
                if (this.hasDebug()) {
                    Debug.println("       NTLMSSP");
                }
            }
            try {
                String mecListMIC = null;
                StringBuffer mic = new StringBuffer();
                mic.append("cifs/");
                mic.append(cifsConfig.getServerName().toLowerCase());
                mic.append("@");
                mic.append(this.m_krbRealm);
                mecListMIC = mic.toString();
                NegTokenInit negTokenInit = new NegTokenInit(mechTypes, mecListMIC);
                this.m_negTokenInit = negTokenInit.encode();
            }
            catch (IOException ex) {
                if (this.hasDebug()) {
                    Debug.println("[SMB] Error creating SPNEGO NegTokenInit blob - " + ex.getMessage());
                }
                throw new InvalidConfigurationException("Failed to create SPNEGO NegTokenInit blob");
            }
            this.m_useRawNTLMSSP = false;
        } else {
            ConfigElement useSpnego = params.getChild("useSPNEGO");
            if (useSpnego != null) {
                Vector<Oid> mechTypes = new Vector<Oid>();
                mechTypes.add(OID.NTLMSSP);
                try {
                    NegTokenInit negTokenInit = new NegTokenInit(mechTypes, null);
                    this.m_negTokenInit = negTokenInit.encode();
                }
                catch (IOException ex) {
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Error creating SPNEGO NegTokenInit blob - " + ex.getMessage());
                    }
                    throw new InvalidConfigurationException("Failed to create SPNEGO NegTokenInit blob");
                }
                this.m_useRawNTLMSSP = false;
            } else {
                this.m_useRawNTLMSSP = true;
            }
        }
        ConfigElement disallowNTLMv1 = params.getChild("disallowNTLMv1");
        this.m_acceptNTLMv1 = disallowNTLMv1 == null;
        ConfigElement enableTktCracking = params.getChild("enableTicketCracking");
        boolean bl = this.m_enableTicketCracking = enableTktCracking != null;
        if (this.hasDebug() && this.m_enableTicketCracking) {
            Debug.println("[SMB] Kerberos ticket cracking enabled");
        }
    }

    private final boolean useRawNTLMSSP() {
        return this.m_useRawNTLMSSP;
    }

    private final boolean acceptNTLMv1Logon() {
        return this.m_acceptNTLMv1;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback cb;
            if (callbacks[i] instanceof NameCallback) {
                cb = (NameCallback)callbacks[i];
                ((NameCallback)cb).setName(this.m_accountName);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                cb = (PasswordCallback)callbacks[i];
                ((PasswordCallback)cb).setPassword(this.m_password.toCharArray());
                continue;
            }
            if (callbacks[i] instanceof RealmCallback) {
                cb = (RealmCallback)callbacks[i];
                ((TextInputCallback)cb).setText(this.m_krbRealm);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }

    @Override
    public int getEncryptionKeyLength() {
        return 8;
    }

    @Override
    public int getServerCapabilities() {
        return -2147425540;
    }

    @Override
    public void generateNegotiateResponse(SMBSrvSession sess, SMBSrvPacket respPkt, boolean extendedSecurity) throws AuthenticatorException {
        if (!extendedSecurity) {
            super.generateNegotiateResponse(sess, respPkt, extendedSecurity);
            return;
        }
        int flags2 = respPkt.getFlags2();
        respPkt.setFlags2(flags2 |= 0x4800);
        int pos = respPkt.getByteOffset();
        byte[] buf = respPkt.getBuffer();
        UUID serverGUID = sess.getSMBServer().getServerGUID();
        System.arraycopy(serverGUID.getBytes(), 0, buf, pos, 16);
        pos += 16;
        if (!this.useRawNTLMSSP()) {
            System.arraycopy(this.m_negTokenInit, 0, buf, pos, this.m_negTokenInit.length);
            pos += this.m_negTokenInit.length;
        }
        respPkt.setByteCount(pos - respPkt.getByteOffset());
    }

    @Override
    public void processSessionSetup(SMBSrvSession sess, SMBSrvPacket reqPkt) throws SMBSrvException {
        if (!reqPkt.checkPacketIsValid(12, 0)) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        if (reqPkt.getParameterCount() == 13) {
            this.doHashedPasswordLogon(sess, reqPkt);
            return;
        }
        int maxBufSize = reqPkt.getParameter(2);
        int maxMpx = reqPkt.getParameter(3);
        int vcNum = reqPkt.getParameter(4);
        int secBlobLen = reqPkt.getParameter(7);
        int capabs = reqPkt.getParameterLong(10);
        int dataPos = reqPkt.getByteOffset();
        byte[] buf = reqPkt.getBuffer();
        boolean isUni = reqPkt.isUnicode();
        int secBlobPos = dataPos;
        reqPkt.setPosition(dataPos += secBlobLen);
        String domain = "";
        if (reqPkt.hasMoreData() && (domain = reqPkt.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        String clientOS = "";
        if (reqPkt.hasMoreData() && (clientOS = reqPkt.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        if (this.hasDebug()) {
            Debug.println("[SMB] NT Session setup " + (this.useRawNTLMSSP() ? "NTLMSSP" : "SPNEGO") + ", MID=" + reqPkt.getMultiplexId() + ", UID=" + reqPkt.getUserId() + ", PID=" + reqPkt.getProcessId());
        }
        sess.setClientMaximumBufferSize(maxBufSize != 0 ? maxBufSize : 65540);
        sess.setClientMaximumMultiplex(maxMpx);
        sess.setClientCapabilities(capabs);
        ClientInfo client = ClientInfo.createInfo(null, null);
        client.setDomain(domain);
        client.setOperatingSystem(clientOS);
        client.setLogonType(0);
        if (sess.hasRemoteAddress()) {
            client.setClientAddress(sess.getRemoteAddress().getHostAddress());
        }
        client.setProcessId(reqPkt.getProcessId());
        Object setupObj = sess.getSetupObject(client.getProcessId());
        byte[] respBlob = null;
        boolean isNTLMSSP = false;
        try {
            if (secBlobLen >= NTLM.Signature.length) {
                int idx;
                for (idx = 0; idx < NTLM.Signature.length && buf[secBlobPos + idx] == NTLM.Signature[idx]; ++idx) {
                }
                if (idx == NTLM.Signature.length) {
                    isNTLMSSP = true;
                }
            }
            respBlob = isNTLMSSP ? this.doNtlmsspSessionSetup(sess, client, buf, secBlobPos, secBlobLen, isUni) : this.doSpnegoSessionSetup(sess, client, buf, secBlobPos, secBlobLen, isUni);
        }
        catch (SMBSrvException ex) {
            sess.removeSetupObject(client.getProcessId());
            throw ex;
        }
        if (sess.hasDebug(32)) {
            if (respBlob == null) {
                Debug.println("[SMB] User " + client.getUserName() + " logged on " + (client != null ? " (type " + client.getLogonTypeString() + ")" : ""));
            } else {
                Debug.println("[SMB] Two stage logon (" + (isNTLMSSP ? "NTLMSSP" : "SPNEGO") + ")");
            }
        }
        int respLen = respBlob != null ? respBlob.length : 0;
        SMBSrvPacket respPkt = reqPkt;
        boolean loggedOn = false;
        if (respBlob != null || sess.hasSetupObject(client.getProcessId()) || setupObj != null) {
            if (sess.hasSetupObject(client.getProcessId())) {
                respPkt.setLongErrorCode(-1073741802);
            } else {
                respPkt.setLongErrorCode(0);
                loggedOn = true;
            }
            respPkt.setParameterCount(4);
            int reqLen = respLen + 100;
            if (reqLen > respPkt.getAvailableLength()) {
                try {
                    respPkt = sess.getPacketPool().allocatePacket(respPkt.getByteOffset() + reqLen, reqPkt);
                }
                catch (NoPooledMemoryException ex) {
                    if (this.hasDebug()) {
                        Debug.println("Authenticator failed to allocate packet from pool, reqSiz=" + (respPkt.getByteOffset() + respLen));
                    }
                    throw new SMBSrvException(-1073741811, 83, 2);
                }
            }
            respPkt.setParameter(0, 255);
            respPkt.setParameter(1, 0);
            respPkt.setParameter(2, 0);
            respPkt.setParameter(3, respLen);
        } else {
            respPkt.setLongErrorCode(0);
            respPkt.setParameterCount(12);
            respPkt.setParameter(0, 255);
            respPkt.setParameter(1, 0);
            respPkt.setParameter(2, 65540);
            respPkt.setParameter(3, 4);
            respPkt.setParameter(4, vcNum);
            respPkt.setParameterLong(5, 0);
            respPkt.setParameter(7, respLen);
            respPkt.setParameterLong(8, 0);
            respPkt.setParameterLong(10, this.getServerCapabilities());
            loggedOn = true;
        }
        int uid = 65535;
        if (loggedOn) {
            int discCnt;
            if (vcNum == 0 && this.hasSessionCleanup() && (discCnt = sess.disconnectClientSessions()) > 0 && sess.hasDebug(32)) {
                Debug.println("[SMB] Disconnected " + discCnt + " existing sessions from client, sess=" + sess);
            }
            sess.removeSetupObject(client.getProcessId());
            VirtualCircuit vc = new VirtualCircuit(vcNum, client);
            uid = sess.addVirtualCircuit(vc);
            if (uid == -1) {
                if (sess.hasDebug(32)) {
                    Debug.println("[SMB] Failed to allocate UID for virtual circuit, " + vc);
                }
                throw new SMBSrvException(-1073741618, 90, 2);
            }
            if (sess.hasDebug(32)) {
                Debug.println("[SMB] Allocated UID=" + uid + " for VC=" + vc);
            }
        }
        respPkt.setCommand(reqPkt.getCommand());
        respPkt.setByteCount(0);
        respPkt.setTreeId(loggedOn ? 0 : 65535);
        respPkt.setUserId(uid);
        int flags = respPkt.getFlags();
        respPkt.setFlags(flags &= 0xFFFFFFF7);
        int flags2 = 18433;
        if (isUni) {
            flags2 += 32768;
        }
        respPkt.setFlags2(flags2);
        int pos = respPkt.getByteOffset();
        buf = respPkt.getBuffer();
        if (respBlob != null) {
            System.arraycopy(respBlob, 0, buf, pos, respBlob.length);
            pos += respBlob.length;
        }
        if (isUni) {
            pos = DataPacker.wordAlign(pos);
        }
        pos = DataPacker.putString("Java", buf, pos, true, isUni);
        pos = DataPacker.putString("Alfresco CIFS Server " + sess.getServer().isVersion(), buf, pos, true, isUni);
        if (respBlob == null) {
            pos = DataPacker.putString(sess.getSMBServer().getCIFSConfiguration().getDomainName(), buf, pos, true, isUni);
        }
        respPkt.setByteCount(pos - respPkt.getByteOffset());
        respPkt.setParameter(1, pos - 4);
    }

    private final byte[] doNtlmsspSessionSetup(SMBSrvSession sess, ClientInfo client, byte[] secbuf, int secpos, int seclen, boolean unicode) throws SMBSrvException {
        int msgType = NTLMMessage.isNTLMType(secbuf, secpos);
        byte[] respBlob = null;
        if (msgType == -1) {
            if (this.hasDebug()) {
                Debug.println("[SMB] Invalid NTLMSSP token received");
                Debug.println("[SMB]   Token=" + HexDump.hexString(secbuf, secpos, seclen, " "));
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        if (msgType == 1) {
            Type1NTLMMessage type1Msg = new Type1NTLMMessage(secbuf, secpos, seclen);
            int ntlmFlags = type1Msg.getFlags() & 0xA0080281;
            NTLanManAuthContext ntlmCtx = new NTLanManAuthContext();
            String domain = sess.getSMBServer().getServerName();
            ArrayList<TargetInfo> tList = new ArrayList<TargetInfo>();
            tList.add(new TargetInfo(2, domain));
            tList.add(new TargetInfo(1, sess.getServerName()));
            tList.add(new TargetInfo(4, domain.toLowerCase()));
            tList.add(new TargetInfo(3, domain.toLowerCase()));
            ntlmFlags = 1619657221;
            if (this.acceptNTLMv1Logon()) {
                ntlmFlags -= Integer.MIN_VALUE;
            }
            Type2NTLMMessage type2Msg = new Type2NTLMMessage();
            type2Msg.buildType2(ntlmFlags, domain, ntlmCtx.getChallenge(), null, tList);
            sess.setSetupObject(client.getProcessId(), type2Msg);
            respBlob = type2Msg.getBytes();
        } else if (msgType == 3) {
            Type3NTLMMessage type3Msg = new Type3NTLMMessage(secbuf, secpos, seclen, unicode);
            if (!sess.hasSetupObject(client.getProcessId()) || !(sess.getSetupObject(client.getProcessId()) instanceof Type2NTLMMessage)) {
                sess.removeSetupObject(client.getProcessId());
                throw new SMBSrvException(-1073741715, 1, 5);
            }
            if (type3Msg.hasFlag(0x20000000) && type3Msg.hasFlag(524288)) {
                if (type3Msg.getNTLMHashLength() > 24) {
                    this.doNTLMv2Logon(sess, client, type3Msg);
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Logged on using NTLMSSP/NTLMv2");
                    }
                } else {
                    this.doNTLMv2SessionKeyLogon(sess, client, type3Msg);
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Logged on using NTLMSSP/NTLMv2SessKey");
                    }
                }
            } else {
                this.doNTLMv1Logon(sess, client, type3Msg);
                if (this.hasDebug()) {
                    Debug.println("[SMB] Logged on using NTLMSSP/NTLMv1");
                }
            }
        }
        return respBlob;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final byte[] doSpnegoSessionSetup(SMBSrvSession sess, ClientInfo client, byte[] secbuf, int secpos, int seclen, boolean unicode) throws SMBSrvException {
        Object negToken;
        int tokType = -1;
        try {
            tokType = SPNEGO.checkTokenType(secbuf, secpos, seclen);
        }
        catch (IOException ex) {
            // empty catch block
        }
        NegTokenTarg negTarg = null;
        if (tokType == 1 && sess.hasSetupObject(client.getProcessId()) && sess.getSetupObject(client.getProcessId()) instanceof Type2NTLMMessage) {
            negToken = new NegTokenTarg();
            try {
                ((NegTokenTarg)negToken).decode(secbuf, secpos, seclen);
            }
            catch (IOException ex) {
                if (!this.hasDebug()) throw new SMBSrvException(-1073741715, 1, 5);
                Debug.println(ex);
                throw new SMBSrvException(-1073741715, 1, 5);
            }
            byte[] ntlmsspBlob = ((NegTokenTarg)negToken).getResponseToken();
            byte[] ntlmsspRespBlob = this.doNtlmsspSessionSetup(sess, client, ntlmsspBlob, 0, ntlmsspBlob.length, unicode);
            int spnegoSts = 0;
            if (sess.hasSetupObject(client.getProcessId())) {
                spnegoSts = 1;
            }
            negTarg = new NegTokenTarg(spnegoSts, null, ntlmsspRespBlob);
        } else {
            if (tokType != 0) {
                if (!this.hasDebug()) throw new SMBSrvException(-1073741715, 1, 5);
                Debug.println("[SMB] Unknown SPNEGO token type");
                throw new SMBSrvException(-1073741715, 1, 5);
            }
            negToken = new NegTokenInit();
            try {
                ((NegTokenInit)negToken).decode(secbuf, secpos, seclen);
            }
            catch (IOException ex) {
                if (!this.hasDebug()) throw new SMBSrvException(-1073741715, 1, 5);
                Debug.println(ex);
                throw new SMBSrvException(-1073741715, 1, 5);
            }
            String oidStr = null;
            if (((NegTokenInit)negToken).numberOfOids() > 0) {
                oidStr = ((NegTokenInit)negToken).getOidAt(0).toString();
            }
            if (oidStr != null && oidStr.equals("1.3.6.1.4.1.311.2.2.10")) {
                byte[] ntlmsspBlob = ((NegTokenInit)negToken).getMechtoken();
                byte[] ntlmsspRespBlob = this.doNtlmsspSessionSetup(sess, client, ntlmsspBlob, 0, ntlmsspBlob.length, unicode);
                int spnegoSts = 0;
                if (sess.hasSetupObject(client.getProcessId())) {
                    spnegoSts = 1;
                }
                negTarg = new NegTokenTarg(spnegoSts, OID.NTLMSSP, ntlmsspRespBlob);
            } else if (oidStr != null && (oidStr.equals("1.2.840.48018.1.2.2") || oidStr.equals("1.2.840.113554.1.2.2"))) {
                negTarg = this.doKerberosLogon(sess, (NegTokenInit)negToken, client);
            } else {
                if (!this.hasDebug()) throw new SMBSrvException(-1073741715, 1, 5);
                Debug.println("[SMB] No matching authentication OID found");
                Debug.println("[SMB]   " + ((NegTokenInit)negToken).toString());
                throw new SMBSrvException(-1073741715, 1, 5);
            }
        }
        byte[] respBlob = null;
        try {
            return negTarg.encode();
        }
        catch (IOException ex) {
            if (!this.hasDebug()) throw new SMBSrvException(-1073741715, 1, 5);
            Debug.println("[SMB] Failed to encode NegTokenTarg - " + ex.getMessage());
            throw new SMBSrvException(-1073741715, 1, 5);
        }
    }

    private final NegTokenTarg doKerberosLogon(SMBSrvSession sess, NegTokenInit negToken, ClientInfo client) throws SMBSrvException {
        NegTokenTarg negTokenTarg;
        block28: {
            KerberosDetails krbDetails = null;
            negTokenTarg = null;
            try {
                KerberosApReq krbApReq = new KerberosApReq();
                krbApReq.parseMechToken(negToken.getMechtoken());
                if (this.hasDebug()) {
                    Debug.println("[SMB] Kerberos AP-REQ - " + krbApReq);
                }
                KrbAuthContext krbAuthCtx = null;
                if (krbApReq.hasMutualAuthentication() && this.m_enableTicketCracking) {
                    krbAuthCtx = new KrbAuthContext();
                    krbAuthCtx.setDebug(this.hasDebug());
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Kerberos mutual auth required, parsing AP-REQ");
                    }
                    try {
                        krbAuthCtx.parseKerberosApReq(this.m_loginContext.getSubject(), krbApReq);
                    }
                    catch (IOException ex) {
                        if (this.hasDebug()) {
                            Debug.println("[SMB] Failed to parse AP-REQ, " + ex.toString());
                        }
                        throw new SMBSrvException(-1073741715, 1, 5);
                    }
                }
                SessionSetupPrivilegedAction sessSetupAction = new SessionSetupPrivilegedAction(this.m_accountName, negToken.getMechtoken());
                Object result = Subject.doAs(this.m_loginContext.getSubject(), sessSetupAction);
                if (result != null) {
                    String userName;
                    block27: {
                        krbDetails = (KerberosDetails)result;
                        Oid respOid = null;
                        if (negToken.hasOid(OID.MSKERBEROS5)) {
                            respOid = OID.MSKERBEROS5;
                            if (this.hasDebug()) {
                                Debug.println("[SMB] Using OID MS Kerberos5 for NegTokenTarg");
                            }
                        } else {
                            respOid = OID.KERBEROS5;
                            if (this.hasDebug()) {
                                Debug.println("[SMB] Using OID Kerberos5 for NegTokenTarg");
                            }
                        }
                        if (krbAuthCtx != null) {
                            try {
                                byte[] respToken = krbAuthCtx.parseKerberosApRep(krbDetails.getResponseToken());
                                krbDetails.setResponseToken(respToken);
                                negTokenTarg = new NegTokenTarg(0, respOid, krbDetails.getResponseToken());
                                if (this.hasDebug()) {
                                    Debug.println("[SMB] Created NegTokenTarg using updated AP-REP, added subkey");
                                }
                                break block27;
                            }
                            catch (Exception ex) {
                                if (this.hasDebug()) {
                                    Debug.println("[SMB] AP-REP Error:");
                                    Debug.println(ex);
                                }
                                break block27;
                            }
                        }
                        negTokenTarg = new NegTokenTarg(0, respOid, krbDetails.getResponseToken());
                        if (this.hasDebug()) {
                            Debug.println("[SMB] Created NegTokenTarg using standard Krb5 API response");
                        }
                    }
                    if ((userName = krbDetails.getUserName()) != null) {
                        if (userName.endsWith("$") && userName.equals(userName.toUpperCase())) {
                            client.setLogonType(2);
                            if (this.hasDebug()) {
                                Debug.println("[SMB] Machine account logon, " + userName + ", as null logon");
                            }
                        } else {
                            client.setUserName(krbDetails.getSourceName());
                            client.setGuest(false);
                            sess.setLoggedOn(true);
                        }
                    } else {
                        client.setLogonType(2);
                    }
                    sess.setLoggedOn(true);
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Logged on using Kerberos, user " + userName);
                    }
                    break block28;
                }
                if (this.hasDebug()) {
                    Debug.println("[SMB] No SPNEGO response, Kerberos logon failed");
                }
                throw new SMBSrvException(-1073741715, 1, 5);
            }
            catch (Exception ex) {
                if (this.hasDebug()) {
                    Debug.println("[SMB] Kerberos logon error");
                    Debug.println(ex);
                }
                throw new SMBSrvException(-1073741715, 1, 5);
            }
        }
        return negTokenTarg;
    }

    private final void doNTLMv1Logon(SMBSrvSession sess, ClientInfo client, Type3NTLMMessage type3Msg) throws SMBSrvException {
        int sts;
        if (!this.acceptNTLMv1Logon()) {
            if (this.hasDebug()) {
                Debug.println("[SMB] NTLMv1 not accepted, client " + sess.getRemoteName());
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        Type2NTLMMessage type2Msg = (Type2NTLMMessage)sess.getSetupObject(client.getProcessId());
        sess.removeSetupObject(client.getProcessId());
        String userName = type3Msg.getUserName();
        if (userName.length() == 0) {
            if (this.hasDebug()) {
                Debug.println("[SMB] Null logon");
            }
            client.setLogonType(2);
            return;
        }
        UserAccount user = this.getUserDetails(userName);
        if (user != null) {
            sts = this.authenticateUser(client, sess, 1);
            if (sts < 0) {
                throw new SMBSrvException(-1073741715, 1, 5);
            }
        } else {
            if (this.hasDebug()) {
                Debug.println("[SMB] User does not exist, " + userName);
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        client.setUserName(userName);
        client.setGuest(sts == 0x10000000);
        sess.setLoggedOn(true);
    }

    private final void doNTLMv1Logon(SMBSrvSession sess, ClientInfo client) throws SMBSrvException {
        int sts;
        if (!this.acceptNTLMv1Logon()) {
            if (this.hasDebug()) {
                Debug.println("[SMB] NTLMv1 not accepted, client " + sess.getRemoteName());
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        String userName = client.getUserName();
        UserAccount user = this.getUserDetails(userName);
        if (user != null) {
            sts = this.authenticateUser(client, sess, 1);
            if (sts < 0) {
                throw new SMBSrvException(-1073741715, 1, 5);
            }
        } else {
            if (this.hasDebug()) {
                Debug.println("[SMB] User does not exist, " + userName);
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        client.setUserName(userName);
        client.setGuest(sts == 0x10000000);
        sess.setLoggedOn(true);
    }

    private final void doNTLMv2Logon(SMBSrvSession sess, ClientInfo client, Type3NTLMMessage type3Msg) throws SMBSrvException {
        Type2NTLMMessage type2Msg = (Type2NTLMMessage)sess.getSetupObject(client.getProcessId());
        sess.removeSetupObject(client.getProcessId());
        String userName = type3Msg.getUserName();
        if (userName.length() == 0) {
            if (this.hasDebug()) {
                Debug.println("[SMB] Null logon");
            }
            client.setLogonType(2);
            return;
        }
        UserAccount user = this.getUserDetails(userName);
        if (user != null) {
            try {
                byte[] md4Pwd = null;
                if (user.hasMD4Password()) {
                    md4Pwd = user.getMD4Password();
                } else {
                    md4Pwd = this.getEncryptor().generateEncryptedPassword(user.getPassword(), type2Msg.getChallenge(), 3, null, null);
                    user.setMD4Password(md4Pwd);
                }
                byte[] v2hash = this.getEncryptor().doNTLM2Encryption(md4Pwd, type3Msg.getUserName(), type3Msg.getDomain());
                NTLMv2Blob v2blob = new NTLMv2Blob(type3Msg.getNTLMHash());
                byte[] srvChallenge = type2Msg.getChallenge();
                byte[] srvHmac = v2blob.calculateHMAC(srvChallenge, v2hash);
                byte[] clientHmac = v2blob.getHMAC();
                if (clientHmac != null && srvHmac != null && clientHmac.length == srvHmac.length) {
                    int i;
                    for (i = 0; i < clientHmac.length && clientHmac[i] == srvHmac[i]; ++i) {
                    }
                    if (i != clientHmac.length) {
                        throw new SMBSrvException(-1073741715, 1, 5);
                    }
                }
                client.setUserName(userName);
                client.setGuest(false);
                sess.setLoggedOn(true);
            }
            catch (Exception ex) {
                if (this.hasDebug()) {
                    Debug.println(ex);
                }
                throw new SMBSrvException(-1073741715, 1, 5);
            }
        } else {
            if (this.hasDebug()) {
                Debug.println("[SMB] User does not exist, " + userName);
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
    }

    private final void doNTLMv2Logon(SMBSrvSession sess, ClientInfo client) throws SMBSrvException {
        if (client.getUserName().length() == 0) {
            if (this.hasDebug()) {
                Debug.println("[SMB] Null logon");
            }
            client.setLogonType(2);
            return;
        }
        UserAccount user = this.getUserDetails(client.getUserName());
        if (user != null) {
            try {
                byte[] srvChallenge = null;
                if (sess.hasAuthenticationContext()) {
                    NTLanManAuthContext ntlmCtx = (NTLanManAuthContext)sess.getAuthenticationContext();
                    srvChallenge = ntlmCtx.getChallenge();
                }
                byte[] md4Pwd = null;
                if (user.hasMD4Password()) {
                    md4Pwd = user.getMD4Password();
                } else {
                    md4Pwd = this.getEncryptor().generateEncryptedPassword(user.getPassword(), srvChallenge, 3, null, null);
                    user.setMD4Password(md4Pwd);
                }
                NTLMv2Blob v2blob = new NTLMv2Blob(client.getPassword());
                byte[] v2hash = this.getEncryptor().doNTLM2Encryption(md4Pwd, client.getUserName(), client.getDomain());
                byte[] srvHmac = v2blob.calculateHMAC(srvChallenge, v2hash);
                byte[] clientHmac = v2blob.getHMAC();
                if (clientHmac != null && srvHmac != null && clientHmac.length == srvHmac.length) {
                    int i;
                    for (i = 0; i < clientHmac.length && clientHmac[i] == srvHmac[i]; ++i) {
                    }
                    if (i != clientHmac.length) {
                        throw new SMBSrvException(-1073741715, 1, 5);
                    }
                }
                client.setGuest(false);
                sess.setLoggedOn(true);
            }
            catch (Exception ex) {
                if (this.hasDebug()) {
                    Debug.println(ex);
                }
                throw new SMBSrvException(-1073741715, 1, 5);
            }
        } else {
            if (this.hasDebug()) {
                Debug.println("[SMB] User does not exist, " + client.getUserName());
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
    }

    private final void doNTLMv2SessionKeyLogon(SMBSrvSession sess, ClientInfo client, Type3NTLMMessage type3Msg) throws SMBSrvException {
        Type2NTLMMessage type2Msg = (Type2NTLMMessage)sess.getSetupObject(client.getProcessId());
        sess.removeSetupObject(client.getProcessId());
        String userName = type3Msg.getUserName();
        if (userName.length() == 0) {
            if (this.hasDebug()) {
                Debug.println("[SMB] Null logon");
            }
            client.setLogonType(2);
            return;
        }
        UserAccount user = this.getUserDetails(userName);
        if (user != null) {
            byte[] localHash;
            block18: {
                byte[] nonce = new byte[16];
                System.arraycopy(type2Msg.getChallenge(), 0, nonce, 0, 8);
                System.arraycopy(type3Msg.getLMHash(), 0, nonce, 8, 8);
                MessageDigest md5 = null;
                byte[] v2challenge = new byte[8];
                try {
                    md5 = MessageDigest.getInstance("MD5");
                    md5.update(nonce);
                    byte[] md5nonce = md5.digest();
                    System.arraycopy(md5nonce, 0, v2challenge, 0, 8);
                }
                catch (NoSuchAlgorithmException ex) {
                    if (this.hasDebug()) {
                        Debug.println(ex);
                    }
                    throw new SMBSrvException(-1073741715, 1, 5);
                }
                byte[] p21 = new byte[21];
                byte[] md4byts = null;
                if (user.hasMD4Password()) {
                    md4byts = user.getMD4Password();
                } else {
                    try {
                        md4byts = this.getEncryptor().generateEncryptedPassword(user.getPassword(), null, 3, null, null);
                    }
                    catch (Exception ex) {
                        if (this.hasDebug()) {
                            Debug.println(ex);
                        }
                        throw new SMBSrvException(-1073741715, 1, 5);
                    }
                }
                System.arraycopy(md4byts, 0, p21, 0, 16);
                localHash = null;
                try {
                    localHash = this.getEncryptor().doNTLM1Encryption(p21, v2challenge);
                }
                catch (NoSuchAlgorithmException ex) {
                    if (!this.hasDebug()) break block18;
                    Debug.println(ex);
                }
            }
            byte[] clientHash = type3Msg.getNTLMHash();
            if (clientHash != null && localHash != null && clientHash.length == localHash.length) {
                int i;
                for (i = 0; i < clientHash.length && clientHash[i] == localHash[i]; ++i) {
                }
                if (i != clientHash.length) {
                    throw new SMBSrvException(-1073741715, 1, 5);
                }
            }
        } else {
            if (this.hasDebug()) {
                Debug.println("[SMB] User does not exist, " + userName);
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        client.setUserName(userName);
        client.setGuest(false);
        sess.setLoggedOn(true);
    }

    private final void doHashedPasswordLogon(SMBSrvSession sess, SMBSrvPacket reqPkt) throws SMBSrvException {
        VirtualCircuit vc;
        int uid;
        if (!reqPkt.checkPacketIsValid(13, 0)) {
            throw new SMBSrvException(-1073741811, 2, 1);
        }
        int maxBufSize = reqPkt.getParameter(2);
        int maxMpx = reqPkt.getParameter(3);
        int vcNum = reqPkt.getParameter(4);
        int ascPwdLen = reqPkt.getParameter(7);
        int uniPwdLen = reqPkt.getParameter(8);
        int capabs = reqPkt.getParameterLong(11);
        byte[] buf = reqPkt.getBuffer();
        boolean isUni = reqPkt.isUnicode();
        byte[] ascPwd = reqPkt.unpackBytes(ascPwdLen);
        byte[] uniPwd = reqPkt.unpackBytes(uniPwdLen);
        String user = reqPkt.unpackString(isUni);
        if (user == null) {
            throw new SMBSrvException(-1073741811, 2, 1);
        }
        String domain = "";
        if (reqPkt.hasMoreData() && (domain = reqPkt.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 2, 1);
        }
        String clientOS = "";
        if (reqPkt.hasMoreData() && (clientOS = reqPkt.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 2, 1);
        }
        if (sess.hasDebug(32)) {
            Debug.println("[SMB] NT Session setup from user=" + user + ", password=" + (uniPwd != null ? HexDump.hexString(uniPwd) : "none") + ", ANSIpwd=" + (ascPwd != null ? HexDump.hexString(ascPwd) : "none") + ", domain=" + domain + ", os=" + clientOS + ", VC=" + vcNum + ", maxBuf=" + maxBufSize + ", maxMpx=" + maxMpx + ", authCtx=" + sess.getAuthenticationContext());
            Debug.println("[SMB]   MID=" + reqPkt.getMultiplexId() + ", UID=" + reqPkt.getUserId() + ", PID=" + reqPkt.getProcessId());
        }
        sess.setClientMaximumBufferSize(maxBufSize != 0 ? maxBufSize : 65540);
        sess.setClientMaximumMultiplex(maxMpx);
        sess.setClientCapabilities(capabs);
        ClientInfo client = ClientInfo.getFactory().createInfo(user, uniPwd);
        client.setANSIPassword(ascPwd);
        client.setDomain(domain);
        client.setOperatingSystem(clientOS);
        if (sess.hasRemoteAddress()) {
            client.setClientAddress(sess.getRemoteAddress().getHostAddress());
        }
        if (user.length() == 0 && domain.length() == 0 && uniPwdLen == 0) {
            client.setLogonType(2);
        }
        boolean isGuest = false;
        if (uniPwd != null) {
            if (uniPwd.length == 24) {
                this.doNTLMv1Logon(sess, client);
                if (this.hasDebug()) {
                    Debug.println("[SMB] Logged on using Hashed/NTLMv1");
                }
            } else if (uniPwd.length > 0) {
                this.doNTLMv2Logon(sess, client);
                if (this.hasDebug()) {
                    Debug.println("[SMB] Logged on using Hashed/NTLMv2");
                }
            }
        } else {
            client.setLogonType(2);
        }
        if (client.isGuest()) {
            isGuest = true;
            if (sess.hasDebug(32)) {
                Debug.println("[SMB] User " + user + ", logged on as guest");
            }
        }
        if ((uid = sess.addVirtualCircuit(vc = new VirtualCircuit(vcNum, client))) == -1) {
            if (sess.hasDebug(32)) {
                Debug.println("[SMB] Failed to allocate UID for virtual circuit, " + vc);
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        if (sess.hasDebug(32)) {
            Debug.println("[SMB] Allocated UID=" + uid + " for VC=" + vc);
        }
        if (isGuest) {
            client.setLogonType(1);
        }
        sess.setLoggedOn(true);
        reqPkt.setParameterCount(3);
        reqPkt.setParameter(0, 0);
        reqPkt.setParameter(1, 0);
        reqPkt.setParameter(2, isGuest ? 1 : 0);
        reqPkt.setByteCount(0);
        reqPkt.setTreeId(0);
        reqPkt.setUserId(uid);
        int flags = reqPkt.getFlags();
        reqPkt.setFlags(flags &= 0xFFFFFFF7);
        int flags2 = 1;
        if (isUni) {
            flags2 += 32768;
        }
        reqPkt.setFlags2(flags2);
        int pos = reqPkt.getByteOffset();
        buf = reqPkt.getBuffer();
        if (isUni) {
            pos = DataPacker.wordAlign(pos);
        }
        pos = DataPacker.putString("Java", buf, pos, true, isUni);
        pos = DataPacker.putString("Alfresco CIFS Server " + sess.getServer().isVersion(), buf, pos, true, isUni);
        pos = DataPacker.putString(sess.getSMBServer().getCIFSConfiguration().getDomainName(), buf, pos, true, isUni);
        reqPkt.setByteCount(pos - reqPkt.getByteOffset());
    }
}

