/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.passthru;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.SessionListener;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.AuthContext;
import org.alfresco.jlan.server.auth.AuthenticatorException;
import org.alfresco.jlan.server.auth.CifsAuthenticator;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.auth.NTLanManAuthContext;
import org.alfresco.jlan.server.auth.UserAccount;
import org.alfresco.jlan.server.auth.ntlm.NTLM;
import org.alfresco.jlan.server.auth.ntlm.NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.TargetInfo;
import org.alfresco.jlan.server.auth.ntlm.Type1NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.Type2NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.Type3NTLMMessage;
import org.alfresco.jlan.server.auth.passthru.AuthSessionFactory;
import org.alfresco.jlan.server.auth.passthru.AuthenticateSession;
import org.alfresco.jlan.server.auth.passthru.PassthruDetails;
import org.alfresco.jlan.server.auth.passthru.PassthruServers;
import org.alfresco.jlan.server.auth.spnego.NegTokenInit;
import org.alfresco.jlan.server.auth.spnego.NegTokenTarg;
import org.alfresco.jlan.server.auth.spnego.OID;
import org.alfresco.jlan.server.auth.spnego.SPNEGO;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.NoPooledMemoryException;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.smb.Protocol;
import org.alfresco.jlan.smb.dcerpc.UUID;
import org.alfresco.jlan.smb.server.SMBServer;
import org.alfresco.jlan.smb.server.SMBSrvException;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.jlan.smb.server.VirtualCircuit;
import org.alfresco.jlan.util.DataPacker;
import org.alfresco.jlan.util.HexDump;
import org.springframework.extensions.config.ConfigElement;

public class PassthruAuthenticator
extends CifsAuthenticator
implements SessionListener {
    public static final int DefaultSessionTmo = 5000;
    public static final int MinSessionTmo = 2000;
    public static final int MaxSessionTmo = 30000;
    public static final int MinCheckInterval = 10;
    public static final int MaxCheckInterval = 900;
    public static final long PassthruKeepAliveInterval = 60000L;
    private static final int NTLM_FLAGS = -1610612095;
    private PassthruServers m_passthruServers;
    private SMBServer m_server;
    private Hashtable m_sessions = new Hashtable();

    public PassthruAuthenticator() {
        this.setExtendedSecurity(true);
    }

    @Override
    public int authenticateShareConnect(ClientInfo client, SharedDevice share, String sharePwd, SrvSession sess) {
        if (this.getAccessMode() == 0) {
            return 2;
        }
        if (share.getType() == 3) {
            return 2;
        }
        UserAccount user = null;
        if (client != null) {
            user = this.getUserDetails(client.getUserName());
        }
        if (user == null) {
            return this.allowGuest() ? 2 : 0;
        }
        if (!user.hasShare(share.getName())) {
            return 0;
        }
        return 2;
    }

    @Override
    public int authenticateUser(ClientInfo client, SrvSession sess, int alg) {
        if (client.isNullSession()) {
            if (this.hasDebug()) {
                Debug.println("Null CIFS logon allowed");
            }
            return 0;
        }
        int authSts = -1;
        if (client.isGuest() || client.getUserName().equalsIgnoreCase(this.getGuestUserName())) {
            if (!this.allowGuest()) {
                return -1;
            }
            this.doGuestLogon(client, sess);
            authSts = 0x10000000;
            if (this.hasDebug()) {
                Debug.println("Authenticated user " + client.getUserName() + " sts=" + this.getStatusAsString(authSts));
            }
            return authSts;
        }
        PassthruDetails passDetails = (PassthruDetails)this.m_sessions.get(sess.getUniqueId());
        if (passDetails != null) {
            AuthenticateSession authSess;
            try {
                authSess = passDetails.getAuthenticateSession();
                authSess.doSessionSetup(client.getUserName(), client.getANSIPassword(), client.getPassword());
                if (authSess.isGuest()) {
                    if (this.allowGuest()) {
                        this.doGuestLogon(client, sess);
                        authSts = 0x10000000;
                        if (this.hasDebug()) {
                            Debug.println("Passthru authenticate user=" + client.getUserName() + ", GUEST");
                        }
                    }
                } else {
                    authSts = 0;
                    if (this.hasDebug()) {
                        Debug.println("Passthru authenticate user=" + client.getUserName() + ", FULL");
                    }
                }
            }
            catch (Exception ex) {
                Debug.println(ex.getMessage());
            }
            if (!(sess instanceof SMBSrvSession)) {
                this.m_sessions.remove(sess.getUniqueId());
                try {
                    authSess = passDetails.getAuthenticateSession();
                    authSess.CloseSession();
                    if (this.hasDebug()) {
                        Debug.println("Closed auth session, sessId=" + authSess.getSessionId());
                    }
                }
                catch (Exception ex) {
                    Debug.println("Passthru error closing session (auth user) " + ex.getMessage());
                }
            }
        } else if (this.hasDebug()) {
            Debug.println("  No PassthruDetails for " + sess.getUniqueId());
        }
        return authSts;
    }

    @Override
    public AuthContext getAuthContext(SMBSrvSession sess) {
        if (this.m_server == null && sess instanceof SMBSrvSession) {
            SMBSrvSession smbSess = sess;
            this.m_server = smbSess.getSMBServer();
            this.m_server.addSessionListener(this);
        }
        NTLanManAuthContext authCtx = null;
        try {
            AuthenticateSession authSess = this.m_passthruServers.openSession();
            if (authSess != null) {
                PassthruDetails passDetails = new PassthruDetails(sess, authSess);
                this.m_sessions.put(sess.getUniqueId(), passDetails);
                authCtx = new NTLanManAuthContext(authSess.getEncryptionKey());
                sess.setAuthenticationContext(authCtx);
                if (this.hasDebug()) {
                    Debug.println("Passthru sessId=" + authSess.getSessionId() + ", auth ctx=" + authCtx);
                }
            }
        }
        catch (Exception ex) {
            Debug.println("Passthru error getting challenge " + ex.getMessage());
        }
        return authCtx;
    }

    @Override
    public void generateNegotiateResponse(SMBSrvSession sess, SMBSrvPacket respPkt, boolean extendedSecurity) throws AuthenticatorException {
        if (!extendedSecurity) {
            super.generateNegotiateResponse(sess, respPkt, extendedSecurity);
            return;
        }
        if ((respPkt.getFlags2() & 0x800) == 0) {
            respPkt.setFlags2(respPkt.getFlags2() + 2048);
        }
        int pos = respPkt.getByteOffset();
        byte[] buf = respPkt.getBuffer();
        UUID serverGUID = sess.getSMBServer().getServerGUID();
        serverGUID.storeUUID(buf, pos, false);
        respPkt.setByteCount((pos += 16) - respPkt.getByteOffset());
    }

    @Override
    public void processSessionSetup(SMBSrvSession sess, SMBSrvPacket reqPkt) throws SMBSrvException {
        if (!reqPkt.checkPacketIsValid(12, 0)) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        if (reqPkt.getParameterCount() == 13) {
            super.processSessionSetup(sess, reqPkt);
            return;
        }
        int maxBufSize = reqPkt.getParameter(2);
        int maxMpx = reqPkt.getParameter(3);
        int vcNum = reqPkt.getParameter(4);
        int secBlobLen = reqPkt.getParameter(7);
        int capabs = reqPkt.getParameterLong(10);
        int dataPos = reqPkt.getByteOffset();
        byte[] buf = reqPkt.getBuffer();
        boolean isUni = reqPkt.isUnicode();
        int secBlobPos = dataPos;
        reqPkt.setPosition(dataPos += secBlobLen);
        String domain = "";
        if (reqPkt.hasMoreData() && (domain = reqPkt.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        String clientOS = "";
        if (reqPkt.hasMoreData() && (clientOS = reqPkt.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        sess.setClientMaximumBufferSize(maxBufSize != 0 ? maxBufSize : 65540);
        sess.setClientMaximumMultiplex(maxMpx);
        sess.setClientCapabilities(capabs);
        ClientInfo client = ClientInfo.createInfo("", null);
        client.setDomain(domain);
        client.setOperatingSystem(clientOS);
        client.setLogonType(0);
        if (sess.hasRemoteAddress()) {
            client.setClientAddress(sess.getRemoteAddress().getHostAddress());
        }
        client.setProcessId(reqPkt.getProcessId());
        Object setupObj = sess.getSetupObject(client.getProcessId());
        byte[] respBlob = null;
        boolean isNTLMSSP = false;
        try {
            if (secBlobLen >= NTLM.Signature.length) {
                int idx;
                for (idx = 0; idx < NTLM.Signature.length && buf[secBlobPos + idx] == NTLM.Signature[idx]; ++idx) {
                }
                if (idx == NTLM.Signature.length) {
                    isNTLMSSP = true;
                }
            }
            if (isNTLMSSP) {
                if (this.hasDebug()) {
                    Debug.println("NT Session setup NTLMSSP, MID=" + reqPkt.getMultiplexId() + ", UID=" + reqPkt.getUserId() + ", PID=" + reqPkt.getProcessId());
                }
                respBlob = this.doNtlmsspSessionSetup(sess, client, buf, secBlobPos, secBlobLen, isUni);
            } else {
                respBlob = this.doSpnegoSessionSetup(sess, client, buf, secBlobPos, secBlobLen, isUni);
            }
        }
        catch (SMBSrvException ex) {
            sess.removeSetupObject(client.getProcessId());
            throw ex;
        }
        if (sess.hasDebug(32)) {
            if (respBlob == null) {
                Debug.println("[SMB] User " + client.getUserName() + " logged on " + (client != null ? " (type " + client.getLogonTypeString() + ")" : ""));
            } else {
                Debug.println("[SMB] Two stage logon (" + (isNTLMSSP ? "NTLMSSP" : "SPNEGO") + ")");
            }
        }
        if (sess.getClientInformation() == null || sess.getClientInformation().getUserName().length() == 0) {
            sess.setClientInformation(client);
        }
        int respLen = respBlob != null ? respBlob.length : 0;
        SMBSrvPacket respPkt = reqPkt;
        boolean loggedOn = false;
        if (isNTLMSSP || sess.hasSetupObject(client.getProcessId()) || setupObj != null) {
            if (sess.hasSetupObject(client.getProcessId())) {
                respPkt.setLongErrorCode(-1073741802);
            } else {
                respPkt.setLongErrorCode(0);
                loggedOn = true;
            }
            respPkt.setParameterCount(4);
            int reqLen = respLen + 100;
            if (reqLen > respPkt.getAvailableLength()) {
                try {
                    respPkt = sess.getPacketPool().allocatePacket(respPkt.getByteOffset() + reqLen, reqPkt);
                }
                catch (NoPooledMemoryException ex) {
                    if (this.hasDebug()) {
                        Debug.println("Authenticator failed to allocate packet from pool, reqSiz=" + (respPkt.getByteOffset() + respLen));
                    }
                    throw new SMBSrvException(-1073741811, 83, 2);
                }
            }
            respPkt.setParameter(0, 255);
            respPkt.setParameter(1, 0);
            respPkt.setParameter(2, 0);
            respPkt.setParameter(3, respLen);
        } else {
            respPkt.setLongErrorCode(0);
            respPkt.setParameterCount(12);
            respPkt.setParameter(0, 255);
            respPkt.setParameter(1, 0);
            respPkt.setParameter(2, 65540);
            respPkt.setParameter(3, 4);
            respPkt.setParameter(4, 0);
            respPkt.setParameterLong(5, 0);
            respPkt.setParameter(7, respLen);
            respPkt.setParameterLong(8, 0);
            respPkt.setParameterLong(10, this.getServerCapabilities());
            loggedOn = true;
        }
        int uid = 0;
        if (loggedOn) {
            int discCnt;
            if (vcNum == 0 && this.hasSessionCleanup() && (discCnt = sess.disconnectClientSessions()) > 0 && sess.hasDebug(32)) {
                Debug.println("[SMB] Disconnected " + discCnt + " existing sessions from client, sess=" + sess);
            }
            sess.removeSetupObject(client.getProcessId());
            VirtualCircuit vc = new VirtualCircuit(vcNum, client);
            uid = sess.addVirtualCircuit(vc);
            if (uid == -1) {
                if (this.hasDebug() && sess.hasDebug(32)) {
                    Debug.println("Failed to allocate UID for virtual circuit, " + vc);
                }
                throw new SMBSrvException(-1073741715, 5, 1);
            }
            if (this.hasDebug() && sess.hasDebug(32)) {
                Debug.println("Allocated UID=" + uid + " for VC=" + vc);
            }
        }
        respPkt.setCommand(reqPkt.getCommand());
        respPkt.setByteCount(0);
        respPkt.setTreeId(0);
        respPkt.setUserId(uid);
        int flags = respPkt.getFlags();
        respPkt.setFlags(flags &= 0xFFFFFFF7);
        int flags2 = 18433;
        if (isUni) {
            flags2 += 32768;
        }
        respPkt.setFlags2(flags2);
        int pos = respPkt.getByteOffset();
        buf = respPkt.getBuffer();
        if (respBlob != null) {
            System.arraycopy(respBlob, 0, buf, pos, respBlob.length);
            pos += respBlob.length;
        }
        if (isUni) {
            pos = DataPacker.wordAlign(pos);
        }
        pos = DataPacker.putString("Java", buf, pos, true, isUni);
        pos = DataPacker.putString("Alfresco CIFS Server " + sess.getServer().isVersion(), buf, pos, true, isUni);
        pos = DataPacker.putString(sess.getSMBServer().getCIFSConfiguration().getDomainName(), buf, pos, true, isUni);
        respPkt.setByteCount(pos - respPkt.getByteOffset());
    }

    private final byte[] doNtlmsspSessionSetup(SMBSrvSession sess, ClientInfo client, byte[] secbuf, int secpos, int seclen, boolean unicode) throws SMBSrvException {
        int msgType = NTLMMessage.isNTLMType(secbuf, secpos);
        byte[] respBlob = null;
        if (msgType == -1) {
            if (this.hasDebug()) {
                Debug.println("Invalid NTLMSSP token received");
                Debug.println("  Token=" + HexDump.hexString(secbuf, secpos, seclen, " "));
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        if (msgType == 1) {
            Type1NTLMMessage type1Msg = new Type1NTLMMessage(secbuf, secpos, seclen);
            int ntlmFlags = type1Msg.getFlags() & 0xA0000281;
            NTLanManAuthContext ntlmCtx = (NTLanManAuthContext)this.getAuthContext(sess);
            if (ntlmCtx == null) {
                throw new SMBSrvException(-1073741715, 1, 5);
            }
            String domain = sess.getSMBServer().getServerName();
            ArrayList<TargetInfo> tList = new ArrayList<TargetInfo>();
            tList.add(new TargetInfo(2, domain));
            tList.add(new TargetInfo(1, sess.getServerName()));
            tList.add(new TargetInfo(4, domain));
            tList.add(new TargetInfo(3, domain));
            ntlmFlags = -1065221627;
            Type2NTLMMessage type2Msg = new Type2NTLMMessage();
            type2Msg.buildType2(ntlmFlags, domain, ntlmCtx.getChallenge(), null, tList);
            sess.setSetupObject(client.getProcessId(), type2Msg);
            respBlob = type2Msg.getBytes();
        } else if (msgType == 3) {
            Type3NTLMMessage type3Msg = new Type3NTLMMessage(secbuf, secpos, seclen, unicode);
            if (!sess.hasSetupObject(client.getProcessId()) || !(sess.getSetupObject(client.getProcessId()) instanceof Type2NTLMMessage)) {
                sess.removeSetupObject(client.getProcessId());
                throw new SMBSrvException(-1073741715, 1, 5);
            }
            if (type3Msg.hasFlag(0x20000000) && type3Msg.hasFlag(524288)) {
                if (this.hasDebug()) {
                    Debug.println("Received NTLMSSP/NTLMv2, not supported");
                }
                throw new SMBSrvException(-1073741715, 1, 5);
            }
            this.doNTLMv1Logon(sess, client, type3Msg);
            if (this.hasDebug()) {
                Debug.println("Logged on using NTLMSSP/NTLMv1");
            }
        }
        return respBlob;
    }

    private final void doNTLMv1Logon(SMBSrvSession sess, ClientInfo client, Type3NTLMMessage type3Msg) throws SMBSrvException {
        Type2NTLMMessage type2Msg = (Type2NTLMMessage)sess.getSetupObject(client.getProcessId());
        sess.removeSetupObject(client.getProcessId());
        String userName = type3Msg.getUserName();
        if (userName.length() == 0) {
            if (this.hasDebug()) {
                Debug.println("Null logon");
            }
            client.setLogonType(2);
            return;
        }
        PassthruDetails passDetails = (PassthruDetails)this.m_sessions.get(sess.getUniqueId());
        if (passDetails != null) {
            try {
                AuthenticateSession authSess = passDetails.getAuthenticateSession();
                authSess.doSessionSetup(userName, type3Msg.getLMHash(), type3Msg.getNTLMHash());
                if (authSess.isGuest()) {
                    if (this.allowGuest()) {
                        this.doGuestLogon(client, sess);
                        if (this.hasDebug()) {
                            Debug.println("Passthru authenticate user=" + userName + ", GUEST");
                        }
                    }
                } else {
                    client.setLogonType(0);
                    if (this.hasDebug()) {
                        Debug.println("Passthru authenticate user=" + userName + ", FULL");
                    }
                }
                client.setDomain(type3Msg.getDomain());
                client.setUserName(userName);
            }
            catch (Exception ex) {
                Debug.println(ex.getMessage());
                throw new SMBSrvException(6, -1073741715);
            }
            finally {
                this.m_sessions.remove(sess.getUniqueId());
                try {
                    AuthenticateSession authSess = passDetails.getAuthenticateSession();
                    authSess.CloseSession();
                    if (this.hasDebug()) {
                        Debug.println("Closed auth session, sessId=" + authSess.getSessionId());
                    }
                }
                catch (Exception ex) {
                    Debug.println("Passthru error closing session (auth user) " + ex.getMessage());
                }
            }
        }
        if (this.hasDebug()) {
            Debug.println("  No PassthruDetails for " + sess.getUniqueId());
        }
        throw new SMBSrvException(6, -1073741715);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final byte[] doSpnegoSessionSetup(SMBSrvSession sess, ClientInfo client, byte[] secbuf, int secpos, int seclen, boolean unicode) throws SMBSrvException {
        Object negToken;
        int tokType = -1;
        try {
            tokType = SPNEGO.checkTokenType(secbuf, secpos, seclen);
        }
        catch (IOException ex) {
            // empty catch block
        }
        NegTokenTarg negTarg = null;
        if (tokType == 1 && sess.hasSetupObject(client.getProcessId()) && sess.getSetupObject(client.getProcessId()) instanceof Type2NTLMMessage) {
            negToken = new NegTokenTarg();
            try {
                ((NegTokenTarg)negToken).decode(secbuf, secpos, seclen);
            }
            catch (IOException ex) {
                if (!this.hasDebug()) throw new SMBSrvException(-1073741715, 1, 5);
                Debug.println("Passthru error on session startup: " + ex.getMessage());
                throw new SMBSrvException(-1073741715, 1, 5);
            }
            byte[] ntlmsspBlob = ((NegTokenTarg)negToken).getResponseToken();
            byte[] ntlmsspRespBlob = this.doNtlmsspSessionSetup(sess, client, ntlmsspBlob, 0, ntlmsspBlob.length, unicode);
            int spnegoSts = 0;
            if (sess.hasSetupObject(client.getProcessId())) {
                spnegoSts = 1;
            }
            negTarg = new NegTokenTarg(spnegoSts, null, ntlmsspRespBlob);
        } else {
            if (tokType != 0) {
                if (!this.hasDebug()) throw new SMBSrvException(-1073741715, 1, 5);
                Debug.println("Unknown SPNEGO token type");
                throw new SMBSrvException(-1073741715, 1, 5);
            }
            negToken = new NegTokenInit();
            try {
                ((NegTokenInit)negToken).decode(secbuf, secpos, seclen);
            }
            catch (IOException ex) {
                if (!this.hasDebug()) throw new SMBSrvException(-1073741715, 1, 5);
                Debug.println("Passthru error on session startup: " + ex.getMessage());
                throw new SMBSrvException(-1073741715, 1, 5);
            }
            String oidStr = null;
            if (((NegTokenInit)negToken).numberOfOids() > 0) {
                oidStr = ((NegTokenInit)negToken).getOidAt(0).toString();
            }
            if (oidStr != null && oidStr.equals("1.3.6.1.4.1.311.2.2.10")) {
                byte[] ntlmsspBlob = ((NegTokenInit)negToken).getMechtoken();
                byte[] ntlmsspRespBlob = this.doNtlmsspSessionSetup(sess, client, ntlmsspBlob, 0, ntlmsspBlob.length, unicode);
                int spnegoSts = 0;
                if (sess.hasSetupObject(client.getProcessId())) {
                    spnegoSts = 1;
                }
                negTarg = new NegTokenTarg(spnegoSts, OID.NTLMSSP, ntlmsspRespBlob);
            } else {
                if (!this.hasDebug()) throw new SMBSrvException(-1073741715, 1, 5);
                Debug.println("No matching authentication OID found");
                Debug.println("  " + ((NegTokenInit)negToken).toString());
                throw new SMBSrvException(-1073741715, 1, 5);
            }
        }
        byte[] respBlob = null;
        try {
            return negTarg.encode();
        }
        catch (IOException ex) {
            if (!this.hasDebug()) throw new SMBSrvException(-1073741715, 1, 5);
            Debug.println("Failed to encode NegTokenTarg: " + ex.getMessage());
            throw new SMBSrvException(-1073741715, 1, 5);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void initialize(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        super.initialize(config, params);
        if (params.getChild("disableSessionCleanup") != null) {
            this.setSessionCleanup(false);
            if (this.hasDebug()) {
                Debug.println("[SMB] Disabled session cleanup (for virtual circuit zero logons)");
            }
        }
        if ((protoOrder = params.getChild("protocolOrder")) != null) {
            tokens = new StringTokenizer(protoOrder.getValue(), ",");
            primaryProto = -1;
            secondaryProto = -1;
            if (tokens.countTokens() > 2) {
                throw new InvalidConfigurationException("Invalid protocol order list, " + protoOrder.getValue());
            }
            if (tokens.hasMoreTokens()) {
                primaryStr = tokens.nextToken();
                if (primaryStr.equalsIgnoreCase("TCPIP")) {
                    primaryProto = 2;
                } else if (primaryStr.equalsIgnoreCase("NetBIOS")) {
                    primaryProto = 1;
                } else {
                    throw new InvalidConfigurationException("Invalid protocol type, " + primaryStr);
                }
                if (tokens.hasMoreTokens()) {
                    secondaryStr = tokens.nextToken();
                    if (secondaryStr.equalsIgnoreCase("TCPIP") && primaryProto != 2) {
                        secondaryProto = 2;
                    } else if (secondaryStr.equalsIgnoreCase("NetBIOS") && primaryProto != 1) {
                        secondaryProto = 1;
                    } else {
                        throw new InvalidConfigurationException("Invalid secondary protocol, " + secondaryStr);
                    }
                }
            }
            AuthSessionFactory.setProtocolOrder(primaryProto, secondaryProto);
            if (this.hasDebug()) {
                Debug.println("Protocol order primary=" + Protocol.asString(primaryProto) + ", secondary=" + Protocol.asString(secondaryProto));
            }
        }
        if ((checkInterval = params.getChild("offlineCheckInterval")) != null) {
            try {
                offlineCheck = Integer.parseInt(checkInterval.getValue());
                if (offlineCheck < 10 || offlineCheck > 900) {
                    throw new InvalidConfigurationException("Invalid offline check interval, valid range is 10 to 900");
                }
                this.m_passthruServers = new PassthruServers(offlineCheck);
                if (!this.hasDebug()) ** GOTO lbl46
                Debug.println("Using offline check interval of " + offlineCheck + " seconds");
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid offline check interval specified");
            }
        } else {
            this.m_passthruServers = new PassthruServers();
        }
lbl46:
        // 3 sources

        if (this.hasDebug()) {
            this.m_passthruServers.setDebug(true);
        }
        if ((sessTmoElem = params.getChild("Timeout")) != null) {
            try {
                sessTmo = Integer.parseInt(sessTmoElem.getValue());
                if (sessTmo < 2000 || sessTmo > 30000) {
                    throw new InvalidConfigurationException("Invalid session timeout, valid range is 2000 to 30000");
                }
                this.m_passthruServers.setConnectionTimeout(sessTmo);
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid timeout value specified");
            }
        }
        srvList = null;
        srvNamesElem = params.getChild("Server");
        if (srvNamesElem != null && srvNamesElem.getValue().length() > 0) {
            if (srvList != null) {
                throw new InvalidConfigurationException("Set passthru server via local server or specify name");
            }
            srvList = srvNamesElem.getValue();
        }
        if (srvList != null) {
            this.m_passthruServers.setServerList(srvList);
        } else {
            domainName = null;
            domNameElem = params.getChild("Domain");
            if (domNameElem != null && domNameElem.getValue().length() > 0) {
                if (srvList != null) {
                    throw new InvalidConfigurationException("Specify server or domain name for passthru authentication");
                }
                domainName = domNameElem.getValue();
            }
            if (domainName != null) {
                try {
                    this.m_passthruServers.setDomain(domainName);
                }
                catch (IOException ex) {
                    throw new InvalidConfigurationException("Failed to set domain, " + ex.getMessage());
                }
            }
        }
        if (this.m_passthruServers.getTotalServerCount() == 0) {
            throw new InvalidConfigurationException("No valid authentication servers found for passthru");
        }
        smbServer = (SMBServer)config.findServer("SMB");
        if (smbServer != null) {
            smbServer.addSessionListener(this);
        }
    }

    @Override
    public int getServerCapabilities() {
        return -2147433860;
    }

    @Override
    public void closeAuthenticator() {
        if (this.m_passthruServers != null) {
            this.m_passthruServers.shutdown();
        }
    }

    @Override
    public void sessionClosed(SrvSession sess) {
        block4: {
            PassthruDetails passDetails = (PassthruDetails)this.m_sessions.get(sess.getUniqueId());
            if (passDetails != null) {
                this.m_sessions.remove(sess.getUniqueId());
                try {
                    AuthenticateSession authSess = passDetails.getAuthenticateSession();
                    authSess.CloseSession();
                    if (this.hasDebug()) {
                        Debug.println("Closed auth session, sessId=" + authSess.getSessionId());
                    }
                }
                catch (Exception ex) {
                    if (!this.hasDebug()) break block4;
                    Debug.println("Passthru error closing session (closed) " + ex.getMessage());
                }
            }
        }
    }

    @Override
    public void sessionCreated(SrvSession sess) {
    }

    @Override
    public void sessionLoggedOn(SrvSession sess) {
        block4: {
            PassthruDetails passDetails = (PassthruDetails)this.m_sessions.get(sess.getUniqueId());
            if (passDetails != null) {
                this.m_sessions.remove(sess.getUniqueId());
                try {
                    AuthenticateSession authSess = passDetails.getAuthenticateSession();
                    authSess.CloseSession();
                    if (this.hasDebug()) {
                        Debug.println("Closed auth session, sessId=" + authSess.getSessionId());
                    }
                }
                catch (Exception ex) {
                    if (!this.hasDebug()) break block4;
                    Debug.println("Passthru error closing session (logon) " + ex.getMessage());
                }
            }
        }
    }
}

