/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.config;

import java.util.Date;
import java.util.TimeZone;
import org.alfresco.jlan.server.config.ConfigSection;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;

public class GlobalConfigSection
extends ConfigSection {
    public static final String SectionName = "Global";
    private String m_timeZone;
    private int m_tzOffset;

    public GlobalConfigSection(ServerConfiguration config) {
        super(SectionName, config);
    }

    public final String getTimeZone() {
        return this.m_timeZone;
    }

    public final int getTimeZoneOffset() {
        return this.m_tzOffset;
    }

    public final int setTimeZone(String name) throws InvalidConfigurationException {
        TimeZone tz = TimeZone.getTimeZone(name);
        if (tz == null) {
            throw new InvalidConfigurationException("Invalid timezone, " + name);
        }
        int sts = this.fireConfigurationChange(65540, name);
        int dst = 0;
        if (tz.inDaylightTime(new Date())) {
            dst = tz.getDSTSavings();
        }
        this.m_timeZone = name;
        this.m_tzOffset = -((tz.getRawOffset() + dst) / 60000);
        return sts;
    }

    public final int setTimeZoneOffset(int offset) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(65541, new Integer(offset));
        this.m_tzOffset = offset;
        return sts;
    }
}

