/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.core;

import java.util.Enumeration;
import java.util.Hashtable;
import org.alfresco.jlan.server.core.SharedDevice;

public class SharedDeviceList {
    private Hashtable<String, SharedDevice> m_shares = new Hashtable();

    public SharedDeviceList() {
    }

    public SharedDeviceList(SharedDeviceList shrList) {
        this.addShares(shrList);
    }

    public final boolean addShare(SharedDevice shr) {
        if (this.m_shares.containsKey(shr.getName())) {
            return false;
        }
        this.m_shares.put(shr.getName(), shr);
        return true;
    }

    public final void addShares(SharedDeviceList shrList) {
        Enumeration<SharedDevice> enm = shrList.enumerateShares();
        while (enm.hasMoreElements()) {
            this.addShare(enm.nextElement());
        }
    }

    public final SharedDevice deleteShare(String name) {
        return this.m_shares.remove(name);
    }

    public final Enumeration<SharedDevice> enumerateShares() {
        return this.m_shares.elements();
    }

    public final SharedDevice findShare(String name) {
        return this.m_shares.get(name);
    }

    public final SharedDevice findShare(String name, int typ, boolean nocase) {
        Enumeration<String> keys = this.m_shares.keys();
        while (keys.hasMoreElements()) {
            SharedDevice share;
            String curName = keys.nextElement();
            if ((nocase || !curName.equals(name)) && (!nocase || !curName.equalsIgnoreCase(name)) || (share = this.m_shares.get(curName)).getType() != typ && typ != -1) continue;
            return share;
        }
        return null;
    }

    public final int numberOfShares() {
        return this.m_shares.size();
    }

    public final int removeUnavailableShares() {
        Enumeration<SharedDevice> shrEnum = this.enumerateShares();
        int remCnt = 0;
        while (shrEnum.hasMoreElements()) {
            SharedDevice shr = shrEnum.nextElement();
            if (shr.getContext() == null || shr.getContext().isAvailable()) continue;
            this.deleteShare(shr.getName());
            ++remCnt;
        }
        return remCnt;
    }

    public final void removeAllShares() {
        this.m_shares.clear();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        Enumeration<String> enm = this.m_shares.keys();
        while (enm.hasMoreElements()) {
            String name = enm.nextElement();
            str.append(name);
            str.append(",");
        }
        if (str.length() > 1) {
            str.setLength(str.length() - 1);
        }
        str.append("]");
        return str.toString();
    }
}

