/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.cluster;

import java.io.Serializable;
import java.util.HashMap;
import org.alfresco.jlan.server.filesys.ExistingOpLockException;
import org.alfresco.jlan.server.filesys.FileStatus;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterFileStateCache;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterNode;
import org.alfresco.jlan.server.filesys.cache.cluster.PerNodeState;
import org.alfresco.jlan.server.filesys.cache.hazelcast.RemoteOpLockDetails;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFileList;
import org.alfresco.jlan.server.locking.LocalOpLockDetails;
import org.alfresco.jlan.server.locking.OpLockDetails;

public abstract class ClusterFileState
extends FileState
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int UpdateOplock = 1;
    public static final int UpdateSharingMode = 2;
    public static final int UpdateByteLock = 4;
    public static final int UpdateFileStatus = 8;
    public static final int UpdateChangeDate = 16;
    public static final int UpdateModifyDate = 32;
    public static final int UpdateFileSize = 64;
    public static final int UpdateAllocSize = 128;
    public static final int UpdateOpenCount = 256;
    public static final int UpdateRetentionExpire = 512;
    private static final String[] _updateStr = new String[]{"OpLock", "SharingMode", "ByteLock", "FileSts", "ChangeDate", "ModDate", "Size", "Alloc", "OpenCount", "Retention"};
    public static final int UpdateMaskCount = _updateStr.length + 1;
    private transient int m_stateUpdates;
    private transient ClusterFileStateCache m_stateCache;
    private Object m_primaryOwner;
    private Object m_dataUpdateNode;
    private transient int m_fileStsReason;

    public ClusterFileState() {
    }

    public ClusterFileState(String fname, boolean caseSensitive) {
        super(fname, caseSensitive);
    }

    @Override
    public OpLockDetails getOpLock() {
        OpLockDetails oplock = super.getOpLock();
        if (oplock != null && oplock instanceof RemoteOpLockDetails) {
            RemoteOpLockDetails remoteOplock = (RemoteOpLockDetails)oplock;
            remoteOplock.setStateCache(this.getStateCache());
        }
        return oplock;
    }

    public final Object getPrimaryOwner() {
        return this.m_primaryOwner;
    }

    public final boolean hasPrimaryOwner() {
        return this.m_primaryOwner != null;
    }

    public final void setPrimaryOwner(Object priOwner) {
        if (this.getOpenCount() == 0) {
            this.m_primaryOwner = priOwner;
        }
    }

    public final void setNormalizedPath(String path) {
        this.setPathInternal(path);
    }

    protected final ClusterFileStateCache getStateCache() {
        return this.m_stateCache;
    }

    public void setStateCache(ClusterFileStateCache stateCache) {
        this.m_stateCache = stateCache;
    }

    @Override
    public int getFileId() {
        PerNodeState perNode;
        int fileId = -1;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this, false)) != null) {
            fileId = perNode.getFileId();
        }
        return fileId;
    }

    @Override
    public void setFileId(int id) {
        PerNodeState perNode;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this, true)) != null) {
            perNode.setFileId(id);
        }
    }

    @Override
    public int getDataStatus() {
        PerNodeState perNode;
        int dataSts = 2;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this, false)) != null) {
            dataSts = perNode.getDataStatus();
        }
        return dataSts;
    }

    @Override
    public void setDataStatus(int sts) {
        PerNodeState perNode;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this, true)) != null) {
            perNode.setDataStatus(sts);
        }
    }

    @Override
    protected HashMap<String, Object> getAttributeMap(boolean createMap) {
        PerNodeState perNode;
        HashMap<String, Object> attrMap = null;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this, createMap)) != null) {
            attrMap = perNode.getAttributeMap(createMap);
        }
        return attrMap;
    }

    @Override
    protected PseudoFileList getPseudoFileList(boolean createList) {
        PerNodeState perNode;
        PseudoFileList pseudoList = null;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this, createList)) != null) {
            pseudoList = perNode.getPseudoFileList(createList);
        }
        return pseudoList;
    }

    @Override
    public Object getFilesystemObject() {
        PerNodeState perNode;
        Object fileSysObj = null;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this, false)) != null) {
            fileSysObj = perNode.getFilesystemObject();
        }
        return fileSysObj;
    }

    @Override
    public void setFilesystemObject(Object filesysObj) {
        PerNodeState perNode;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this, true)) != null) {
            perNode.setFilesystemObject(filesysObj);
        }
    }

    public boolean hasLocalOpLock() {
        PerNodeState perNode;
        boolean oplockSts = false;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this, false)) != null && perNode.hasOpLock()) {
            oplockSts = true;
        }
        return oplockSts;
    }

    public LocalOpLockDetails getLocalOpLock() {
        PerNodeState perNode;
        LocalOpLockDetails localOpLock = null;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this, false)) != null && perNode.hasOpLock()) {
            localOpLock = perNode.getOpLock();
        }
        return localOpLock;
    }

    public synchronized void setLocalOpLock(LocalOpLockDetails oplock) throws ExistingOpLockException {
        PerNodeState perNode;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this, true)) != null) {
            perNode.setOpLock(oplock);
        }
    }

    public synchronized void clearLocalOpLock() {
        PerNodeState perNode;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this, false)) != null) {
            perNode.clearOpLock();
        }
    }

    @Override
    public boolean canReadFile(long offset, long len, int pid) {
        if (this.getStateCache() != null) {
            return this.getStateCache().canReadFile(this, offset, len, pid);
        }
        throw new RuntimeException("State cache not set for cluster state, path=" + this.getPath() + " (canRead)");
    }

    @Override
    public boolean canWriteFile(long offset, long len, int pid) {
        if (this.getStateCache() != null) {
            return this.getStateCache().canWriteFile(this, offset, len, pid);
        }
        throw new RuntimeException("State cache not set for cluster state, path=" + this.getPath() + " (canWrite)");
    }

    public final int getPendingUpdates() {
        return this.m_stateUpdates;
    }

    public final int clearPendingUpdates() {
        int updMask = this.m_stateUpdates;
        this.m_stateUpdates = 0;
        return updMask;
    }

    public final void setUpdateMask(int updMask) {
        this.m_stateUpdates = updMask;
    }

    public final void setFileStatusInternal(int fSts, int reason) {
        super.setFileStatus(fSts, reason);
        this.m_fileStsReason = reason;
    }

    public final int getStatusChangeReason() {
        return this.m_fileStsReason;
    }

    public final void setStatusChangeReason(int reason) {
        this.m_fileStsReason = reason;
    }

    @Override
    public boolean hasDataUpdateInProgress() {
        if (this.m_dataUpdateNode != null && this.m_dataUpdateNode instanceof ClusterNode) {
            if (this.getStateCache() != null) {
                ClusterNode updateNode = (ClusterNode)this.m_dataUpdateNode;
                if (this.getStateCache().getCluster().getLocalNode().equals(updateNode)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public Object getDataUpdateNode() {
        return this.m_dataUpdateNode;
    }

    public void setDataUpdateNode(Object updateNode) {
        this.m_dataUpdateNode = updateNode;
    }

    public static final String getUpdateMaskAsString(int updMask) {
        if (updMask == 0) {
            return "[Empty]";
        }
        StringBuilder str = new StringBuilder(32);
        str.append("[");
        for (int idx = 0; idx < _updateStr.length; ++idx) {
            if ((updMask & 1 << idx) == 0) continue;
            str.append(_updateStr[idx]);
            str.append(",");
        }
        if (str.length() > 1) {
            str.setLength(str.length() - 1);
        }
        str.append("]");
        return str.toString();
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getPath());
        str.append(",");
        str.append(FileStatus.asString(this.getFileStatus()));
        if (this.getStatusChangeReason() != 0) {
            str.append("(");
            str.append(FileState.getChangeReasonString(this.getStatusChangeReason()));
            str.append(")");
        }
        str.append(":Opn=");
        str.append(super.getOpenCount());
        if (this.getOpenCount() > 0) {
            str.append("(shr=0x");
            str.append(Integer.toHexString(this.getSharedAccess()));
            str.append(",pid=");
            str.append(this.getProcessId());
            str.append(")");
        }
        str.append(",Fid=");
        str.append(this.getFileId());
        str.append(",Expire=");
        str.append(this.getSecondsToExpire(System.currentTimeMillis()));
        str.append(",Sts=");
        str.append(this.getStatusAsString());
        str.append(",Locks=");
        str.append(this.numberOfLocks());
        if (this.hasOpLock()) {
            str.append(",OpLock=");
            str.append(this.getOpLock());
        }
        if (this.hasDataUpdateInProgress()) {
            str.append(",DataUpd=");
            str.append(this.getDataUpdateNode());
        }
        str.append("]");
        return str.toString();
    }
}

