/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterNode;

public class ClusterNodeList {
    private Hashtable<String, ClusterNode> m_nodes;

    public ClusterNodeList() {
        this.m_nodes = new Hashtable();
    }

    public ClusterNodeList(int initCapac) {
        this.m_nodes = new Hashtable(initCapac);
    }

    public final int numberOfNodes() {
        return this.m_nodes.size();
    }

    public final ClusterNode findNode(String name) {
        ClusterNode clNode = this.m_nodes.get(name);
        if (clNode != null) {
            return clNode;
        }
        String nodeName = name;
        int idx = nodeName.indexOf("/");
        if (idx != -1) {
            nodeName = nodeName.substring(idx);
        }
        if (nodeName.startsWith("/")) {
            Enumeration<String> enumNodes = this.enumerateNodes();
            while (enumNodes.hasMoreElements()) {
                String curNodeName = enumNodes.nextElement();
                if (!curNodeName.endsWith(nodeName)) continue;
                return this.m_nodes.get(curNodeName);
            }
        }
        return null;
    }

    public final void addNode(ClusterNode node) {
        this.m_nodes.put(node.getName(), node);
    }

    public final ClusterNode removeNode(String name) {
        return this.m_nodes.remove(name);
    }

    public final Enumeration<String> enumerateNodes() {
        return this.m_nodes.keys();
    }

    public List<ClusterNode> asPriorityOrderedList() {
        ArrayList<ClusterNode> priList = new ArrayList<ClusterNode>(this.m_nodes.size());
        Enumeration<String> keys = this.m_nodes.keys();
        while (keys.hasMoreElements()) {
            priList.add(this.m_nodes.get(keys.nextElement()));
        }
        Collections.sort(priList, new ClusterNodePriorityComparator());
        return priList;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(256);
        str.append("[");
        int nodeCnt = this.numberOfNodes();
        str.append(nodeCnt);
        str.append(":");
        if (nodeCnt > 0) {
            if (nodeCnt > 10) {
                nodeCnt = 10;
            }
            Enumeration<String> nodeNames = this.enumerateNodes();
            while (nodeNames.hasMoreElements() && nodeCnt-- > 0) {
                ClusterNode curNode = this.m_nodes.get(nodeNames.nextElement());
                str.append(curNode);
                str.append(",");
            }
            str.setLength(str.length() - 1);
            if (this.numberOfNodes() > 10) {
                str.append("...");
            }
        }
        str.append("]");
        return str.toString();
    }

    static class ClusterNodePriorityComparator
    implements Comparator<ClusterNode> {
        ClusterNodePriorityComparator() {
        }

        @Override
        public final int compare(ClusterNode node1, ClusterNode node2) {
            if (node1.getPriority() < node2.getPriority()) {
                return -1;
            }
            if (node1.getPriority() > node2.getPriority()) {
                return 1;
            }
            return 0;
        }
    }
}

