/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.filesys.DeferFailedException;
import org.alfresco.jlan.server.filesys.ExistingOpLockException;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFileList;
import org.alfresco.jlan.server.locking.DeferredRequest;
import org.alfresco.jlan.server.locking.LocalOpLockDetails;
import org.alfresco.jlan.smb.server.CIFSThreadRequest;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;

public class PerNodeState {
    public static final int MaxDeferredRequests = 3;
    private int m_fileId = -1;
    private int m_dataStatus = 0;
    private HashMap<String, Object> m_cache;
    private PseudoFileList m_pseudoFiles;
    private Object m_filesysObj;
    private LocalOpLockDetails m_localOpLock;
    private ArrayList<DeferredRequest> m_deferredRequests;
    private long m_oplockBreakTime;

    public int getFileId() {
        return this.m_fileId;
    }

    public int getDataStatus() {
        return this.m_dataStatus;
    }

    public void setFileId(int id) {
        this.m_fileId = id;
    }

    public void setDataStatus(int sts) {
        this.m_dataStatus = sts;
    }

    public boolean hasPseudoFiles() {
        if (this.m_pseudoFiles != null) {
            return this.m_pseudoFiles.numberOfFiles() > 0;
        }
        return false;
    }

    protected PseudoFileList getPseudoFileList(boolean createList) {
        if (this.m_pseudoFiles == null && createList) {
            this.m_pseudoFiles = new PseudoFileList();
        }
        return this.m_pseudoFiles;
    }

    public Object getFilesystemObject() {
        return this.m_filesysObj;
    }

    public void setFilesystemObject(Object filesysObj) {
        this.m_filesysObj = filesysObj;
    }

    protected HashMap<String, Object> getAttributeMap(boolean createMap) {
        if (this.m_cache == null && createMap) {
            this.m_cache = new HashMap();
        }
        return this.m_cache;
    }

    public final void remoteAllAttributes() {
        if (this.m_cache != null) {
            this.m_cache.clear();
            this.m_cache = null;
        }
    }

    public boolean hasOpLock() {
        return this.m_localOpLock != null;
    }

    public LocalOpLockDetails getOpLock() {
        return this.m_localOpLock;
    }

    public synchronized void setOpLock(LocalOpLockDetails oplock) throws ExistingOpLockException {
        if (this.m_localOpLock != null) {
            throw new ExistingOpLockException();
        }
        this.m_localOpLock = oplock;
    }

    public synchronized void clearOpLock() {
        this.m_localOpLock = null;
    }

    public boolean hasDeferredSessions() {
        if (this.m_deferredRequests == null) {
            return false;
        }
        return this.m_deferredRequests.size() > 0;
    }

    public int numberOfDeferredSessions() {
        if (this.m_deferredRequests == null) {
            return 0;
        }
        return this.m_deferredRequests.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requeueDeferredRequests() {
        if (this.m_deferredRequests == null) {
            return 0;
        }
        int requeueCnt = 0;
        ArrayList<DeferredRequest> arrayList = this.m_deferredRequests;
        synchronized (arrayList) {
            for (DeferredRequest deferReq : this.m_deferredRequests) {
                SMBSrvSession sess = deferReq.getDeferredSession();
                SMBSrvPacket pkt = deferReq.getDeferredPacket();
                if (sess.hasDebug(0x8000000)) {
                    Debug.println("Release oplock, queued deferred request to thread pool sess=" + sess.getUniqueId() + ", pkt=" + pkt);
                }
                try {
                    sess.getThreadPool().queueRequest(new CIFSThreadRequest(sess, pkt));
                }
                catch (Throwable ex) {
                    sess.getPacketPool().releasePacket(pkt);
                }
            }
            this.m_deferredRequests.clear();
        }
        return requeueCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int failDeferredRequests() {
        if (this.m_deferredRequests == null) {
            return 0;
        }
        int failCnt = 0;
        ArrayList<DeferredRequest> arrayList = this.m_deferredRequests;
        synchronized (arrayList) {
            for (DeferredRequest deferReq : this.m_deferredRequests) {
                SMBSrvSession sess = deferReq.getDeferredSession();
                SMBSrvPacket pkt = deferReq.getDeferredPacket();
                try {
                    if (sess.sendAsyncErrorResponseSMB(pkt, -1073741790, 6)) {
                        ++failCnt;
                        if (!sess.hasDebug(0x8000000)) continue;
                        Debug.println("Oplock break timeout, oplock=" + this);
                        continue;
                    }
                    if (!sess.hasDebug(0x8000000)) continue;
                    Debug.println("Failed to send open reject, oplock break timed out, oplock=" + this);
                }
                catch (IOException ex) {}
                continue;
                finally {
                    if (pkt == null) continue;
                    sess.getPacketPool().releasePacket(pkt);
                }
            }
            this.m_deferredRequests.clear();
        }
        return failCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeferredSession(SMBSrvSession deferredSess, SMBSrvPacket deferredPkt) throws DeferFailedException {
        Object object;
        if (this.m_deferredRequests == null) {
            object = this;
            synchronized (object) {
                if (this.m_deferredRequests == null) {
                    this.m_deferredRequests = new ArrayList(3);
                }
            }
        }
        object = this.m_deferredRequests;
        synchronized (object) {
            if (this.m_deferredRequests.size() < 3) {
                this.m_deferredRequests.add(new DeferredRequest(deferredSess, deferredPkt));
                deferredPkt.incrementDeferredCount();
                if (this.m_deferredRequests.size() == 1) {
                    this.m_oplockBreakTime = System.currentTimeMillis();
                }
                if (deferredSess.hasDebug(0x8000000)) {
                    Debug.println("Added deferred request, list=" + this.m_deferredRequests.size() + ", oplock=" + this);
                }
            } else {
                throw new DeferFailedException("No more deferred slots available on oplock");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDeferredPacketLease() {
        if (this.m_deferredRequests != null) {
            ArrayList<DeferredRequest> arrayList = this.m_deferredRequests;
            synchronized (arrayList) {
                long newLeaseTime = System.currentTimeMillis() + 5000L;
                for (DeferredRequest deferReq : this.m_deferredRequests) {
                    deferReq.getDeferredPacket().setLeaseTime(newLeaseTime);
                }
            }
        }
    }

    public final long getOplockBreakTime() {
        return this.m_oplockBreakTime;
    }

    public void finalize() {
        if (this.m_deferredRequests != null && this.m_deferredRequests.size() > 0) {
            Debug.println("** Deferred requests found during per node finalize, perNode=" + this);
            for (DeferredRequest deferReq : this.m_deferredRequests) {
                Debug.println("**  Leaked deferred request=" + deferReq);
            }
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[FID=");
        str.append(this.getFileId());
        str.append(",data=");
        str.append(this.getDataStatus());
        str.append(",filesysObj=");
        str.append(this.getFilesystemObject());
        str.append(",oplock=");
        str.append(this.getOpLock());
        if (this.hasDeferredSessions()) {
            str.append(",DeferList=");
            str.append(this.numberOfDeferredSessions());
        }
        str.append("]");
        return str.toString();
    }
}

