/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.hazelcast;

import com.hazelcast.core.IMap;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.locking.FileLockList;
import org.alfresco.jlan.locking.LockConflictException;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterFileLock;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterFileState;
import org.alfresco.jlan.server.filesys.cache.hazelcast.RemoteStateTask;

public class AddFileByteLockTask
extends RemoteStateTask<ClusterFileState> {
    private static final long serialVersionUID = 1L;
    private ClusterFileLock m_lock;

    public AddFileByteLockTask() {
    }

    public AddFileByteLockTask(String mapName, String key, ClusterFileLock lock, boolean debug, boolean timingDebug) {
        super(mapName, key, true, false, debug, timingDebug);
        this.m_lock = lock;
    }

    @Override
    protected ClusterFileState runRemoteTaskAgainstState(IMap<String, ClusterFileState> stateCache, ClusterFileState fState) throws Exception {
        if (this.hasDebug()) {
            Debug.println("AddFileByteLockTask: Add lock=" + this.m_lock + " to " + fState);
        }
        if (!fState.hasActiveLocks()) {
            fState.addLock(this.m_lock);
        } else {
            FileLockList lockList = fState.getLockList();
            int idx = 0;
            boolean lockConflict = false;
            while (idx < lockList.numberOfLocks() && !lockConflict) {
                ClusterFileLock curLock;
                if (!(curLock = (ClusterFileLock)lockList.getLockAt(idx++)).hasOverlap(this.m_lock) || curLock.getProcessId() == this.m_lock.getProcessId() && curLock.getOwnerNode().equalsIgnoreCase(this.m_lock.getOwnerNode())) continue;
                if (this.hasDebug()) {
                    Debug.println("AddLock Lock conflict with lock=" + curLock);
                }
                throw new LockConflictException();
            }
            fState.addLock(this.m_lock);
        }
        return fState;
    }
}

