/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.hazelcast;

import com.hazelcast.core.IMap;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterFileState;
import org.alfresco.jlan.server.filesys.cache.hazelcast.RemoteStateTask;
import org.alfresco.jlan.server.locking.OpLockDetails;
import org.alfresco.jlan.smb.OpLock;

public class ChangeOpLockTypeTask
extends RemoteStateTask<Integer> {
    private static final long serialVersionUID = 1L;
    private int m_oplockType;

    public ChangeOpLockTypeTask() {
    }

    public ChangeOpLockTypeTask(String mapName, String key, int newLockType, boolean debug, boolean timingDebug) {
        super(mapName, key, true, false, debug, timingDebug);
        this.m_oplockType = newLockType;
    }

    @Override
    protected Integer runRemoteTaskAgainstState(IMap<String, ClusterFileState> stateCache, ClusterFileState fState) throws Exception {
        if (this.hasDebug()) {
            Debug.println("ChangeOpLockTypeTask: New type=" + OpLock.getTypeAsString(this.m_oplockType) + " for state " + fState);
        }
        OpLockDetails oplock = fState.getOpLock();
        int newType = -1;
        if (oplock != null) {
            int oldOpLockType = oplock.getLockType();
            oplock.setLockType(this.m_oplockType);
            newType = this.m_oplockType;
            if (this.hasDebug()) {
                Debug.println("ChangeOpLockTypeTask: Changed type from=" + OpLock.getTypeAsString(oldOpLockType) + " to=" + OpLock.getTypeAsString(this.m_oplockType));
            }
        }
        return new Integer(newType);
    }
}

