/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IMap;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterFileState;

public abstract class RemoteStateTask<T>
implements Callable<T>,
HazelcastInstanceAware,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int TaskDebug = 1;
    public static final int TaskLockState = 2;
    public static final int TaskNoUpdate = 4;
    public static final int TaskTiming = 8;
    private String m_mapName;
    private String m_keyName;
    private transient HazelcastInstance m_hcInstance;
    private short m_taskOptions;
    private transient String m_taskName;

    public RemoteStateTask() {
    }

    public RemoteStateTask(String mapName, String key, int options) {
        this.m_mapName = mapName;
        this.m_keyName = key;
        this.m_taskOptions = (short)options;
    }

    public RemoteStateTask(String mapName, String key, boolean lockState, boolean noUpdate, boolean debug, boolean timingDebug) {
        this.m_mapName = mapName;
        this.m_keyName = key;
        if (lockState) {
            this.m_taskOptions = (short)(this.m_taskOptions + 2);
        }
        if (noUpdate) {
            this.m_taskOptions = (short)(this.m_taskOptions + 4);
        }
        if (debug) {
            this.m_taskOptions = (short)(this.m_taskOptions + 1);
        }
        if (timingDebug) {
            this.m_taskOptions = (short)(this.m_taskOptions + 8);
        }
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.m_hcInstance;
    }

    public void setHazelcastInstance(HazelcastInstance hcInstance) {
        this.m_hcInstance = hcInstance;
    }

    public final String getMapName() {
        return this.m_mapName;
    }

    public final String getKey() {
        return this.m_keyName;
    }

    public final boolean hasOption(int option) {
        return (this.m_taskOptions & option) != 0;
    }

    public final boolean hasDebug() {
        return this.hasOption(1);
    }

    public final boolean hasTimingDebug() {
        return this.hasOption(8);
    }

    public final String getTaskName() {
        if (this.m_taskName == null) {
            this.m_taskName = this.getClass().getSimpleName();
        }
        return this.m_taskName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        ClusterFileState fState;
        IMap cache;
        long startTime = 0L;
        long lockTime = 0L;
        long unlockTime = 0L;
        if (this.hasTimingDebug()) {
            startTime = System.currentTimeMillis();
        }
        if ((cache = this.getHazelcastInstance().getMap(this.getMapName())) == null) {
            throw new Exception("Failed to find clustered map " + this.getMapName());
        }
        if (this.hasOption(2)) {
            long lockStart = 0L;
            if (this.hasTimingDebug()) {
                lockStart = System.currentTimeMillis();
            }
            cache.lock((Object)this.getKey());
            if (this.hasTimingDebug()) {
                lockTime = System.currentTimeMillis() - lockStart;
            }
        }
        if ((fState = (ClusterFileState)cache.get((Object)this.getKey())) == null) {
            if (this.hasOption(2)) {
                cache.unlock((Object)this.getKey());
            }
            throw new Exception("Failed to find file state for " + this.getKey());
        }
        T retVal = null;
        try {
            retVal = this.runRemoteTaskAgainstState((IMap<String, ClusterFileState>)cache, fState);
            if (!this.hasOption(4)) {
                cache.put((Object)this.getKey(), (Object)fState);
                if (this.hasDebug()) {
                    Debug.println("Remote task " + this.getTaskName() + " updated state=" + fState);
                }
            }
        }
        finally {
            if (this.hasOption(2)) {
                long lockEnd = 0L;
                if (this.hasTimingDebug()) {
                    lockEnd = System.currentTimeMillis();
                }
                cache.unlock((Object)this.getKey());
                if (this.hasTimingDebug()) {
                    unlockTime = System.currentTimeMillis() - lockEnd;
                }
            }
            if (this.hasTimingDebug()) {
                Debug.println("Remote task " + this.getTaskName() + " executed in " + (System.currentTimeMillis() - startTime) + "ms (lock " + lockTime + "ms, unlock " + unlockTime + "ms)");
            }
        }
        return retVal;
    }

    protected abstract T runRemoteTaskAgainstState(IMap<String, ClusterFileState> var1, ClusterFileState var2) throws Exception;
}

