/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.hazelcast;

import com.hazelcast.core.IMap;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.locking.FileLockList;
import org.alfresco.jlan.locking.NotLockedException;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterFileLock;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterFileState;
import org.alfresco.jlan.server.filesys.cache.hazelcast.RemoteStateTask;

public class RemoveFileByteLockTask
extends RemoteStateTask<ClusterFileState> {
    private static final long serialVersionUID = 1L;
    private ClusterFileLock m_lock;

    public RemoveFileByteLockTask() {
    }

    public RemoveFileByteLockTask(String mapName, String key, ClusterFileLock lock, boolean debug, boolean timingDebug) {
        super(mapName, key, true, false, debug, timingDebug);
        this.m_lock = lock;
    }

    @Override
    protected ClusterFileState runRemoteTaskAgainstState(IMap<String, ClusterFileState> stateCache, ClusterFileState fState) throws Exception {
        FileLockList lockList;
        ClusterFileLock clLock;
        if (this.hasDebug()) {
            Debug.println("RemoveFileByteLockTask: Remove lock=" + this.m_lock + " from " + fState);
        }
        if ((clLock = (ClusterFileLock)(lockList = fState.getLockList()).findLock(this.m_lock)) == null || !clLock.getOwnerNode().equalsIgnoreCase(this.m_lock.getOwnerNode())) {
            throw new NotLockedException();
        }
        lockList.removeLock(clLock);
        return fState;
    }
}

