/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.hazelcast;

import com.hazelcast.core.IMap;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterFileState;
import org.alfresco.jlan.server.filesys.cache.hazelcast.RemoteStateTask;

public class RenameStateTask
extends RemoteStateTask<Boolean> {
    private static final long serialVersionUID = 1L;
    private String m_newKey;
    private boolean m_folder;

    public RenameStateTask() {
    }

    public RenameStateTask(String mapName, String key, String newKey, boolean isFolder, boolean debug, boolean timingDebug) {
        super(mapName, key, true, true, debug, timingDebug);
        this.m_newKey = newKey;
        this.m_folder = isFolder;
    }

    @Override
    protected Boolean runRemoteTaskAgainstState(IMap<String, ClusterFileState> stateCache, ClusterFileState fState) throws Exception {
        if (this.hasDebug()) {
            Debug.println("RenameStateTask: Rename from " + this.getKey() + " to " + this.m_newKey);
        }
        ClusterFileState state = (ClusterFileState)stateCache.remove((Object)this.getKey());
        state.setFileStatusInternal(this.m_folder ? 2 : 1, 0);
        state.removeAllAttributes();
        state.setPathInternal(this.m_newKey);
        stateCache.put((Object)state.getPath(), (Object)state);
        if (this.hasDebug()) {
            Debug.println("Rename to " + this.m_newKey + " successful, state=" + state);
        }
        return new Boolean(true);
    }
}

