/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.hazelcast;

import org.alfresco.jlan.server.filesys.FileStatus;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterFileState;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterNode;
import org.alfresco.jlan.server.filesys.cache.hazelcast.ClusterMessage;

public class StateUpdateMessage
extends ClusterMessage {
    private static final long serialVersionUID = 1L;
    private String m_path;
    private int m_updateMask;
    private int m_fileStatus;
    private int m_fileStsReason;
    private long m_fileSize;
    private long m_allocSize;
    private long m_changeDate;
    private long m_modifyDate;
    private long m_retentionDate;

    public StateUpdateMessage() {
    }

    public StateUpdateMessage(String targetNode, ClusterNode fromNode, ClusterFileState clState, int updateMask) {
        super(targetNode, fromNode, 3);
        this.m_updateMask = updateMask;
        this.m_path = clState.getPath();
        if (this.hasUpdate(8)) {
            this.m_fileStatus = clState.getFileStatus();
            this.m_fileStsReason = clState.getStatusChangeReason();
        }
        if (this.hasUpdate(64)) {
            this.m_fileSize = clState.getFileSize();
        }
        if (this.hasUpdate(128)) {
            this.m_allocSize = clState.getAllocationSize();
        }
        if (this.hasUpdate(16)) {
            this.m_changeDate = clState.getChangeDateTime();
        }
        if (this.hasUpdate(32)) {
            this.m_modifyDate = clState.getModifyDateTime();
        }
        if (this.hasUpdate(512)) {
            this.m_retentionDate = clState.getRetentionExpiryDateTime();
        }
    }

    public boolean hasUpdate(int upd) {
        return (this.m_updateMask & upd) != 0;
    }

    public final int getUpdateMask() {
        return this.m_updateMask;
    }

    public final String getPath() {
        return this.m_path;
    }

    public final int getFileStatus() {
        return this.m_fileStatus;
    }

    public final int getStatusChangeReason() {
        return this.m_fileStsReason;
    }

    public final long getFileSize() {
        return this.m_fileSize;
    }

    public final long getAllocationSize() {
        return this.m_allocSize;
    }

    public final long getChangeDateTime() {
        return this.m_changeDate;
    }

    public final long getModificationDateTime() {
        return this.m_modifyDate;
    }

    public final long getRetentionDateTime() {
        return this.m_retentionDate;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(super.toString());
        str.append(",path=");
        str.append(this.getPath());
        str.append(",updates=");
        str.append(ClusterFileState.getUpdateMaskAsString(this.getUpdateMask()));
        if (this.hasUpdate(8)) {
            str.append(",fileSts=");
            str.append(FileStatus.asString(this.getFileStatus()));
            if (this.getStatusChangeReason() != 0) {
                str.append(",reason=");
                str.append(FileState.getChangeReasonString(this.getStatusChangeReason()));
            }
        }
        if (this.hasUpdate(64)) {
            str.append(",fsize=");
            str.append(this.getFileSize());
        }
        if (this.hasUpdate(128)) {
            str.append(",alloc=");
            str.append(this.getAllocationSize());
        }
        if (this.hasUpdate(16)) {
            str.append(",change=");
            str.append(this.getChangeDateTime());
        }
        if (this.hasUpdate(32)) {
            str.append(",modify=");
            str.append(this.getModificationDateTime());
        }
        if (this.hasUpdate(512)) {
            str.append(",retain=");
            str.append(this.getRetentionDateTime());
        }
        str.append("]");
        return str.toString();
    }
}

