/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.pseudo;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.LocalFileState;
import org.alfresco.jlan.server.filesys.cache.NetworkFileStateInterface;

public class PseudoNetworkFile
extends NetworkFile
implements NetworkFileStateInterface {
    protected File m_file;
    protected RandomAccessFile m_io;
    protected boolean m_eof;
    private FileState m_state;

    public PseudoNetworkFile(String name, String localPath, String netPath) {
        super(name);
        this.m_file = new File(localPath);
        this.setFileSize(this.m_file.length());
        this.m_eof = false;
        long modDate = this.m_file.lastModified();
        this.setModifyDate(modDate);
        this.setCreationDate(modDate);
        this.setFileId(netPath.hashCode());
        this.setFullName(netPath);
    }

    @Override
    public void closeFile() throws IOException {
        if (this.m_io != null) {
            this.m_io.close();
            this.m_io = null;
            if (this.getWriteCount() > 0) {
                this.m_file.setLastModified(System.currentTimeMillis());
            }
            this.setClosed(true);
        }
        this.m_state = null;
    }

    public long currentPosition() {
        try {
            if (this.m_io != null) {
                return this.m_io.getFilePointer();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    @Override
    public void flushFile() throws IOException {
        if (this.m_io != null) {
            this.m_io.getFD().sync();
        }
    }

    public boolean isEndOfFile() throws IOException {
        return this.m_io != null && this.m_io.getFilePointer() == this.m_io.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFile(boolean createFlag) throws IOException {
        File file = this.m_file;
        synchronized (file) {
            if (this.m_io == null) {
                this.m_io = new RandomAccessFile(this.m_file, "r");
                this.setClosed(false);
            }
        }
    }

    @Override
    public int readFile(byte[] buf, int len, int pos, long fileOff) throws IOException {
        if (this.m_io == null) {
            this.openFile(false);
        }
        if (this.currentPosition() != fileOff) {
            this.seekFile(fileOff, 0);
        }
        int rdlen = this.m_io.read(buf, pos, len);
        return rdlen;
    }

    @Override
    public long seekFile(long pos, int typ) throws IOException {
        if (this.m_io == null) {
            this.openFile(false);
        }
        switch (typ) {
            case 0: {
                if (this.currentPosition() == pos) break;
                this.m_io.seek(pos);
                break;
            }
            case 1: {
                this.m_io.seek(this.currentPosition() + pos);
                break;
            }
            case 2: {
                long newPos = this.m_io.length() + pos;
                this.m_io.seek(newPos);
            }
        }
        return this.currentPosition();
    }

    @Override
    public void truncateFile(long siz) throws IOException {
    }

    public void writeFile(byte[] buf, int len, int pos) throws IOException {
    }

    @Override
    public void writeFile(byte[] buf, int len, int pos, long offset) throws IOException {
    }

    @Override
    public FileState getFileState() {
        if (this.m_state == null) {
            this.m_state = new LocalFileState(this.getFullName(), false);
        }
        return this.m_state;
    }
}

