/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.locking;

import java.io.IOException;
import java.util.ArrayList;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.filesys.DeferFailedException;
import org.alfresco.jlan.server.locking.DeferredRequest;
import org.alfresco.jlan.server.locking.OpLockDetailsAdapter;
import org.alfresco.jlan.smb.OpLock;
import org.alfresco.jlan.smb.server.CIFSThreadRequest;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;

public class LocalOpLockDetails
extends OpLockDetailsAdapter {
    public static final int MaxDeferredRequests = 3;
    private int m_type;
    private String m_path;
    private boolean m_folder;
    private ArrayList<DeferredRequest> m_deferredRequests = new ArrayList(3);
    private long m_opBreakTime;
    private boolean m_failedBreak;
    private SMBSrvSession m_ownerSess;
    private int m_pid;
    private int m_uid;
    private int m_treeId;
    private int m_fileId;

    public LocalOpLockDetails(int lockTyp, String path, SMBSrvSession sess, int pid, int uid, int treeId, int fileId, boolean folder) {
        this.m_type = lockTyp;
        this.m_path = path;
        this.m_folder = folder;
        this.m_ownerSess = sess;
        this.m_pid = pid;
        this.m_uid = uid;
        this.m_treeId = treeId;
        this.m_fileId = fileId;
    }

    public LocalOpLockDetails(int lockTyp, String path, SMBSrvSession sess, SMBSrvPacket pkt, boolean folder) {
        this.m_type = lockTyp;
        this.m_path = path;
        this.m_folder = folder;
        this.m_ownerSess = sess;
        this.m_pid = pkt.getProcessId();
        this.m_uid = pkt.getUserId();
        this.m_treeId = pkt.getTreeId();
        this.m_fileId = -1;
    }

    public LocalOpLockDetails(int lockTyp, String path, SMBSrvSession sess, int pid, int treeId, boolean folder) {
        this.m_type = lockTyp;
        this.m_path = path;
        this.m_folder = folder;
        this.m_ownerSess = sess;
        this.m_pid = pid;
        this.m_treeId = treeId;
        this.m_uid = -1;
        this.m_fileId = -1;
    }

    @Override
    public int getLockType() {
        return this.m_type;
    }

    public SMBSrvSession getOwnerSession() {
        return this.m_ownerSess;
    }

    public final int getOwnerPID() {
        return this.m_pid;
    }

    public final int getOwnerUID() {
        return this.m_uid;
    }

    public final int getOwnerTreeId() {
        return this.m_treeId;
    }

    public final int getOwnerFileId() {
        return this.m_fileId;
    }

    @Override
    public String getPath() {
        return this.m_path;
    }

    @Override
    public boolean isFolder() {
        return this.m_folder;
    }

    @Override
    public long getOplockBreakTime() {
        return this.m_opBreakTime;
    }

    @Override
    public boolean hasOplockBreakFailed() {
        return this.m_failedBreak;
    }

    @Override
    public boolean isRemoteLock() {
        return false;
    }

    @Override
    public final void setOwnerFileId(int fileId) {
        this.m_fileId = fileId;
    }

    @Override
    public final void setOplockBreakFailed() {
        this.m_failedBreak = true;
    }

    @Override
    public void setLockType(int lockTyp) {
        this.m_type = lockTyp;
    }

    @Override
    public boolean hasDeferredSessions() {
        return this.m_deferredRequests.size() > 0;
    }

    @Override
    public int numberOfDeferredSessions() {
        return this.m_deferredRequests.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int requeueDeferredRequests() {
        int requeueCnt = 0;
        ArrayList<DeferredRequest> arrayList = this.m_deferredRequests;
        synchronized (arrayList) {
            for (DeferredRequest deferReq : this.m_deferredRequests) {
                SMBSrvSession sess = deferReq.getDeferredSession();
                SMBSrvPacket pkt = deferReq.getDeferredPacket();
                if (sess.hasDebug(0x8000000)) {
                    Debug.println("Release oplock, queued deferred request to thread pool sess=" + sess.getUniqueId() + ", pkt=" + pkt);
                }
                try {
                    sess.getThreadPool().queueRequest(new CIFSThreadRequest(sess, pkt));
                }
                catch (Throwable ex) {
                    sess.getPacketPool().releasePacket(pkt);
                }
            }
            this.m_deferredRequests.clear();
        }
        return requeueCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int failDeferredRequests() {
        int failCnt = 0;
        ArrayList<DeferredRequest> arrayList = this.m_deferredRequests;
        synchronized (arrayList) {
            for (DeferredRequest deferReq : this.m_deferredRequests) {
                SMBSrvSession sess = deferReq.getDeferredSession();
                SMBSrvPacket pkt = deferReq.getDeferredPacket();
                try {
                    if (sess.sendAsyncErrorResponseSMB(pkt, -1073741790, 6)) {
                        ++failCnt;
                        if (!sess.hasDebug(0x8000000)) continue;
                        Debug.println("Oplock break timeout, oplock=" + this);
                        continue;
                    }
                    if (!sess.hasDebug(0x8000000)) continue;
                    Debug.println("Failed to send open reject, oplock break timed out, oplock=" + this);
                }
                catch (IOException ex) {}
                continue;
                finally {
                    if (pkt == null) continue;
                    sess.getPacketPool().releasePacket(pkt);
                }
            }
            this.m_deferredRequests.clear();
        }
        return failCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDeferredSession(SMBSrvSession deferredSess, SMBSrvPacket deferredPkt) throws DeferFailedException {
        ArrayList<DeferredRequest> arrayList = this.m_deferredRequests;
        synchronized (arrayList) {
            if (this.m_deferredRequests.size() < 3) {
                this.m_deferredRequests.add(new DeferredRequest(deferredSess, deferredPkt));
                deferredPkt.incrementDeferredCount();
                if (this.m_deferredRequests.size() == 1) {
                    this.m_opBreakTime = System.currentTimeMillis();
                }
                if (deferredSess.hasDebug(0x8000000)) {
                    Debug.println("Added deferred request, list=" + this.m_deferredRequests.size() + ", oplock=" + this);
                }
            } else {
                throw new DeferFailedException("No more deferred slots available on oplock");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDeferredPacketLease() {
        ArrayList<DeferredRequest> arrayList = this.m_deferredRequests;
        synchronized (arrayList) {
            long newLeaseTime = System.currentTimeMillis() + 5000L;
            for (DeferredRequest deferReq : this.m_deferredRequests) {
                deferReq.getDeferredPacket().setLeaseTime(newLeaseTime);
            }
        }
    }

    @Override
    public void requestOpLockBreak() throws IOException {
        if (this.getOwnerSession() == null || this.hasOplockBreakFailed()) {
            return;
        }
        SMBSrvPacket opBreakPkt = new SMBSrvPacket(128);
        opBreakPkt.clearHeader();
        opBreakPkt.setCommand(36);
        opBreakPkt.setFlags(0);
        opBreakPkt.setFlags2(0);
        opBreakPkt.setTreeId(this.getOwnerTreeId());
        opBreakPkt.setProcessId(65535);
        opBreakPkt.setUserId(0);
        opBreakPkt.setMultiplexId(65535);
        opBreakPkt.setParameterCount(8);
        opBreakPkt.setAndXCommand(255);
        opBreakPkt.setParameter(1, 0);
        opBreakPkt.setParameter(2, this.getOwnerFileId());
        opBreakPkt.setParameter(3, 258);
        opBreakPkt.setParameterLong(4, 0);
        opBreakPkt.setParameter(6, 0);
        opBreakPkt.setParameter(7, 0);
        opBreakPkt.setByteCount(0);
        opBreakPkt.setRequestPacket(true);
        boolean breakSent = this.getOwnerSession().sendAsynchResponseSMB(opBreakPkt, opBreakPkt.getLength());
        this.m_opBreakTime = System.currentTimeMillis();
        if (this.getOwnerSession().hasDebug(0x8000000)) {
            this.getOwnerSession().debugPrintln("Oplock break sent to " + this.getOwnerSession().getUniqueId() + " async=" + (breakSent ? "Sent" : "Queued"));
        }
    }

    @Override
    public boolean hasBreakInProgress() {
        return this.m_opBreakTime != 0L && !this.hasOplockBreakFailed();
    }

    public void finalize() {
        if (this.m_deferredRequests != null && this.m_deferredRequests.size() > 0) {
            Debug.println("** Deferred requests found during oplock finalize, oplock=" + this);
            for (DeferredRequest deferReq : this.m_deferredRequests) {
                Debug.println("**  Leaked deferred request=" + deferReq);
            }
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Local Type=");
        str.append(OpLock.getTypeAsString(this.getLockType()));
        str.append(",");
        str.append(this.getPath());
        str.append(",Owner=");
        if (this.getOwnerSession() != null) {
            str.append(this.getOwnerSession().getUniqueId());
        } else {
            str.append("NULL");
        }
        str.append(",PID=");
        str.append(this.getOwnerPID());
        str.append(",UID=");
        str.append(this.getOwnerUID());
        str.append(",TreeID=");
        str.append(this.getOwnerTreeId());
        str.append(",FileId=");
        str.append(this.getOwnerFileId());
        if (this.hasDeferredSessions()) {
            str.append(",DeferList=");
            str.append(this.numberOfDeferredSessions());
        }
        if (this.hasOplockBreakFailed()) {
            str.append(" BreakFailed");
        } else if (this.hasBreakInProgress()) {
            str.append(" BreakInProgress");
        }
        str.append("]");
        return str.toString();
    }
}

