/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.dcerpc.info;

import org.alfresco.jlan.smb.dcerpc.DCEBuffer;
import org.alfresco.jlan.smb.dcerpc.DCEBufferException;
import org.alfresco.jlan.smb.dcerpc.info.NTService;
import org.alfresco.jlan.smb.dcerpc.info.ServiceStatusInfo;

public class ServiceStatusExInfo
extends ServiceStatusInfo {
    private int m_pid;
    private int m_svcFlags;

    public ServiceStatusExInfo() {
    }

    public ServiceStatusExInfo(String name, String dispname) {
        super(name, dispname);
    }

    public ServiceStatusExInfo(String name, String dispname, int typ, int state, int ctrl, int win32code, int srvexit, int chkpoint, int waithint, int pid, int svcFlags) {
        super(name, dispname, typ, state, ctrl, win32code, srvexit, chkpoint, waithint);
        this.m_pid = pid;
        this.m_svcFlags = svcFlags;
    }

    public final int getProcessId() {
        return this.m_pid;
    }

    public final int getServiceFlags() {
        return this.m_svcFlags;
    }

    @Override
    public void readObject(DCEBuffer buf) throws DCEBufferException {
        super.readObject(buf);
        this.m_pid = buf.getInt();
        this.m_svcFlags = buf.getInt();
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getDisplayName());
        str.append(",");
        str.append(this.getName());
        str.append(",");
        str.append(NTService.getTypeAsString(this.getType()));
        str.append(":");
        str.append(NTService.getStateAsString(this.getCurrentState()));
        str.append(":");
        str.append(NTService.getControlsAcceptedAsString(this.getControlsAccepted()));
        str.append(",PID=");
        str.append(this.getProcessId());
        str.append(",Flags=0x");
        str.append(Integer.toHexString(this.getServiceFlags()));
        str.append("]");
        return str.toString();
    }
}

