/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.nt;

import java.util.Vector;
import org.alfresco.jlan.smb.nt.ACE;
import org.alfresco.jlan.smb.nt.LoadException;
import org.alfresco.jlan.smb.nt.SaveException;
import org.alfresco.jlan.util.DataBuffer;
import org.alfresco.jlan.util.DataPacker;

public class ACL {
    private Vector<ACE> m_aceList;
    private int m_revision = 2;

    public ACL() {
    }

    public ACL(ACE ace) {
        this.addACE(ace);
    }

    public final int getRevision() {
        return this.m_revision;
    }

    public final int numberOfEntries() {
        return this.m_aceList == null ? 0 : this.m_aceList.size();
    }

    public final void addACE(ACE ace) {
        if (this.m_aceList == null) {
            this.m_aceList = new Vector();
        }
        this.m_aceList.addElement(ace);
    }

    public final ACE getACE(int idx) {
        if (this.m_aceList == null || idx >= this.m_aceList.size()) {
            return null;
        }
        return this.m_aceList.elementAt(idx);
    }

    public final void deleteACE(ACE ace) {
        if (this.m_aceList != null) {
            this.m_aceList.removeElement(ace);
        }
    }

    public final void deleteACE(int idx) {
        if (this.m_aceList != null && this.m_aceList.size() > idx && idx >= 0) {
            this.m_aceList.removeElementAt(idx);
        }
    }

    public final void deleteAllACEs() {
        if (this.m_aceList != null) {
            this.m_aceList.removeAllElements();
            this.m_aceList = null;
        }
    }

    public final int loadACL(byte[] buf, int off) throws LoadException {
        this.m_revision = DataPacker.getIntelShort(buf, off);
        int siz = DataPacker.getIntelShort(buf, off + 2);
        int aceCnt = DataPacker.getIntelInt(buf, off + 4);
        if (aceCnt == 0) {
            this.m_aceList = null;
            return off + siz;
        }
        if (this.m_aceList != null) {
            this.m_aceList.removeAllElements();
        } else {
            this.m_aceList = new Vector();
        }
        int acePos = off + 8;
        for (int i = 0; i < aceCnt; ++i) {
            ACE curAce = new ACE();
            acePos = curAce.loadACE(buf, acePos);
            this.addACE(curAce);
        }
        return acePos;
    }

    public final int loadACL(DataBuffer buf) throws LoadException {
        int startPos = buf.getPosition();
        this.m_revision = buf.getShort();
        int siz = buf.getShort();
        int aceCnt = buf.getShort();
        if (aceCnt == 0) {
            this.m_aceList = null;
            return startPos + siz;
        }
        if (this.m_aceList != null) {
            this.m_aceList.removeAllElements();
        } else {
            this.m_aceList = new Vector();
        }
        buf.setPosition(startPos + 8);
        for (int i = 0; i < aceCnt; ++i) {
            ACE curAce = new ACE();
            curAce.loadACE(buf);
            this.addACE(curAce);
        }
        return buf.getPosition();
    }

    public final int saveACL(byte[] buf, int off) throws SaveException {
        int startPos = off;
        DataPacker.putIntelShort(this.m_revision, buf, off);
        DataPacker.putIntelInt(this.m_aceList != null ? this.m_aceList.size() : 0, buf, off + 4);
        int endPos = off + 8;
        if (this.m_aceList != null && this.m_aceList.size() > 0) {
            for (int i = 0; i < this.m_aceList.size(); ++i) {
                ACE curAce = this.getACE(i);
                endPos = curAce.saveACE(buf, endPos);
            }
        }
        DataPacker.putIntelShort(endPos - startPos, buf, off + 2);
        return endPos;
    }

    public final int saveACL(DataBuffer buf) throws SaveException {
        int startPos = buf.getPosition();
        buf.putShort(this.m_revision);
        buf.putShort(0);
        buf.putInt(this.m_aceList != null ? this.m_aceList.size() : 0);
        if (this.m_aceList != null && this.m_aceList.size() > 0) {
            for (int i = 0; i < this.m_aceList.size(); ++i) {
                ACE curAce = this.getACE(i);
                curAce.saveACE(buf);
            }
        }
        int endPos = buf.getPosition();
        buf.setPosition(startPos + 2);
        buf.putShort(endPos - startPos);
        buf.setPosition(endPos);
        return endPos;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.numberOfEntries());
        str.append(":");
        for (int i = 0; i < this.numberOfEntries(); ++i) {
            ACE curAce = this.getACE(i);
            str.append(curAce.toString());
            str.append(",");
        }
        return str.toString();
    }
}

