/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server.nio.win32;

import java.io.IOException;
import org.alfresco.jlan.netbios.NetBIOSName;
import org.alfresco.jlan.netbios.win32.NetBIOSSocket;
import org.alfresco.jlan.netbios.win32.Win32NetBIOS;
import org.alfresco.jlan.server.NetworkServer;
import org.alfresco.jlan.server.SessionHandlerBase;
import org.alfresco.jlan.smb.server.PacketHandler;
import org.alfresco.jlan.smb.server.SMBServer;
import org.alfresco.jlan.smb.server.win32.WinsockNetBIOSPacketHandler;

public class AsyncWinsockNetBIOSSessionHandler
extends SessionHandlerBase {
    private int m_lana;
    private NetBIOSName m_nbName;
    private NetBIOSSocket m_socket;
    private SMBServer m_smbServer;

    public AsyncWinsockNetBIOSSessionHandler(int lana, NetBIOSName nbName, NetworkServer server) {
        super("Winsock NetBIOS", "SMB", server, null, 139);
        this.m_lana = lana;
        this.m_nbName = nbName;
    }

    public final int getLANA() {
        return this.m_lana;
    }

    public final NetBIOSSocket getSocket() {
        return this.m_socket;
    }

    public final SMBServer getSMBServer() {
        return this.m_smbServer;
    }

    public final NetBIOSName getNetBIOSName() {
        return this.m_nbName;
    }

    @Override
    public void initializeSessionHandler(NetworkServer server) throws IOException {
        this.m_smbServer = (SMBServer)server;
        int[] lanas = Win32NetBIOS.LanaEnumerate();
        if (lanas.length > 0) {
            if (this.m_lana == -1) {
                this.m_lana = lanas[0];
            } else {
                boolean lanaOnline = false;
                int idx = 0;
                while (idx < lanas.length && !lanaOnline) {
                    if (lanas[idx++] != this.getLANA()) continue;
                    lanaOnline = true;
                }
                if (!lanaOnline) {
                    throw new IOException("LANA " + this.getLANA() + " is not online");
                }
            }
        } else if (this.m_lana == -1) {
            throw new IOException("No Win32 NetBIOS LANAs available");
        }
        this.m_socket = NetBIOSSocket.createListenerSocket(this.getLANA(), this.m_nbName);
    }

    public PacketHandler createPacketHandler(NetBIOSSocket clientSock) throws IOException {
        return new WinsockNetBIOSPacketHandler(this.m_lana, clientSock, this.getSMBServer().getPacketPool(), true);
    }

    private final boolean isLANAOnline(int lana) {
        int[] lanas = Win32NetBIOS.LanaEnumerate();
        if (lanas != null && lanas.length > 0) {
            for (int i = 0; i < lanas.length; ++i) {
                if (lanas[i] != lana) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void closeSessionHandler(NetworkServer server) {
        if (this.m_socket != null) {
            this.m_socket.closeSocket();
            this.m_socket = null;
        }
    }
}

