/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server.notify;

import org.alfresco.jlan.server.filesys.NotifyChange;

public class NotifyChangeEvent {
    private int m_action;
    private int m_filter;
    private String m_fileName;
    private boolean m_dir;
    private String m_oldName;

    public NotifyChangeEvent(int filter, int action, String fname, boolean dir) {
        this.m_filter = filter;
        this.m_action = action;
        this.m_fileName = fname;
        this.m_dir = dir;
        if (this.m_fileName.indexOf(47) != -1) {
            this.m_fileName = this.m_fileName.replace('/', '\\');
        }
    }

    public NotifyChangeEvent(int filter, int action, String fname, String oldname, boolean dir) {
        this.m_filter = filter;
        this.m_action = action;
        this.m_fileName = fname;
        this.m_oldName = oldname;
        this.m_dir = dir;
        if (this.m_fileName.indexOf(47) != -1) {
            this.m_fileName = this.m_fileName.replace('/', '\\');
        }
        if (this.m_oldName.indexOf(47) != -1) {
            this.m_oldName.replace('/', '\\');
        }
    }

    public final int getFilter() {
        return this.m_filter;
    }

    public final int getAction() {
        return this.m_action;
    }

    public final String getFileName() {
        return this.m_fileName;
    }

    public final String getShortFileName() {
        int pos = this.m_fileName.lastIndexOf("\\");
        if (pos != -1) {
            return this.m_fileName.substring(pos + 1);
        }
        return this.m_fileName;
    }

    public final String getOldFileName() {
        return this.m_oldName;
    }

    public final String getShortOldFileName() {
        if (this.m_oldName == null) {
            return null;
        }
        int pos = this.m_oldName.lastIndexOf("\\");
        if (pos != -1) {
            return this.m_oldName.substring(pos + 1);
        }
        return this.m_oldName;
    }

    public final boolean hasOldFileName() {
        return this.m_oldName != null;
    }

    public final boolean isDirectory() {
        return this.m_dir;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(NotifyChange.getFilterAsString(this.getFilter()));
        str.append("-");
        str.append(NotifyChange.getActionAsString(this.getAction()));
        str.append(":");
        str.append(this.getFileName());
        if (this.isDirectory()) {
            str.append(",DIR");
        }
        if (this.hasOldFileName()) {
            str.append(",Old=");
            str.append(this.getOldFileName());
        }
        str.append("]");
        return str.toString();
    }
}

