/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.StringWriter;
import org.alfresco.jlan.client.CIFSDiskSession;
import org.alfresco.jlan.client.CIFSFile;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.client.info.FileInfo;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.ExceptionTestResult;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestResult;

public class ByteRangeLockingTest
extends Test {
    private static final long TestFileSize = 1024L;

    public ByteRangeLockingTest() {
        super("ByteRangeLocking");
    }

    @Override
    public boolean runInit(int threadId, int curIter, DiskSession sess) {
        boolean initOK;
        block6: {
            initOK = false;
            if (threadId == 1) {
                try {
                    CIFSDiskSession cifsSess;
                    CIFSFile testFile;
                    String testFileName = this.getPerTestFileName(threadId, curIter);
                    if (this.isVerbose()) {
                        Debug.println("Creating file " + testFileName + " via " + sess.getServer());
                    }
                    if ((testFile = (cifsSess = (CIFSDiskSession)sess).NTCreate(testFileName, 3, 128, 7, 5, 0L, 0)) == null) break block6;
                    cifsSess.NTSetEndOfFile(testFile.getFileId(), 1024L);
                    testFile.Close();
                    FileInfo fInfo = cifsSess.getFileInformation(testFileName);
                    if (fInfo.getSize() < 1024L) {
                        Debug.println("Test file " + testFileName + " not required size, actual=" + fInfo.getSize());
                        break block6;
                    }
                    initOK = true;
                }
                catch (Exception ex) {
                    Debug.println(ex);
                }
            } else {
                initOK = true;
            }
        }
        return initOK;
    }

    @Override
    public TestResult runTest(int threadId, int iteration, DiskSession sess, StringWriter log) {
        TestResult result = null;
        try {
            String testFileName = this.getPerTestFileName(threadId, iteration);
            this.testLog(log, "ByteRangeLocking Test");
            this.testLog(log, "Opening file " + testFileName + " via " + sess.getServer());
            CIFSDiskSession cifsSess = (CIFSDiskSession)sess;
            CIFSFile lockFile = null;
            try {
                cifsSess.setProcessId(threadId);
                lockFile = cifsSess.NTCreate(testFileName, 3, 128, 3, 1, 0L, 0);
                long lockPos = 0L;
                long lockLen = 100L;
                for (int idx = 0; idx < 10; ++idx) {
                    boolean isLocked = false;
                    try {
                        lockFile.Lock(lockPos, lockLen);
                        isLocked = true;
                        this.testLog(log, "Locked pos=" + lockPos + ", len=" + lockLen);
                    }
                    catch (SMBException ex) {
                        if (ex.getErrorClass() == 6 && ex.getErrorCode() == -1073741740 || ex.getErrorClass() == 1 && ex.getErrorCode() == 33) {
                            this.testLog(log, "Lock failed with lock conflict error (expected), " + testFileName);
                            result = new BooleanTestResult(true, "Lock conflict error");
                        } else {
                            this.testLog(log, "Failed to lock file " + testFileName + ", pos=" + lockPos + ", len=" + lockLen + ", ex=" + ex);
                            result = new ExceptionTestResult(ex);
                        }
                    }
                    catch (Exception ex) {
                        this.testLog(log, "Failed to lock file " + testFileName + ", pos=" + lockPos + ", len=" + lockLen + ", ex=" + ex);
                        result = new ExceptionTestResult(ex);
                    }
                    if (isLocked) {
                        try {
                            lockFile.Unlock(lockPos, lockLen);
                            this.testLog(log, "Unlocked pos=" + lockPos + ", len=" + lockLen);
                        }
                        catch (Exception ex) {
                            this.testLog(log, "Failed to unlock file " + testFileName + ", pos=" + lockPos + ", len=" + lockLen + ", ex=" + ex);
                            result = new ExceptionTestResult(ex);
                        }
                    } else {
                        this.testSleep(3L);
                    }
                    lockPos += lockLen;
                }
                if (lockFile != null) {
                    lockFile.Close();
                }
                if (result == null) {
                    result = new BooleanTestResult(true);
                }
            }
            catch (Exception ex) {
                this.testLog(log, "Failed to open test file " + testFileName + ", ex=" + ex);
                result = new ExceptionTestResult(ex);
            }
            this.testLog(log, "Test completed");
        }
        catch (Exception ex) {
            Debug.println(ex);
            result = new ExceptionTestResult(ex);
        }
        return result;
    }

    @Override
    public void cleanupTest(int threadId, int iter, DiskSession sess, StringWriter log) throws Exception {
        if (threadId == 1) {
            sess.DeleteFile(this.getPerTestFileName(threadId, iter));
        }
    }
}

