/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.alfresco.jlan.debug.DebugConfigSection;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestServer;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.element.GenericConfigElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestConfiguration {
    private static final int ELEMENT_TYPE = 1;
    public static final int MaximumThreadsPerServer = 25;
    private static final String[][] _testClasses = new String[][]{{"createFile", "org.alfresco.jlan.test.cluster.CreateFileTest"}, {"createFolder", "org.alfresco.jlan.test.cluster.CreateFolderTest"}, {"oplockGrant", "org.alfresco.jlan.test.cluster.OplockGrantTest"}, {"oplockBreak", "org.alfresco.jlan.test.cluster.OplockBreakTest"}, {"deleteFile", "org.alfresco.jlan.test.cluster.DeleteFileTest"}, {"deleteFolder", "org.alfresco.jlan.test.cluster.DeleteFolderTest"}, {"openFile", "org.alfresco.jlan.test.cluster.OpenFileTest"}, {"openFileSharedRead", "org.alfresco.jlan.test.cluster.OpenFileShareReadTest"}, {"byteRangeLocking", "org.alfresco.jlan.test.cluster.ByteRangeLockingTest"}, {"renameFile", "org.alfresco.jlan.test.cluster.RenameFileTest"}, {"renameFolder", "org.alfresco.jlan.test.cluster.RenameFolderTest"}, {"writeFileSequential", "org.alfresco.jlan.test.cluster.WriteSequentialTest"}, {"writeFileRandom", "org.alfresco.jlan.test.cluster.WriteRandomTest"}, {"folderSearch", "org.alfresco.jlan.test.cluster.FolderSearchTest"}, {"changeNotify", "org.alfresco.jlan.test.cluster.ChangeNotifyTest"}, {"NTCreateFile", "org.alfresco.jlan.test.cluster.NTCreateFileTest"}, {"perfFilesPerFolder", "org.alfresco.jlan.test.cluster.PerfFilesPerFolderTest"}, {"perfFolderTree", "org.alfresco.jlan.test.cluster.PerfFolderTreeTest"}, {"perfDataTransfer", "org.alfresco.jlan.test.cluster.PerfDataTransferTest"}, {"oplockLeak", "org.alfresco.jlan.test.cluster.OplockLeakTest"}, {"oplockLevelII", "org.alfresco.jlan.test.cluster.OplockBreakLevelIITest"}, {"attributesOnlyOplock", "org.alfresco.jlan.test.cluster.AttributesOnlyOplockGrantTest"}};
    private List<TestServer> m_serverList;
    private List<Test> m_testList;
    private boolean m_runInterleaved;
    private int m_threadsPerServer = 1;
    private DebugConfigSection m_debugConfig;

    public List<TestServer> getServerList() {
        return this.m_serverList;
    }

    public List<Test> getTestList() {
        return this.m_testList;
    }

    public final boolean runInterleaved() {
        return this.m_runInterleaved;
    }

    public final int getThreadsPerServer() {
        return this.m_threadsPerServer;
    }

    public final void loadConfiguration(String fname) throws IOException, InvalidConfigurationException {
        FileInputStream inFile = new FileInputStream(fname);
        InputStreamReader inRead = new InputStreamReader(inFile);
        this.loadConfiguration(inRead);
    }

    public final void loadConfiguration(Reader in) throws IOException, InvalidConfigurationException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource xmlSource = new InputSource(in);
            Document doc = builder.parse(xmlSource);
            this.loadConfiguration(doc);
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("XML error", ex);
        }
        finally {
            in.close();
        }
    }

    public void loadConfiguration(Document doc) throws IOException, InvalidConfigurationException {
        try {
            Element root = doc.getDocumentElement();
            NodeList childNodes = root.getChildNodes();
            this.procServerList((ConfigElement)this.buildConfigElement(this.findChildNode("servers", childNodes)));
            this.procTestList((ConfigElement)this.buildConfigElement(this.findChildNode("tests", childNodes)));
            this.procRunParameters((ConfigElement)this.buildConfigElement(this.findChildNode("run", childNodes)));
            this.procDebugSetup((ConfigElement)this.buildConfigElement(this.findChildNode("debug", childNodes)));
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("XML error", ex);
        }
    }

    protected final void procServerList(ConfigElement servers) throws InvalidConfigurationException {
        if (servers == null) {
            throw new InvalidConfigurationException("Server list must be specified");
        }
        this.m_serverList = new ArrayList<TestServer>();
        ConfigElement defaultElem = servers.getChild("default");
        TestServer defaultSrv = null;
        if (defaultElem != null) {
            String defUser = defaultElem.getAttribute("username");
            String defPass = defaultElem.getAttribute("password");
            String defShare = defaultElem.getAttribute("share");
            defaultSrv = new TestServer("", defUser, defPass, defShare);
        }
        List srvElemList = servers.getChildren();
        for (int idx = 0; idx < srvElemList.size(); ++idx) {
            ConfigElement curElem = (ConfigElement)srvElemList.get(idx);
            if (!curElem.getName().equals("server")) continue;
            String srvName = curElem.getAttribute("name");
            if (srvName == null || srvName.length() == 0) {
                throw new InvalidConfigurationException("Invalid server, name not specified");
            }
            String srvUser = curElem.getAttribute("username");
            String srvPass = curElem.getAttribute("password");
            String srvShare = curElem.getAttribute("share");
            if (defaultSrv != null) {
                if (srvUser == null) {
                    srvUser = defaultSrv.getUserName();
                }
                if (srvPass == null) {
                    srvPass = defaultSrv.getPassword();
                }
                if (srvShare == null) {
                    srvShare = defaultSrv.getShareName();
                }
            }
            TestServer testSrv = new TestServer(srvName, srvUser, srvPass, srvShare);
            this.m_serverList.add(testSrv);
        }
    }

    protected final void procTestList(ConfigElement tests) throws InvalidConfigurationException {
        if (tests == null) {
            throw new InvalidConfigurationException("Test list must be specified");
        }
        this.m_testList = new ArrayList<Test>();
        ConfigElement defaultElem = tests.getChild("default");
        String defPath = null;
        int defIterations = -1;
        boolean defVerbose = false;
        boolean defCleanup = true;
        if (defaultElem != null) {
            defPath = defaultElem.getAttribute("path");
            String defValue = defaultElem.getAttribute("iterations");
            if (defValue != null) {
                try {
                    defIterations = Integer.parseInt(defValue);
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException("Invalid iterations value");
                }
            }
            if ((defValue = defaultElem.getAttribute("verbose")) != null) {
                defVerbose = Boolean.parseBoolean(defValue);
            }
            if ((defValue = defaultElem.getAttribute("cleanup")) != null) {
                defCleanup = Boolean.parseBoolean(defValue);
            }
        }
        List testElemList = tests.getChildren();
        for (int idx = 0; idx < testElemList.size(); ++idx) {
            String boolStr;
            ConfigElement curElem = (ConfigElement)testElemList.get(idx);
            if (curElem.getName().equals("default")) continue;
            String testName = curElem.getName();
            String testPath = curElem.hasAttribute("path") ? curElem.getAttribute("path") : defPath;
            int testIter = 1;
            boolean testVerbose = false;
            boolean testCleanup = true;
            if (curElem.hasAttribute("iterations")) {
                String iterStr = curElem.getAttribute("iterations");
                try {
                    testIter = Integer.parseInt(iterStr);
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException("Invalid 'iterations' attribute " + iterStr);
                }
            } else if (defIterations != -1) {
                testIter = defIterations;
            }
            if (curElem.hasAttribute("verbose")) {
                boolStr = curElem.getAttribute("verbose");
                testVerbose = Boolean.parseBoolean(boolStr);
            } else {
                testVerbose = defVerbose;
            }
            if (curElem.hasAttribute("cleanup")) {
                boolStr = curElem.getAttribute("cleanup");
                testCleanup = Boolean.parseBoolean(boolStr);
            } else {
                testCleanup = defCleanup;
            }
            Test testClass = this.getTestClass(testName, testPath, testIter, testVerbose);
            if (testClass != null) {
                testClass.setTestCleanup(testCleanup);
                testClass.configTest(curElem);
                this.m_testList.add(testClass);
                continue;
            }
            throw new InvalidConfigurationException("Invalid test name '" + curElem.getName() + "'");
        }
        if (this.m_testList.size() == 0) {
            throw new InvalidConfigurationException("No tests configured");
        }
    }

    protected final void procRunParameters(ConfigElement runParams) throws InvalidConfigurationException {
        String srvThreads;
        ConfigElement elem;
        if (runParams == null) {
            return;
        }
        if (runParams.getChild("interleaved") != null) {
            this.m_runInterleaved = true;
        }
        if ((elem = runParams.getChild("perServer")) != null && (srvThreads = elem.getAttribute("threads")) != null) {
            try {
                this.m_threadsPerServer = Integer.parseInt(srvThreads);
                if (this.m_threadsPerServer < 1 || this.m_threadsPerServer > 25) {
                    throw new InvalidConfigurationException("Invalid threads per server value, " + srvThreads + ", valid range 1-" + 25);
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid threads per server value, " + srvThreads);
            }
        }
    }

    protected final void procDebugSetup(ConfigElement debug) throws InvalidConfigurationException {
        if (debug == null) {
            return;
        }
        this.m_debugConfig = new DebugConfigSection(null);
        ConfigElement elem = debug.getChild("output");
        if (elem == null) {
            throw new InvalidConfigurationException("Output class must be specified to enable debug output");
        }
        ConfigElement debugClass = elem.getChild("class");
        if (debugClass == null) {
            throw new InvalidConfigurationException("Class must be specified for debug output");
        }
        this.m_debugConfig.setDebug(debugClass.getValue(), elem);
    }

    private Test getTestClass(String name, String path, int iter, boolean verbose) {
        Test test = null;
        try {
            String testClass = null;
            int idx = 0;
            while (idx < _testClasses.length && testClass == null) {
                if (_testClasses[idx][0].equalsIgnoreCase(name)) {
                    testClass = _testClasses[idx][1];
                    continue;
                }
                ++idx;
            }
            if (testClass == null) {
                return null;
            }
            Object testClassObj = Class.forName(testClass).newInstance();
            if (testClassObj != null && testClassObj instanceof Test) {
                test = (Test)testClassObj;
                test.setPath(path);
                test.setIterations(iter);
                test.setVerbose(verbose);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return test;
    }

    protected final Element findChildNode(String name, NodeList list) {
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (!child.getNodeName().equals(name) || child.getNodeType() != 1) continue;
            return (Element)child;
        }
        return null;
    }

    protected final String getText(Element elem) {
        NodeList children = elem.getChildNodes();
        String text = "";
        if (children != null && children.getLength() > 0 && children.item(0).getNodeType() != 1) {
            text = children.item(0).getNodeValue();
        }
        return text;
    }

    protected final GenericConfigElement buildConfigElement(Element root) {
        return this.buildConfigElement(root, null);
    }

    protected final GenericConfigElement buildConfigElement(Element root, GenericConfigElement cfgElem) {
        NodeList nodes;
        GenericConfigElement rootElem = cfgElem;
        if (rootElem == null) {
            rootElem = new GenericConfigElement(root.getNodeName());
            NamedNodeMap attribs = root.getAttributes();
            if (attribs != null) {
                for (int i = 0; i < attribs.getLength(); ++i) {
                    Node attribNode = attribs.item(i);
                    rootElem.addAttribute(attribNode.getNodeName(), attribNode.getNodeValue());
                }
            }
        }
        if ((nodes = root.getChildNodes()) == null) {
            return rootElem;
        }
        GenericConfigElement childElem = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element elem = (Element)node;
            NodeList children = elem.getChildNodes();
            if (children != null && children.getLength() > 1) {
                childElem = this.buildConfigElement(elem, null);
            } else {
                if (children.getLength() > 0) {
                    childElem = new GenericConfigElement(elem.getNodeName());
                    childElem.setValue(children.item(0).getNodeValue());
                } else {
                    childElem = new GenericConfigElement(elem.getNodeName());
                }
                NamedNodeMap attribs = elem.getAttributes();
                if (attribs != null) {
                    for (int j = 0; j < attribs.getLength(); ++j) {
                        Node attribNode = attribs.item(j);
                        childElem.addAttribute(attribNode.getNodeName(), attribNode.getNodeValue());
                    }
                }
            }
            rootElem.addChild((ConfigElement)childElem);
        }
        return rootElem;
    }
}

