/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.alfresco.jlan.netbios.NetBIOSName;
import org.alfresco.jlan.netbios.NetBIOSNameList;
import org.alfresco.jlan.netbios.NetBIOSSession;
import org.alfresco.jlan.netbios.win32.Win32NetBIOS;
import org.alfresco.jlan.util.Platform;

public class LocalServer {
    private static String m_localName;
    private static String m_localDomain;

    public static final String getLocalServerName(boolean trimDomain) {
        int pos;
        if (m_localName != null) {
            return m_localName;
        }
        String srvName = null;
        if (Platform.isPlatformType() == Platform.Type.WINDOWS) {
            srvName = Win32NetBIOS.GetLocalNetBIOSName();
        } else {
            try {
                srvName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                // empty catch block
            }
        }
        if (trimDomain && srvName != null && (pos = srvName.indexOf(".")) != -1) {
            srvName = srvName.substring(0, pos);
        }
        m_localName = srvName;
        return srvName;
    }

    public static final String getLocalDomainName() {
        if (m_localDomain != null) {
            return m_localDomain;
        }
        String domainName = null;
        if (Platform.isPlatformType() == Platform.Type.WINDOWS) {
            domainName = Win32NetBIOS.GetLocalDomainName();
        } else {
            NetBIOSName nbName = null;
            try {
                nbName = NetBIOSSession.FindName("\u0001\u0002__MSBROWSE__\u0002", '\u0001', 5000);
                NetBIOSNameList nbNameList = NetBIOSSession.FindNamesForAddress(nbName.getIPAddressString(0));
                if (nbNameList != null && (nbName = nbNameList.findName('\u001d', false)) != null) {
                    domainName = nbName.getName();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        m_localDomain = domainName;
        return domainName;
    }
}

