/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.util;

public class MemorySize {
    public static final long KILOBYTE = 1024L;
    public static final long MEGABYTE = 0x100000L;
    public static final long GIGABYTE = 0x40000000L;
    public static final long TERABYTE = 0x10000000000L;

    public static final int getByteValueInt(String memSize) {
        return (int)(MemorySize.getByteValue(memSize) & 0xFFFFFFFFL);
    }

    public static final long getByteValue(String memSize) {
        if (memSize == null || memSize.length() == 0) {
            return -1L;
        }
        String sizeStr = memSize.toUpperCase();
        long mult = 1L;
        long val = 0L;
        if (sizeStr.endsWith("K")) {
            mult = 1024L;
            val = MemorySize.getValue(sizeStr);
        } else if (sizeStr.endsWith("M")) {
            mult = 0x100000L;
            val = MemorySize.getValue(sizeStr);
        } else if (sizeStr.endsWith("G")) {
            mult = 0x40000000L;
            val = MemorySize.getValue(sizeStr);
        } else if (sizeStr.endsWith("T")) {
            mult = 0x10000000000L;
            val = MemorySize.getValue(sizeStr);
        } else {
            val = Long.valueOf(sizeStr);
        }
        return val * mult;
    }

    private static final long getValue(String val) {
        String sizStr = val.substring(0, val.length() - 1);
        return Long.valueOf(sizStr);
    }

    public static final String asKilobyteString(long val) {
        long mbVal = val / 1024L;
        return "" + mbVal + "Kb";
    }

    public static final String asMegabyteString(long val) {
        long mbVal = val / 0x100000L;
        return "" + mbVal + "Mb";
    }

    public static final String asGigabyteString(long val) {
        long mbVal = val / 0x40000000L;
        return "" + mbVal + "Gb";
    }

    public static final String asTerabyteString(long val) {
        long mbVal = val / 0x10000000000L;
        return "" + mbVal + "Tb";
    }

    public static final String asScaledString(long val) {
        String ret = null;
        ret = val < 2048L ? Long.toString(val) : (val < 0x200000L ? MemorySize.asKilobyteString(val) : (val < 0x80000000L ? MemorySize.asMegabyteString(val) : (val < 0x20000000000L ? MemorySize.asGigabyteString(val) : MemorySize.asTerabyteString(val))));
        return ret;
    }

    public static long roundupLongSize(long lSize) {
        return lSize + 512L & 0xFFFFFFFFFFFFFE00L;
    }

    public static int roundupIntSize(int iSize) {
        return iSize + 512 & 0xFFFFFE00;
    }
}

