/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.docs;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="docs", nsUri="http://schemas.google.com/docs/2007", localName="archiveConversion")
public class ArchiveConversion
extends ExtensionPoint {
    static final String XML_NAME = "archiveConversion";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private String source = null;
    private String target = null;

    public ArchiveConversion() {
    }

    public ArchiveConversion(String source, String target) {
        this.setSource(source);
        this.setTarget(target);
        this.setImmutable(true);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.throwExceptionIfImmutable();
        this.source = source;
    }

    public boolean hasSource() {
        return this.getSource() != null;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.throwExceptionIfImmutable();
        this.target = target;
    }

    public boolean hasTarget() {
        return this.getTarget() != null;
    }

    protected void validate() {
        if (this.source == null) {
            ArchiveConversion.throwExceptionForMissingAttribute((String)SOURCE);
        }
        if (this.target == null) {
            ArchiveConversion.throwExceptionForMissingAttribute((String)TARGET);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(ArchiveConversion.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put((Object)SOURCE, (Object)this.source);
        generator.put((Object)TARGET, (Object)this.target);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.source = helper.consume(SOURCE, true);
        this.target = helper.consume(TARGET, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        ArchiveConversion other = (ArchiveConversion)((Object)obj);
        return ArchiveConversion.eq((Object)this.source, (Object)other.source) && ArchiveConversion.eq((Object)this.target, (Object)other.target);
    }

    public int hashCode() {
        int result = ((Object)((Object)this)).getClass().hashCode();
        if (this.source != null) {
            result = 37 * result + this.source.hashCode();
        }
        if (this.target != null) {
            result = 37 * result + this.target.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{ArchiveConversion source=" + this.source + " target=" + this.target + "}";
    }
}

