/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.docs;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="docs", nsUri="http://schemas.google.com/docs/2007", localName="query")
public class QueryParameter
extends ExtensionPoint {
    static final String XML_NAME = "query";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final AttributeHelper.EnumToAttributeValue<Type> TYPE_ENUM_TO_ATTRIBUTE_VALUE = new AttributeHelper.EnumToAttributeValue<Type>(){

        public String getAttributeValue(Type enumValue) {
            return enumValue.toValue();
        }
    };
    private Type type = null;
    private String value = null;

    public QueryParameter() {
    }

    public QueryParameter(Type type, String value) {
        this.setType(type);
        this.setValue(value);
        this.setImmutable(true);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.throwExceptionIfImmutable();
        this.type = type;
    }

    public boolean hasType() {
        return this.getType() != null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.throwExceptionIfImmutable();
        this.value = value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    protected void validate() {
        if (this.type == null) {
            QueryParameter.throwExceptionForMissingAttribute((String)TYPE);
        }
        if (this.value == null) {
            QueryParameter.throwExceptionForMissingAttribute((String)VALUE);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(QueryParameter.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put(TYPE, (Enum)this.type, TYPE_ENUM_TO_ATTRIBUTE_VALUE);
        generator.put((Object)VALUE, (Object)this.value);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.type = (Type)helper.consumeEnum(TYPE, true, Type.class, null, TYPE_ENUM_TO_ATTRIBUTE_VALUE);
        this.value = helper.consume(VALUE, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        QueryParameter other = (QueryParameter)((Object)obj);
        return QueryParameter.eq((Object)((Object)this.type), (Object)((Object)other.type)) && QueryParameter.eq((Object)this.value, (Object)other.value);
    }

    public int hashCode() {
        int result = ((Object)((Object)this)).getClass().hashCode();
        if (this.type != null) {
            result = 37 * result + this.type.hashCode();
        }
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{QueryParameter type=" + (Object)((Object)this.type) + " value=" + this.value + "}";
    }

    public static enum Type {
        AUTHOR("author"),
        CATEGORY("category"),
        OPENED_MAX("opened-max"),
        OPENED_MIN("opened-min"),
        OWNER("owner"),
        Q("q"),
        READER("reader"),
        TITLE("title"),
        TITLE_EXACT("title-exact"),
        UPDATED_MAX("updated-max"),
        UPDATED_MIN("updated-min"),
        WRITER("writer");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String toValue() {
            return this.value;
        }
    }
}

