/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.docs;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.docs.DocumentListEntry;
import com.google.gdata.data.spreadsheet.WorksheetEntry;
import com.google.gdata.data.spreadsheet.WorksheetFeed;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

@Kind.Term(value="http://schemas.google.com/docs/2007#spreadsheet")
public class SpreadsheetEntry
extends DocumentListEntry {
    public static final String LABEL = "spreadsheet";
    public static final String KIND = "http://schemas.google.com/docs/2007#spreadsheet";
    public static final Category CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/docs/2007#spreadsheet", "spreadsheet");

    public SpreadsheetEntry() {
        this.getCategories().remove(DocumentListEntry.CATEGORY);
        this.getCategories().add(CATEGORY);
    }

    public SpreadsheetEntry(BaseEntry sourceEntry) {
        super(sourceEntry);
    }

    public URL getWorksheetFeedUrl() {
        Link feedLink = this.getLink("http://schemas.google.com/spreadsheets/2006#worksheetsfeed", ILink.Type.ATOM);
        try {
            return new URL(feedLink.getHref());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error in GData server", e);
        }
    }

    public List<WorksheetEntry> getWorksheets() throws IOException, ServiceException {
        WorksheetFeed feed = (WorksheetFeed)this.state.service.getFeed(this.getWorksheetFeedUrl(), WorksheetFeed.class);
        return feed.getEntries();
    }

    public WorksheetEntry getDefaultWorksheet() throws IOException, ServiceException {
        Link feedLink = this.getLink("http://schemas.google.com/spreadsheets/2006#worksheetsfeed", ILink.Type.ATOM);
        String url = feedLink.getHref() + "/default";
        return (WorksheetEntry)this.state.service.getEntry(new URL(url), WorksheetEntry.class);
    }
}

