/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.util.BridgeTable;
import org.alfresco.util.Pair;
import org.junit.Test;

public class BridgeTableTest
extends TestCase {
    @Test
    public void testBasic() {
        BridgeTable<String> bridgeTable = new BridgeTable<String>();
        bridgeTable.addLink("A", "B");
        bridgeTable.addLink("C", "D");
        bridgeTable.addLink("E", "F");
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getAncestors("A").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getAncestors("B").size());
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getAncestors("C").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getAncestors("D").size());
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getAncestors("E").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getAncestors("F").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getDescendants("A").size());
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getDescendants("B").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getDescendants("C").size());
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getDescendants("D").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getDescendants("E").size());
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getDescendants("F").size());
        bridgeTable.addLink("B", "C");
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getAncestors("A").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getAncestors("B").size());
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getAncestors("C").size());
        BridgeTableTest.assertEquals((int)3, (int)bridgeTable.getAncestors("D").size());
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getAncestors("E").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getAncestors("F").size());
        BridgeTableTest.assertEquals((int)3, (int)bridgeTable.getDescendants("A").size());
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getDescendants("B").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getDescendants("C").size());
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getDescendants("D").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getDescendants("E").size());
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getDescendants("F").size());
        bridgeTable.addLink("D", "E");
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getAncestors("A").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getAncestors("B").size());
        BridgeTableTest.assertTrue((boolean)bridgeTable.getAncestors("B", 1).contains("A"));
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getAncestors("C").size());
        BridgeTableTest.assertTrue((boolean)bridgeTable.getAncestors("C", 1).contains("B"));
        BridgeTableTest.assertTrue((boolean)bridgeTable.getAncestors("C", 2).contains("A"));
        BridgeTableTest.assertEquals((int)3, (int)bridgeTable.getAncestors("D").size());
        BridgeTableTest.assertTrue((boolean)bridgeTable.getAncestors("D", 1).contains("C"));
        BridgeTableTest.assertTrue((boolean)bridgeTable.getAncestors("D", 2).contains("B"));
        BridgeTableTest.assertTrue((boolean)bridgeTable.getAncestors("D", 3).contains("A"));
        BridgeTableTest.assertEquals((int)4, (int)bridgeTable.getAncestors("E").size());
        BridgeTableTest.assertTrue((boolean)bridgeTable.getAncestors("E", 1).contains("D"));
        BridgeTableTest.assertTrue((boolean)bridgeTable.getAncestors("E", 2).contains("C"));
        BridgeTableTest.assertTrue((boolean)bridgeTable.getAncestors("E", 3).contains("B"));
        BridgeTableTest.assertTrue((boolean)bridgeTable.getAncestors("E", 4).contains("A"));
        BridgeTableTest.assertEquals((int)5, (int)bridgeTable.getAncestors("F").size());
        BridgeTableTest.assertTrue((boolean)bridgeTable.getAncestors("F", 1).contains("E"));
        BridgeTableTest.assertTrue((boolean)bridgeTable.getAncestors("F", 2).contains("D"));
        BridgeTableTest.assertTrue((boolean)bridgeTable.getAncestors("F", 3).contains("C"));
        BridgeTableTest.assertTrue((boolean)bridgeTable.getAncestors("F", 4).contains("B"));
        BridgeTableTest.assertTrue((boolean)bridgeTable.getAncestors("F", 5).contains("A"));
        BridgeTableTest.assertEquals((int)5, (int)bridgeTable.getDescendants("A").size());
        BridgeTableTest.assertTrue((boolean)bridgeTable.getDescendants("A", 1).contains("B"));
        BridgeTableTest.assertTrue((boolean)bridgeTable.getDescendants("A", 2).contains("C"));
        BridgeTableTest.assertTrue((boolean)bridgeTable.getDescendants("A", 3).contains("D"));
        BridgeTableTest.assertTrue((boolean)bridgeTable.getDescendants("A", 4).contains("E"));
        BridgeTableTest.assertTrue((boolean)bridgeTable.getDescendants("A", 5).contains("F"));
        BridgeTableTest.assertEquals((int)4, (int)bridgeTable.getDescendants("B").size());
        BridgeTableTest.assertTrue((boolean)bridgeTable.getDescendants("B", 1).contains("C"));
        BridgeTableTest.assertTrue((boolean)bridgeTable.getDescendants("B", 2).contains("D"));
        BridgeTableTest.assertTrue((boolean)bridgeTable.getDescendants("B", 3).contains("E"));
        BridgeTableTest.assertTrue((boolean)bridgeTable.getDescendants("B", 4).contains("F"));
        BridgeTableTest.assertEquals((int)3, (int)bridgeTable.getDescendants("C").size());
        BridgeTableTest.assertTrue((boolean)bridgeTable.getDescendants("C", 1).contains("D"));
        BridgeTableTest.assertTrue((boolean)bridgeTable.getDescendants("C", 2).contains("E"));
        BridgeTableTest.assertTrue((boolean)bridgeTable.getDescendants("C", 3).contains("F"));
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getDescendants("D").size());
        BridgeTableTest.assertTrue((boolean)bridgeTable.getDescendants("D", 1).contains("E"));
        BridgeTableTest.assertTrue((boolean)bridgeTable.getDescendants("D", 2).contains("F"));
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getDescendants("E").size());
        BridgeTableTest.assertTrue((boolean)bridgeTable.getDescendants("E", 1).contains("F"));
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getDescendants("F").size());
        bridgeTable.removeLink("D", "E");
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getAncestors("A").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getAncestors("B").size());
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getAncestors("C").size());
        BridgeTableTest.assertEquals((int)3, (int)bridgeTable.getAncestors("D").size());
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getAncestors("E").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getAncestors("F").size());
        BridgeTableTest.assertEquals((int)3, (int)bridgeTable.getDescendants("A").size());
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getDescendants("B").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getDescendants("C").size());
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getDescendants("D").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getDescendants("E").size());
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getDescendants("F").size());
        bridgeTable.removeLink("B", "C");
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getAncestors("A").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getAncestors("B").size());
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getAncestors("C").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getAncestors("D").size());
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getAncestors("E").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getAncestors("F").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getDescendants("A").size());
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getDescendants("B").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getDescendants("C").size());
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getDescendants("D").size());
        BridgeTableTest.assertEquals((int)1, (int)bridgeTable.getDescendants("E").size());
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getDescendants("F").size());
    }

    @Test
    public void test_16k() {
        for (int i = 0; i < 15; ++i) {
            BridgeTable bridgeTable = new BridgeTable();
            long start = System.nanoTime();
            bridgeTable.addLinks(this.getTreeLinks(i));
            long end = System.nanoTime();
            double elapsed = (double)(end - start) / 1.0E9;
            System.out.println("" + bridgeTable.size() + " in " + elapsed);
            BridgeTableTest.assertTrue((elapsed < 60.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void test_100x100() {
        BridgeTable bridgeTable = new BridgeTable();
        HashSet links = new HashSet();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                links.addAll(this.getTreeLinks(7));
            }
            long start = System.nanoTime();
            bridgeTable.addLinks(links);
            long end = System.nanoTime();
            System.out.println("Trees " + bridgeTable.size() + " in " + (double)(end - start) / 1.0E9);
            start = System.nanoTime();
            for (String key : bridgeTable.keySet()) {
                bridgeTable.getAncestors(key);
            }
            end = System.nanoTime();
            System.out.println("By key " + bridgeTable.size() + " in " + (double)(end - start) / 1.0E9);
        }
    }

    @Test
    public void testSecondary() {
        BridgeTable<String> bridgeTable = new BridgeTable<String>();
        bridgeTable.addLink("A", "B");
        bridgeTable.addLink("A", "C");
        bridgeTable.addLink("B", "D");
        bridgeTable.addLink("B", "E");
        bridgeTable.addLink("C", "F");
        bridgeTable.addLink("C", "G");
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getDescendants("A", 1).size());
        BridgeTableTest.assertEquals((int)4, (int)bridgeTable.getDescendants("A", 2).size());
        BridgeTableTest.assertEquals((int)6, (int)bridgeTable.getDescendants("A", 1, 2).size());
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getDescendants("B", 1).size());
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getDescendants("B", 2).size());
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getDescendants("B", 1, 2).size());
        bridgeTable.addLink("N", "O");
        bridgeTable.addLink("N", "P");
        bridgeTable.addLink("O", "Q");
        bridgeTable.addLink("O", "R");
        bridgeTable.addLink("P", "S");
        bridgeTable.addLink("P", "T");
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getDescendants("N", 1).size());
        BridgeTableTest.assertEquals((int)4, (int)bridgeTable.getDescendants("N", 2).size());
        BridgeTableTest.assertEquals((int)6, (int)bridgeTable.getDescendants("N", 1, 2).size());
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getDescendants("O", 1).size());
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getDescendants("O", 2).size());
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getDescendants("O", 1, 2).size());
        bridgeTable.addLink("A", "N");
        BridgeTableTest.assertEquals((int)3, (int)bridgeTable.getDescendants("A", 1).size());
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getDescendants("B", 1).size());
        bridgeTable.addLink("A", "N");
        BridgeTableTest.assertEquals((int)3, (int)bridgeTable.getDescendants("A", 1).size());
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getDescendants("B", 1).size());
        bridgeTable.addLink("B", "N");
        BridgeTableTest.assertEquals((int)3, (int)bridgeTable.getDescendants("A", 1).size());
        BridgeTableTest.assertEquals((int)3, (int)bridgeTable.getDescendants("B", 1).size());
        bridgeTable.addLink("B", "N");
        BridgeTableTest.assertEquals((int)3, (int)bridgeTable.getDescendants("A", 1).size());
        BridgeTableTest.assertEquals((int)3, (int)bridgeTable.getDescendants("B", 1).size());
        bridgeTable.removeLink("A", "N");
        BridgeTableTest.assertEquals((int)3, (int)bridgeTable.getDescendants("A", 1).size());
        BridgeTableTest.assertEquals((int)3, (int)bridgeTable.getDescendants("B", 1).size());
        bridgeTable.removeLink("A", "N");
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getDescendants("A", 1).size());
        BridgeTableTest.assertEquals((int)3, (int)bridgeTable.getDescendants("B", 1).size());
        bridgeTable.removeLink("B", "N");
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getDescendants("A", 1).size());
        BridgeTableTest.assertEquals((int)3, (int)bridgeTable.getDescendants("B", 1).size());
        bridgeTable.removeLink("B", "N");
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getDescendants("A", 1).size());
        BridgeTableTest.assertEquals((int)4, (int)bridgeTable.getDescendants("A", 2).size());
        BridgeTableTest.assertEquals((int)6, (int)bridgeTable.getDescendants("A", 1, 2).size());
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getDescendants("B", 1).size());
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getDescendants("B", 2).size());
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getDescendants("B", 1, 2).size());
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getDescendants("N", 1).size());
        BridgeTableTest.assertEquals((int)4, (int)bridgeTable.getDescendants("N", 2).size());
        BridgeTableTest.assertEquals((int)6, (int)bridgeTable.getDescendants("N", 1, 2).size());
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getDescendants("O", 1).size());
        BridgeTableTest.assertEquals((int)0, (int)bridgeTable.getDescendants("O", 2).size());
        BridgeTableTest.assertEquals((int)2, (int)bridgeTable.getDescendants("O", 1, 2).size());
    }

    private Set<Pair<String, String>> getTreeLinks(int depth) {
        int count = 0;
        String base = "" + System.nanoTime();
        HashSet<String> currentRow = new HashSet<String>();
        HashSet lastRow = new HashSet();
        HashSet<Pair<String, String>> links = new HashSet<Pair<String, String>>();
        for (int i = 0; i < depth; ++i) {
            if (lastRow.size() == 0) {
                currentRow.add("GROUP_" + base + "_" + count);
                ++count;
            } else {
                for (String group : lastRow) {
                    String newGroup = "GROUP_" + base + "_" + count;
                    currentRow.add(newGroup);
                    links.add(new Pair<String, String>(group, newGroup));
                    newGroup = "GROUP_" + base + "_" + ++count;
                    currentRow.add(newGroup);
                    ++count;
                    links.add(new Pair<String, String>(group, newGroup));
                }
            }
            lastRow = currentRow;
            currentRow = new HashSet();
        }
        return links;
    }
}

