/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.alfresco.util.OneToManyBiMap;
import org.alfresco.util.OneToManyHashMap;

public class OneToManyHashBiMap<K, V>
implements Map<K, Set<V>>,
OneToManyBiMap<K, V> {
    private OneToManyHashMap<K, V> map = new OneToManyHashMap();
    private Map<V, K> inverse = new HashMap<V, K>();

    @Override
    public void clear() {
        this.map.clear();
        this.inverse.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public boolean containsSingleValue(V value) {
        return this.inverse.containsKey(value);
    }

    @Override
    public Set<Map.Entry<K, Set<V>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entries() {
        return this.map.entries();
    }

    @Override
    public Set<V> get(Object key) {
        return this.map.get(key);
    }

    @Override
    public K getKey(V value) {
        return this.inverse.get(value);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<V> put(K key, Set<V> values) {
        this.map.put(key, values);
        for (V value : values) {
            this.inverse.put(value, key);
        }
        return null;
    }

    @Override
    public V putSingleValue(K key, V value) {
        this.inverse.put(value, key);
        return this.map.putSingleValue(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Set<V>> m) {
        this.map.putAll((Map<? extends K, Set<V>>)m);
        for (Map.Entry<K, Set<V>> entry : m.entrySet()) {
            K key = entry.getKey();
            for (V value : entry.getValue()) {
                this.inverse.put(value, key);
            }
        }
    }

    @Override
    public void putAllSingleValues(Map<? extends K, ? extends V> m) {
        this.map.putAllSingleValues(m);
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.inverse.put(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public Set<V> remove(Object key) {
        Object values = this.map.remove(key);
        Iterator i$ = values.iterator();
        while (i$.hasNext()) {
            Object value = i$.next();
            this.inverse.remove(value);
        }
        return values;
    }

    @Override
    public K removeValue(V value) {
        K key = this.inverse.remove(value);
        Object values = this.map.get(key);
        values.remove(value);
        if (values.size() == 0) {
            this.map.remove(key);
        }
        return key;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Set<V>> values() {
        return this.map.values();
    }

    @Override
    public Collection<V> flatValues() {
        return Collections.unmodifiableCollection(this.inverse.keySet());
    }
}

