/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Container;
import org.springframework.extensions.webscripts.DefaultURLModel;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.RuntimeContainer;
import org.springframework.extensions.webscripts.ScriptParameterFactory;
import org.springframework.extensions.webscripts.ScriptParameterFactoryRegistry;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.StatusTemplate;
import org.springframework.extensions.webscripts.TemplateProcessor;
import org.springframework.extensions.webscripts.URLModel;
import org.springframework.extensions.webscripts.URLModelFactory;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.WebScriptSession;
import org.springframework.extensions.webscripts.WebScriptSessionFactory;
import org.springframework.extensions.webscripts.WrappingWebScriptRequest;
import org.springframework.extensions.webscripts.WrappingWebScriptResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRuntime
implements Runtime {
    protected static final Log logger = LogFactory.getLog(AbstractRuntime.class);
    protected RuntimeContainer container;
    protected WebScriptSession session;
    private URLModelFactory urlModelFactory = null;

    public AbstractRuntime(RuntimeContainer container) {
        this.container = container;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public WebScriptSession getSession() {
        if (this.session == null) {
            this.session = new RuntimeSession(this.createSessionFactory());
        }
        return this.session;
    }

    public void setURLModelFactory(URLModelFactory urlModelFactory) {
        this.urlModelFactory = urlModelFactory;
    }

    private URLModel createURLModel(WebScriptRequest request) {
        URLModel urlModel = null;
        urlModel = this.urlModelFactory == null ? new DefaultURLModel(request) : this.urlModelFactory.createURLModel(request);
        return urlModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeScript() {
        block41: {
            boolean debug = logger.isDebugEnabled();
            long startRuntime = 0L;
            if (debug) {
                startRuntime = System.nanoTime();
            }
            String method = this.getScriptMethod();
            String scriptUrl = null;
            Match match = null;
            try {
                scriptUrl = this.getScriptUrl();
                if (scriptUrl == null || scriptUrl.length() == 0) {
                    throw new WebScriptException(400, "Script URL not specified");
                }
                if (debug) {
                    logger.debug((Object)("(Runtime=" + this.getName() + ", Container=" + this.container.getName() + ") Processing script url (" + method + ") " + scriptUrl));
                }
                WebScriptRequest scriptReq = null;
                WebScriptResponse scriptRes = null;
                Authenticator auth = null;
                Description.RequiredAuthentication containerRequiredAuth = this.container.getRequiredAuthentication();
                if (!containerRequiredAuth.equals((Object)Description.RequiredAuthentication.none)) {
                    scriptReq = this.createRequest(null);
                    scriptRes = this.createResponse();
                    auth = this.createAuthenticator();
                    if (debug) {
                        logger.debug((Object)("(Runtime=" + this.getName() + ", Container=" + this.container.getName() + ") Container requires pre-auth: " + (Object)((Object)containerRequiredAuth)));
                    }
                    boolean preAuth = true;
                    if (auth != null && auth.emptyCredentials() && (match = this.container.getRegistry().findWebScript(method, scriptUrl)) != null && match.getWebScript().getDescription().getRequiredAuthentication().equals((Object)Description.RequiredAuthentication.none)) {
                        preAuth = false;
                    }
                    if (preAuth && !this.container.authenticate(auth, containerRequiredAuth)) {
                        return;
                    }
                }
                if (match == null) {
                    match = this.container.getRegistry().findWebScript(method, scriptUrl);
                }
                if (match == null || match.getKind() == Match.Kind.URI) {
                    if (match == null) {
                        String msg = "Script url " + scriptUrl + " does not map to a Web Script.";
                        if (debug) {
                            logger.debug((Object)msg);
                        }
                        throw new WebScriptException(404, msg);
                    }
                    String msg = "Script url " + scriptUrl + " does not support the method " + method;
                    if (debug) {
                        logger.debug((Object)msg);
                    }
                    throw new WebScriptException(405, msg);
                }
                scriptReq = this.createRequest(match);
                scriptRes = this.createResponse();
                if (auth == null) {
                    auth = this.createAuthenticator();
                }
                if (debug) {
                    logger.debug((Object)("Agent: " + scriptReq.getAgent()));
                }
                long startScript = System.nanoTime();
                WebScript script = match.getWebScript();
                Description description = script.getDescription();
                try {
                    if (debug) {
                        String reqFormat = scriptReq.getFormat();
                        String format = reqFormat == null || reqFormat.length() == 0 ? "[undefined]" : reqFormat;
                        Description desc = scriptReq.getServiceMatch().getWebScript().getDescription();
                        logger.debug((Object)("Invoking Web Script " + description.getId() + " (format " + format + ", style: " + (Object)((Object)desc.getFormatStyle()) + ", default: " + desc.getDefaultFormat() + ")"));
                    }
                    this.executeScript(scriptReq, scriptRes, auth);
                }
                finally {
                    if (debug) {
                        long endScript = System.nanoTime();
                        logger.debug((Object)("Web Script " + description.getId() + " executed in " + (float)(endScript - startScript) / 1000000.0f + "ms"));
                    }
                }
            }
            catch (Throwable e) {
                if (!this.beforeProcessError(match, e)) break block41;
                if (e instanceof WebScriptException && ((WebScriptException)((Object)e)).getStatus() == 404) {
                    logger.debug((Object)e.getMessage());
                } else if (logger.isErrorEnabled()) {
                    logger.error((Object)("Exception from executeScript - redirecting to status template error: " + e.getMessage()), e);
                }
                WebScriptRequest req = this.createRequest(match);
                WebScriptResponse res = this.createResponse();
                String format = req.getFormat();
                int statusCode = 500;
                StatusTemplate statusTemplate = null;
                Map<Object, Object> statusModel = null;
                if (e instanceof WebScriptException) {
                    WebScriptException we = (WebScriptException)((Object)e);
                    statusCode = we.getStatus();
                    statusTemplate = we.getStatusTemplate();
                    statusModel = we.getStatusModel();
                }
                if (statusTemplate == null) {
                    statusTemplate = this.getStatusCodeTemplate(statusCode);
                    String validTemplatePath = this.container.getTemplateProcessorRegistry().findValidTemplatePath(statusTemplate.getPath());
                    if (validTemplatePath == null) {
                        if (format != null && format.length() > 0) {
                            statusTemplate = this.getFormatStatusTemplate(format);
                            validTemplatePath = this.container.getTemplateProcessorRegistry().findValidTemplatePath(statusTemplate.getPath());
                        }
                        if (validTemplatePath == null) {
                            statusTemplate = this.getStatusTemplate();
                            validTemplatePath = this.container.getTemplateProcessorRegistry().findValidTemplatePath(statusTemplate.getPath());
                        }
                        if (validTemplatePath == null) {
                            throw new WebScriptException("Failed to find status template " + statusTemplate.getPath() + " (format: " + statusTemplate.getFormat() + ")");
                        }
                    }
                }
                if (statusModel == null || ((Object)statusModel).equals(Collections.EMPTY_MAP)) {
                    statusModel = new HashMap<String, Object>(8, 1.0f);
                    statusModel.putAll(this.container.getTemplateParameters());
                    statusModel.put("url", this.createURLModel(req));
                    if (match != null && match.getWebScript() != null) {
                        statusModel.put("webscript", match.getWebScript().getDescription());
                    }
                }
                Status status = new Status();
                status.setCode(statusCode);
                status.setMessage(e.getMessage() != null ? e.getMessage() : e.toString());
                status.setException(e);
                statusModel.put("status", status);
                String mimetype = this.container.getFormatRegistry().getMimeType(req.getAgent(), statusTemplate.getFormat());
                if (mimetype == null) {
                    throw new WebScriptException("Web Script format '" + statusTemplate.getFormat() + "' is not registered");
                }
                if (debug) {
                    logger.debug((Object)("Force success status header in response: " + req.forceSuccessStatus()));
                    logger.debug((Object)("Sending status " + statusCode + " (Template: " + statusTemplate.getPath() + ")"));
                    logger.debug((Object)("Rendering response: content type=" + mimetype));
                }
                res.reset();
                Cache cache = new Cache();
                cache.setNeverCache(true);
                res.setCache(cache);
                res.setStatus(req.forceSuccessStatus() ? 200 : statusCode);
                res.setContentType(mimetype + ";charset=UTF-8");
                try {
                    String validTemplatePath = this.container.getTemplateProcessorRegistry().findValidTemplatePath(statusTemplate.getPath());
                    TemplateProcessor statusProcessor = this.container.getTemplateProcessorRegistry().getTemplateProcessor(validTemplatePath);
                    statusProcessor.process(validTemplatePath, statusModel, res.getWriter());
                }
                catch (Exception e1) {
                    logger.error((Object)"Internal error", (Throwable)e1);
                    throw new WebScriptException("Internal error", e1);
                }
            }
            finally {
                if (debug) {
                    long endRuntime = System.nanoTime();
                    logger.debug((Object)("Processed script url (" + method + ") " + scriptUrl + " in " + (float)(endRuntime - startRuntime) / 1000000.0f + "ms"));
                }
            }
        }
    }

    protected boolean beforeProcessError(Match match, Throwable e) {
        return true;
    }

    protected void executeScript(WebScriptRequest scriptReq, WebScriptResponse scriptRes, Authenticator auth) throws IOException {
        this.container.executeScript(scriptReq, scriptRes, auth);
    }

    protected StatusTemplate getStatusCodeTemplate(int statusCode) {
        return new StatusTemplate("/" + statusCode + ".ftl", "html");
    }

    protected StatusTemplate getFormatStatusTemplate(String format) {
        return new StatusTemplate("/" + format + ".status.ftl", format);
    }

    protected StatusTemplate getStatusTemplate() {
        return new StatusTemplate("/status.ftl", "html");
    }

    @Override
    public Map<String, Object> getScriptParameters() {
        Collection<ScriptParameterFactory> factories;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("session", this.getSession());
        ScriptParameterFactoryRegistry registry = this.container.getScriptParameterFactoryRegistry();
        if (registry != null && (factories = registry.getScriptParameterFactories()) != null) {
            for (ScriptParameterFactory factory : factories) {
                parameters.putAll(factory.getParameters(this));
            }
        }
        return parameters;
    }

    @Override
    public Map<String, Object> getTemplateParameters() {
        return Collections.emptyMap();
    }

    protected abstract String getScriptMethod();

    protected abstract String getScriptUrl();

    protected abstract WebScriptRequest createRequest(Match var1);

    protected abstract WebScriptResponse createResponse();

    protected abstract Authenticator createAuthenticator();

    protected abstract WebScriptSessionFactory createSessionFactory();

    protected static WebScriptRequest getRealWebScriptRequest(WebScriptRequest request) {
        WebScriptRequest real = request;
        while (real instanceof WrappingWebScriptRequest) {
            real = ((WrappingWebScriptRequest)real).getNext();
        }
        return real;
    }

    protected static WebScriptResponse getRealWebScriptResponse(WebScriptResponse response) {
        WebScriptResponse real = response;
        while (real instanceof WrappingWebScriptResponse) {
            real = ((WrappingWebScriptResponse)real).getNext();
        }
        return real;
    }

    private static class RuntimeSession
    implements WebScriptSession {
        private static final String NAMESPACE = "org.springframework.extensions.session.";
        private static final WebScriptSession NOOP_WEBSCRIPTSESSION = new NOOPWebScriptSession();
        private WebScriptSessionFactory sessionFactory;
        private WebScriptSession session;

        public RuntimeSession(WebScriptSessionFactory sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        public String getId() {
            return this.getSession().getId();
        }

        public Object getValue(String name) {
            return this.getSession().getValue(NAMESPACE + name);
        }

        public void removeValue(String name) {
            this.getSession().removeValue(NAMESPACE + name);
        }

        public void setValue(String name, Object value) {
            this.getSession().setValue(NAMESPACE + name, value);
        }

        private WebScriptSession getSession() {
            if (this.session == null && this.sessionFactory != null) {
                this.session = this.sessionFactory.createSession();
            }
            if (this.session == null) {
                this.session = NOOP_WEBSCRIPTSESSION;
            }
            return this.session;
        }

        private static class NOOPWebScriptSession
        implements WebScriptSession {
            private NOOPWebScriptSession() {
            }

            public String getId() {
                return null;
            }

            public Object getValue(String name) {
                return null;
            }

            public void removeValue(String name) {
            }

            public void setValue(String name, Object value) {
            }
        }
    }
}

