/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.Map;
import java.util.TreeMap;
import org.springframework.extensions.webscripts.Path;
import org.springframework.extensions.webscripts.WebScript;

public class PathImpl
implements Path {
    private String path;
    private PathImpl parent = null;
    private Map<String, PathImpl> children = new TreeMap<String, PathImpl>();
    private Map<String, WebScript> scripts = new TreeMap<String, WebScript>();

    public static String concatPath(String path1, String path2) {
        return path1.equals("/") ? path1 + path2 : path1 + "/" + path2;
    }

    public PathImpl(String path) {
        this.path = path;
    }

    public PathImpl createChildPath(String path) {
        PathImpl child = new PathImpl(PathImpl.concatPath(this.path, path));
        child.parent = this;
        this.children.put(child.path, child);
        return child;
    }

    public void addScript(WebScript script) {
        this.scripts.put(script.getDescription().getId(), script);
    }

    public Path[] getChildren() {
        Path[] childrenArray = new Path[this.children.size()];
        return this.children.values().toArray(childrenArray);
    }

    public WebScript[] getScripts() {
        WebScript[] scriptsArray = new WebScript[this.scripts.size()];
        return this.scripts.values().toArray(scriptsArray);
    }

    public String getName() {
        String name = "";
        int i = this.path.lastIndexOf("/");
        if (i != -1 && i != this.path.length() - 1) {
            name = this.path.substring(i + 1);
        }
        return name;
    }

    public Path getParent() {
        return this.parent;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return this.path;
    }
}

