/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.Serializable;
import org.springframework.extensions.webscripts.ScriptCredentials;
import org.springframework.extensions.webscripts.ScriptableLinkedHashMap;
import org.springframework.extensions.webscripts.ScriptableMap;
import org.springframework.extensions.webscripts.connector.CredentialVault;
import org.springframework.extensions.webscripts.connector.Credentials;
import org.springframework.extensions.webscripts.connector.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScriptCredentialVault {
    private final CredentialVault vault;
    private final User user;
    protected ScriptableMap<String, Serializable> properties;

    public ScriptCredentialVault(CredentialVault vault, User user) {
        this.vault = vault;
        this.user = user;
    }

    public ScriptableMap<String, Serializable> getProperties() {
        if (this.properties == null) {
            this.properties = new ScriptableLinkedHashMap<String, Serializable>();
            String[] ids = this.vault.getStoredIds();
            for (int i = 0; i < ids.length; ++i) {
                Credentials credentials = this.vault.retrieve(ids[i]);
                ScriptCredentials scriptCredentials = new ScriptCredentials(this.vault, credentials, true);
                this.properties.put(ids[i], scriptCredentials);
            }
        }
        return this.properties;
    }

    public User getUser() {
        return this.user;
    }

    public boolean hasCredentials(String endpointId) {
        return this.getProperties().containsKey(endpointId);
    }

    public ScriptCredentials newCredentials(String endpointId) {
        ScriptCredentials scriptCredentials = (ScriptCredentials)this.getProperties().get(endpointId);
        if (scriptCredentials == null) {
            Credentials creds = this.vault.newCredentials(endpointId);
            this.vault.save();
            scriptCredentials = new ScriptCredentials(this.vault, creds);
            this.getProperties().put(endpointId, scriptCredentials);
        }
        return scriptCredentials;
    }

    public void removeCredentials(String endpointId) {
        this.vault.remove(endpointId);
        this.vault.save();
        this.getProperties().remove(endpointId);
    }

    public void save() {
        String[] storedIds = this.vault.getStoredIds();
        for (int i = 0; i < storedIds.length; ++i) {
            this.vault.remove(storedIds[i]);
        }
        for (String endpointId : this.getProperties().keySet()) {
            ScriptCredentials scriptCredentials = (ScriptCredentials)this.getProperties().get(endpointId);
            Credentials creds = this.vault.newCredentials(endpointId);
            for (String propertyKey : scriptCredentials.getProperties().keySet()) {
                Object propertyValue = scriptCredentials.getProperties().get(propertyKey);
                if (propertyValue == null) continue;
                creds.setProperty(propertyKey, propertyValue);
            }
            this.vault.store(creds);
        }
        this.vault.save();
        this.properties = null;
    }
}

