/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.extensions.webscripts.connector.HttpMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectorContext {
    private Map<String, String> parameters = Collections.emptyMap();
    private Map<String, String> headers = Collections.emptyMap();
    private String contentType;
    private HttpMethod method = HttpMethod.GET;
    private boolean commitResponse = true;
    private boolean exceptionOnError = false;

    public ConnectorContext() {
        this(null, null, null);
    }

    public ConnectorContext(Map<String, String> parameters, Map<String, String> headers) {
        this(null, parameters, headers);
    }

    public ConnectorContext(HttpMethod method) {
        if (method != null) {
            this.method = method;
        }
    }

    public ConnectorContext(HttpMethod method, Map<String, String> parameters, Map<String, String> headers) {
        if (method != null) {
            this.method = method;
        }
        if (parameters != null) {
            this.parameters = new HashMap<String, String>(parameters.size());
            this.parameters.putAll(parameters);
        }
        if (headers != null) {
            this.headers = new HashMap<String, String>(headers.size());
            this.headers.putAll(headers);
        }
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        if (method != null) {
            this.method = method;
        }
    }

    public boolean getCommitResponse() {
        return this.commitResponse;
    }

    public void setCommitResponseOnAuthenticationError(boolean commitResponse) {
        this.commitResponse = commitResponse;
    }

    public void setExceptionOnError(boolean exceptionOnError) {
        this.exceptionOnError = exceptionOnError;
    }

    public boolean getExceptionOnError() {
        return this.exceptionOnError;
    }
}

