/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.DefaultHttpParams;
import org.apache.commons.httpclient.params.DefaultHttpParamsFactory;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.httpclient.params.HttpParamsFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.exception.WebScriptsPlatformException;
import org.springframework.extensions.surf.util.Base64;
import org.springframework.extensions.webscripts.connector.AbstractClient;
import org.springframework.extensions.webscripts.connector.HttpMethod;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.extensions.webscripts.connector.ResponseStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteClient
extends AbstractClient
implements Cloneable {
    private static Log logger = LogFactory.getLog(RemoteClient.class);
    protected static final String HEADER_TRANSFER_ENCODING = "Transfer-Encoding";
    protected static final String HEADER_CONTENT_LENGTH = "Content-Length";
    protected static final String HEADER_CONTENT_TYPE = "Content-Type";
    protected static final String HEADER_SET_COOKIE = "Set-Cookie";
    protected static final String HEADER_COOKIE = "Cookie";
    protected static final String HEADER_SERVER = "Server";
    protected static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    protected static final int DEFAULT_READ_TIMEOUT = 120000;
    protected static final int DEFAULT_BUFFERSIZE = 4096;
    protected static final int DEFAULT_MAX_REDIRECTS = 10;
    protected static final String DEFAULT_TICKET_NAME = "alf_ticket";
    protected static final String DEFAULT_REQUEST_CONTENT_TYPE = "application/octet-stream";
    protected static final String X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    protected static final String CHARSETEQUALS = "charset=";
    private static final String XML_START = "<?xml";
    private static final Pattern XML_ENCODING = Pattern.compile("<\\?xml.*.encoding=\"([^\"]*)\"");
    private static final int XML_ENC_READ_LIMIT = 100;
    private static ProxyHost s_httpProxyHost;
    private static ProxyHost s_httpsProxyHost;
    private Map<String, String> cookies;
    private String ticket;
    private String requestContentType = null;
    private HttpMethod requestMethod = HttpMethod.GET;
    private String username;
    private String password;
    private boolean commitResponseOnAuthenticationError = true;
    private boolean exceptionOnError = false;
    private Map<String, String> requestProperties;
    private String ticketName = "alf_ticket";
    private String defaultEncoding = null;
    private String defaultContentType = "application/octet-stream";
    private int bufferSize = 4096;
    private int connectTimeout = 10000;
    private int readTimeout = 120000;
    private int maxRedirects = 10;
    private boolean allowHttpProxy = true;
    private boolean allowHttpsProxy = true;
    private Set<String> removeRequestHeaders = Collections.emptySet();
    private Set<String> removeResponseHeaders = Collections.emptySet();
    private boolean httpTcpNodelay = true;
    private boolean httpConnectionStalecheck = true;
    public static final int SC_MOVED_TEMPORARILY = 302;
    public static final int SC_MOVED_PERMANENTLY = 301;
    public static final int SC_SEE_OTHER = 303;
    public static final int SC_TEMPORARY_REDIRECT = 307;
    private static ThreadLocal<HttpClient> httpClient;

    public Object clone() throws CloneNotSupportedException {
        RemoteClient clone = (RemoteClient)super.clone();
        clone.allowHttpProxy = this.allowHttpProxy;
        clone.allowHttpsProxy = this.allowHttpsProxy;
        clone.bufferSize = this.bufferSize;
        clone.connectTimeout = this.connectTimeout;
        clone.defaultContentType = this.defaultContentType;
        clone.defaultEncoding = this.defaultEncoding;
        clone.httpConnectionStalecheck = this.httpConnectionStalecheck;
        clone.httpTcpNodelay = this.httpTcpNodelay;
        clone.maxRedirects = this.maxRedirects;
        clone.readTimeout = this.readTimeout;
        clone.readTimeout = this.readTimeout;
        clone.removeRequestHeaders = (Set)((HashSet)this.removeRequestHeaders).clone();
        clone.removeResponseHeaders = (Set)((HashSet)this.removeResponseHeaders).clone();
        clone.ticketName = this.ticketName;
        return clone;
    }

    public void setTicketName(String ticketName) {
        this.ticketName = ticketName;
    }

    public String getTicketName() {
        return this.ticketName;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setDefaultContentType(String defaultContentType) {
        this.defaultContentType = defaultContentType;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    public void setAllowHttpProxy(boolean allowHttpProxy) {
        this.allowHttpProxy = allowHttpProxy;
    }

    public void setAllowHttpsProxy(boolean allowHttpsProxy) {
        this.allowHttpsProxy = allowHttpsProxy;
    }

    public void setRemoveRequestHeaders(Set<String> removeRequestHeaders) {
        if (removeRequestHeaders != null) {
            this.removeRequestHeaders = new HashSet<String>(removeRequestHeaders.size());
            for (String key : removeRequestHeaders) {
                this.removeRequestHeaders.add(key.toLowerCase());
            }
        }
    }

    public void setRemoveResponseHeaders(Set<String> removeResponseHeaders) {
        if (removeResponseHeaders != null) {
            this.removeResponseHeaders = new HashSet<String>(removeResponseHeaders.size());
            for (String key : removeResponseHeaders) {
                this.removeResponseHeaders.add(key.toLowerCase());
            }
        }
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setUsernamePassword(String user, String pass) {
        this.username = user;
        this.password = pass;
    }

    public void setRequestContentType(String contentType) {
        this.requestContentType = contentType;
    }

    public String getRequestContentType() {
        if (this.requestContentType == null) {
            this.requestContentType = this.defaultContentType;
        }
        return this.requestContentType;
    }

    public void setRequestMethod(HttpMethod method) {
        if (method != null) {
            this.requestMethod = method;
        }
    }

    public HttpMethod getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestProperties(Map<String, String> requestProperties) {
        if (requestProperties != null) {
            this.requestProperties = new HashMap<String, String>(requestProperties.size());
            for (String key : requestProperties.keySet()) {
                this.requestProperties.put(key.toLowerCase(), requestProperties.get(key));
            }
        }
    }

    public void setCookies(Map<String, String> cookies) {
        this.cookies = cookies;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public void setHttpTcpNodelay(boolean httpTcpNodelay) {
        this.httpTcpNodelay = httpTcpNodelay;
    }

    public void setHttpConnectionStalecheck(boolean httpConnectionStalecheck) {
        this.httpConnectionStalecheck = httpConnectionStalecheck;
    }

    public void setCommitResponseOnAuthenticationError(boolean commitResponseOnAuthenticationError) {
        this.commitResponseOnAuthenticationError = commitResponseOnAuthenticationError;
    }

    public void setExceptionOnError(boolean exceptionOnError) {
        this.exceptionOnError = exceptionOnError;
    }

    public Response call(String uri) {
        return this.call(uri, true, null);
    }

    public Response call(String uri, String body) {
        try {
            byte[] bytes = body.getBytes("UTF-8");
            return this.call(uri, true, new ByteArrayInputStream(bytes));
        }
        catch (UnsupportedEncodingException e) {
            throw new WebScriptsPlatformException("Encoding not supported.", e);
        }
    }

    public Response call(String uri, InputStream in) {
        return this.call(uri, true, in);
    }

    public Response call(String uri, boolean buildResponseString, InputStream in) {
        Response result;
        if (in != null && this.requestMethod != HttpMethod.POST && this.requestMethod != HttpMethod.PUT) {
            this.requestMethod = HttpMethod.POST;
        }
        ResponseStatus status = new ResponseStatus();
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(this.bufferSize);
            String encoding = this.service(this.buildURL(uri), in, bOut, status);
            if (buildResponseString) {
                String data;
                if (encoding != null) {
                    data = bOut.toString(encoding);
                } else {
                    String string = data = this.defaultEncoding != null ? bOut.toString(this.defaultEncoding) : bOut.toString();
                    if (data.startsWith(XML_START)) {
                        Matcher xmlMatcher;
                        String searchXML = data;
                        if (data.length() > 100) {
                            searchXML = data.substring(0, 100);
                        }
                        if ((xmlMatcher = XML_ENCODING.matcher(searchXML)).find()) {
                            data = bOut.toString(xmlMatcher.group(1));
                        }
                    }
                }
                result = new Response(data, status);
            } else {
                result = new Response(new ByteArrayInputStream(bOut.toByteArray()), status);
            }
            result.setEncoding(encoding);
        }
        catch (IOException ioErr) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Error status " + status.getCode() + " " + status.getMessage()), (Throwable)ioErr);
            }
            result = new Response(status);
        }
        return result;
    }

    public Response call(String uri, OutputStream out) {
        return this.call(uri, null, out);
    }

    public Response call(String uri, InputStream in, OutputStream out) {
        Response result;
        if (in != null && this.requestMethod != HttpMethod.POST && this.requestMethod != HttpMethod.PUT) {
            this.requestMethod = HttpMethod.POST;
        }
        ResponseStatus status = new ResponseStatus();
        try {
            String encoding = this.service(this.buildURL(uri), in, out, status);
            result = new Response(status);
            result.setEncoding(encoding);
        }
        catch (IOException ioErr) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Error status " + status.getCode() + " " + status.getMessage()), (Throwable)ioErr);
            }
            result = new Response(status);
        }
        return result;
    }

    public Response call(String uri, HttpServletRequest req, HttpServletResponse res) {
        Response result;
        ResponseStatus status = new ResponseStatus();
        try {
            boolean isPush = this.requestMethod == HttpMethod.POST || this.requestMethod == HttpMethod.PUT;
            String encoding = this.service(this.buildURL(uri), (InputStream)(isPush ? req.getInputStream() : null), (OutputStream)(res != null ? res.getOutputStream() : null), req, res, status);
            result = new Response(status);
            result.setEncoding(encoding);
        }
        catch (IOException ioErr) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Error status " + status.getCode() + " " + status.getMessage()), (Throwable)ioErr);
            }
            result = new Response(status);
        }
        return result;
    }

    protected URL processResponse(URL url, org.apache.commons.httpclient.HttpMethod method) throws MalformedURLException {
        String redirectLocation = null;
        for (Header header : method.getResponseHeaders()) {
            String headerValue;
            int z;
            String headerName = header.getName();
            if (this.cookies != null && headerName.equalsIgnoreCase(HEADER_SET_COOKIE) && (z = (headerValue = header.getValue()).indexOf(61)) != -1) {
                String cookieName = headerValue.substring(0, z);
                String cookieValue = headerValue.substring(z + 1, headerValue.length());
                int y = cookieValue.indexOf(59);
                if (y != -1) {
                    cookieValue = cookieValue.substring(0, y);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RemoteClient found Set-Cookie: " + cookieName + " = " + cookieValue));
                }
                this.cookies.put(cookieName, cookieValue);
            }
            if (!headerName.equalsIgnoreCase("Location")) continue;
            switch (method.getStatusCode()) {
                case 301: 
                case 302: 
                case 303: 
                case 307: {
                    redirectLocation = header.getValue();
                }
            }
        }
        return redirectLocation == null ? null : new URL(url, redirectLocation);
    }

    protected URL buildURL(String uri) throws MalformedURLException {
        String resolvedUri;
        String string = resolvedUri = uri.startsWith(this.endpoint) ? uri : this.endpoint + uri;
        URL url = this.getTicket() == null ? new URL(resolvedUri) : new URL(resolvedUri + (uri.lastIndexOf(63) == -1 ? "?" + this.getTicketName() + "=" + this.getTicket() : "&" + this.getTicketName() + "=" + this.getTicket()));
        return url;
    }

    private String service(URL url, InputStream in, OutputStream out, ResponseStatus status) throws IOException {
        return this.service(url, in, out, null, null, status);
    }

    private String service(URL url, InputStream in, OutputStream out, HttpServletRequest req, HttpServletResponse res, ResponseStatus status) throws IOException {
        boolean trace = logger.isTraceEnabled();
        boolean debug = logger.isDebugEnabled();
        if (debug) {
            logger.debug((Object)("Executing (" + (Object)((Object)this.requestMethod) + ") " + url.toString()));
            if (in != null) {
                logger.debug((Object)" - InputStream supplied - will push...");
            }
            if (out != null) {
                logger.debug((Object)" - OutputStream supplied - will stream response...");
            }
            if (req != null && res != null) {
                logger.debug((Object)" - Full Proxy mode between servlet request and response...");
            }
        }
        HttpClient httpClient = this.createHttpClient();
        if (s_httpProxyHost != null && this.allowHttpProxy && url.getProtocol().equals("http") && this.requiresProxy(url.getHost())) {
            httpClient.getHostConfiguration().setProxyHost(s_httpProxyHost);
            if (debug) {
                logger.debug((Object)(" - using HTTP proxy host for: " + url));
            }
        } else if (s_httpsProxyHost != null && this.allowHttpsProxy && url.getProtocol().equals("https") && this.requiresProxy(url.getHost())) {
            httpClient.getHostConfiguration().setProxyHost(s_httpsProxyHost);
            if (debug) {
                logger.debug((Object)(" - using HTTPS proxy host for: " + url));
            }
        } else {
            httpClient.getHostConfiguration().setProxyHost(null);
        }
        URL redirectURL = url;
        GetMethod method = null;
        int retries = 0;
        int maxRetries = in == null ? this.maxRedirects : 1;
        try {
            int csi;
            int responseCode;
            do {
                if (method != null) {
                    method.releaseConnection();
                    method = null;
                }
                switch (this.requestMethod) {
                    default: {
                        method = new GetMethod(redirectURL.toString());
                        break;
                    }
                    case PUT: {
                        method = new PutMethod(redirectURL.toString());
                        break;
                    }
                    case POST: {
                        method = new PostMethod(redirectURL.toString());
                        break;
                    }
                    case DELETE: {
                        method = new DeleteMethod(redirectURL.toString());
                        break;
                    }
                    case HEAD: {
                        method = new HeadMethod(redirectURL.toString());
                    }
                }
                method.setFollowRedirects(false);
                if (req != null) {
                    Enumeration headers = req.getHeaderNames();
                    while (headers.hasMoreElements()) {
                        String key = (String)headers.nextElement();
                        if (key == null || this.removeRequestHeaders.contains(key = key.toLowerCase()) || this.requestProperties != null && this.requestProperties.containsKey(key)) continue;
                        method.setRequestHeader(key, req.getHeader(key));
                        if (!trace) continue;
                        logger.trace((Object)("Proxy request header: " + key + "=" + req.getHeader(key)));
                    }
                }
                if (this.requestProperties != null && this.requestProperties.size() != 0) {
                    for (Map.Entry<String, String> entry : this.requestProperties.entrySet()) {
                        String headerName = entry.getKey();
                        String headerValue = this.requestProperties.get(headerName);
                        if (headerValue != null) {
                            method.setRequestHeader(headerName, headerValue);
                        }
                        if (!trace) continue;
                        logger.trace((Object)("Set request header: " + headerName + "=" + headerValue));
                    }
                }
                if (this.cookies != null && !this.cookies.isEmpty()) {
                    StringBuilder builder = new StringBuilder(128);
                    for (Map.Entry<String, String> entry : this.cookies.entrySet()) {
                        if (builder.length() != 0) {
                            builder.append(';');
                        }
                        builder.append(entry.getKey());
                        builder.append('=');
                        builder.append(entry.getValue());
                    }
                    String cookieString = builder.toString();
                    if (debug) {
                        logger.debug((Object)("Setting Cookie header: " + cookieString));
                    }
                    method.setRequestHeader(HEADER_COOKIE, cookieString);
                }
                if (this.username != null && this.password != null) {
                    String auth = this.username + ':' + this.password;
                    method.addRequestHeader("Authorization", "Basic " + Base64.encodeBytes((byte[])auth.getBytes()));
                    if (debug) {
                        logger.debug((Object)("Applied HTTP Basic Authorization for user: " + this.username));
                    }
                }
                if (in != null) {
                    Map postParams;
                    boolean urlencoded;
                    method.setRequestHeader(HEADER_CONTENT_TYPE, this.getRequestContentType());
                    if (debug) {
                        logger.debug((Object)("Set Content-Type=" + this.getRequestContentType()));
                    }
                    if (!(urlencoded = this.getRequestContentType().startsWith(X_WWW_FORM_URLENCODED))) {
                        String contentLengthStr;
                        long contentLength = -2L;
                        if (req != null && (contentLengthStr = req.getHeader(HEADER_CONTENT_LENGTH)) != null) {
                            try {
                                long actualContentLength = Long.parseLong(contentLengthStr);
                                if (actualContentLength > 0L) {
                                    contentLength = actualContentLength;
                                }
                            }
                            catch (NumberFormatException e) {
                                logger.warn((Object)("Can't parse 'Content-Length' header from '" + contentLengthStr + "'. The contentLength is set to InputStreamRequestEntity.CONTENT_LENGTH_AUTO"));
                            }
                        }
                        if (debug) {
                            logger.debug((Object)((Object)((Object)this.requestMethod) + " entity Content-Length=" + contentLength));
                        }
                        ((EntityEnclosingMethod)method).setRequestEntity((RequestEntity)new InputStreamRequestEntity(in, contentLength));
                        ((EntityEnclosingMethod)method).setContentChunked(contentLength == -2L);
                        ((EntityEnclosingMethod)method).setUseExpectHeader(true);
                    } else if (req != null && method instanceof PostMethod && (postParams = req.getParameterMap()) != null) {
                        for (String key : postParams.keySet()) {
                            String[] values = (String[])postParams.get(key);
                            for (int i = 0; i < values.length; ++i) {
                                ((PostMethod)method).addParameter(key, values[i]);
                            }
                        }
                        method.removeRequestHeader(HEADER_CONTENT_LENGTH);
                    }
                }
                responseCode = httpClient.executeMethod((org.apache.commons.httpclient.HttpMethod)method);
            } while ((redirectURL = this.processResponse(redirectURL, (org.apache.commons.httpclient.HttpMethod)method)) != null && ++retries < maxRetries);
            if (responseCode >= 500 && this.exceptionOnError) {
                this.buildProxiedServerError((org.apache.commons.httpclient.HttpMethod)method);
            }
            boolean allowResponseCommit = responseCode != 401 || this.commitResponseOnAuthenticationError;
            status.setCode(responseCode);
            if (debug) {
                logger.debug((Object)("Response status code: " + responseCode));
            }
            Header contentType = null;
            Header contentLength = null;
            for (Header header : method.getResponseHeaders()) {
                String key = header.getName();
                if (key == null) continue;
                if (!key.equalsIgnoreCase(HEADER_SERVER) && !key.equalsIgnoreCase(HEADER_TRANSFER_ENCODING)) {
                    if (res != null && allowResponseCommit && !this.removeResponseHeaders.contains(key.toLowerCase())) {
                        res.setHeader(key, header.getValue());
                    }
                    status.setHeader(key, header.getValue());
                    if (trace) {
                        logger.trace((Object)("Response header: " + key + "=" + header.getValue()));
                    }
                }
                if (contentType == null && key.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
                    contentType = header;
                    this.processContentType(url, res, contentType);
                    continue;
                }
                if (contentLength != null || !key.equalsIgnoreCase(HEADER_CONTENT_LENGTH)) continue;
                contentLength = header;
            }
            String encoding = null;
            String ct = null;
            if (contentType != null && (csi = (ct = contentType.getValue()).indexOf(CHARSETEQUALS)) != -1) {
                encoding = ct.substring(csi + CHARSETEQUALS.length());
            }
            if (debug) {
                logger.debug((Object)("Response encoding: " + contentType));
            }
            if (res != null && responseCode == 401 && allowResponseCommit) {
                res.sendError(responseCode, method.getStatusText());
            } else {
                long length;
                if (res != null && allowResponseCommit) {
                    res.setStatus(responseCode);
                }
                int bufferSize = this.bufferSize;
                if (contentLength != null && (length = Long.parseLong(contentLength.getValue())) < (long)bufferSize) {
                    bufferSize = (int)length;
                }
                this.copyResponseStreamOutput(url, res, out, (org.apache.commons.httpclient.HttpMethod)method, ct, bufferSize);
            }
            String string = encoding;
            return string;
        }
        catch (ConnectTimeoutException timeErr) {
            status.setCode(408);
            status.setException(timeErr);
            status.setMessage(timeErr.getMessage());
            if (res != null) {
                res.setStatus(408, timeErr.getMessage());
            }
            throw timeErr;
        }
        catch (SocketTimeoutException socketErr) {
            status.setCode(408);
            status.setException(socketErr);
            status.setMessage(socketErr.getMessage());
            if (res != null) {
                res.setStatus(408, socketErr.getMessage());
            }
            throw socketErr;
        }
        catch (UnknownHostException hostErr) {
            status.setCode(503);
            status.setException(hostErr);
            status.setMessage(hostErr.getMessage());
            if (res != null) {
                res.setStatus(503, hostErr.getMessage());
            }
            throw hostErr;
        }
        catch (ConnectException connErr) {
            status.setCode(503);
            status.setException(connErr);
            status.setMessage(connErr.getMessage());
            if (res != null) {
                res.setStatus(503, connErr.getMessage());
            }
            throw connErr;
        }
        catch (IOException ioErr) {
            status.setCode(500);
            status.setException(ioErr);
            status.setMessage(ioErr.getMessage());
            if (res != null) {
                res.setStatus(500, ioErr.getMessage());
            }
            throw ioErr;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
            this.setRequestContentType(null);
            this.requestMethod = HttpMethod.GET;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void copyResponseStreamOutput(URL url, HttpServletResponse res, OutputStream out, org.apache.commons.httpclient.HttpMethod method, String contentType, int bufferSize) throws IOException {
        InputStream input;
        boolean responseCommit;
        block16: {
            responseCommit = false;
            boolean trace = logger.isTraceEnabled();
            StringBuilder traceBuf = null;
            if (trace) {
                traceBuf = new StringBuilder(bufferSize);
            }
            if ((input = method.getResponseBodyAsStream()) == null) return;
            try {
                byte[] buffer = new byte[bufferSize];
                int read = input.read(buffer);
                if (read != -1) {
                    responseCommit = true;
                }
                while (read != -1) {
                    if (out != null) {
                        out.write(buffer, 0, read);
                    }
                    if (trace && contentType != null && (contentType.startsWith("text/") || contentType.startsWith("application/json"))) {
                        traceBuf.append(new String(buffer, 0, read));
                    }
                    read = input.read(buffer);
                }
                Object var14_13 = null;
                if (!trace || traceBuf.length() == 0) break block16;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                if (trace && traceBuf.length() != 0) {
                    logger.trace((Object)("Output (" + traceBuf.length() + " bytes) from: " + url.toString()));
                    logger.trace((Object)traceBuf.toString());
                }
                try {
                    try {
                        input.close();
                        Object var16_17 = null;
                        if (!responseCommit || out == null) throw throwable;
                    }
                    catch (Throwable throwable2) {
                        Object var16_18 = null;
                        if (!responseCommit || out == null) throw throwable2;
                        out.close();
                        throw throwable2;
                    }
                    out.close();
                    {
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    if (!logger.isWarnEnabled()) throw throwable;
                    logger.warn((Object)"Exception during close() of HTTP API connection", (Throwable)e);
                }
                throw throwable;
            }
            logger.trace((Object)("Output (" + traceBuf.length() + " bytes) from: " + url.toString()));
            logger.trace((Object)traceBuf.toString());
        }
        try {
            try {
                input.close();
                Object var16_15 = null;
                if (!responseCommit || out == null) return;
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                if (!responseCommit || out == null) throw throwable;
                out.close();
                throw throwable;
            }
            out.close();
            return;
        }
        catch (IOException e) {
            if (!logger.isWarnEnabled()) return;
            logger.warn((Object)"Exception during close() of HTTP API connection", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildProxiedServerError(org.apache.commons.httpclient.HttpMethod method) {
        ByteArrayOutputStream out;
        block13: {
            boolean gzip = false;
            for (Header header : method.getResponseHeaders()) {
                if (!header.getName().equalsIgnoreCase("Content-Encoding")) continue;
                gzip = header.getValue().contains("gzip");
            }
            out = new ByteArrayOutputStream(512);
            try {
                InputStream input = method.getResponseBodyAsStream();
                if (input == null) break block13;
                if (gzip) {
                    input = new GZIPInputStream(input);
                }
                try {
                    byte[] buffer = new byte[this.bufferSize];
                    int read = input.read(buffer);
                    while (read != -1) {
                        if (out != null) {
                            out.write(buffer, 0, read);
                        }
                        read = input.read(buffer);
                    }
                    Object var8_12 = null;
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
            catch (IOException ioErr) {
                // empty catch block
            }
        }
        try {
            throw new WebScriptsPlatformException(out.toString("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return;
        }
    }

    protected void processContentType(URL url, HttpServletResponse res, Header contentType) {
    }

    protected HttpClient createHttpClient() {
        HttpClient client = httpClient.get();
        HttpClientParams params = client.getParams();
        params.setBooleanParameter("http.tcp.nodelay", this.httpTcpNodelay);
        params.setBooleanParameter("http.connection.stalecheck", this.httpConnectionStalecheck);
        params.setIntParameter("http.connection.timeout", this.connectTimeout);
        params.setIntParameter("http.socket.timeout", this.readTimeout);
        return client;
    }

    protected static ProxyHost createProxyHost(String hostProperty, String portProperty, int defaultPort) {
        String proxyHost = System.getProperty(hostProperty);
        ProxyHost proxy = null;
        if (proxyHost != null && proxyHost.length() != 0) {
            String strProxyPort = System.getProperty(portProperty);
            proxy = strProxyPort == null || strProxyPort.length() == 0 ? new ProxyHost(proxyHost, defaultPort) : new ProxyHost(proxyHost, Integer.parseInt(strProxyPort));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ProxyHost: " + proxy.toString()));
            }
        }
        return proxy;
    }

    private boolean requiresProxy(String targetHost) {
        boolean requiresProxy = true;
        String nonProxyHosts = System.getProperty("http.nonProxyHosts");
        if (nonProxyHosts != null) {
            StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|");
            while (tokenizer.hasMoreTokens()) {
                String pattern = tokenizer.nextToken();
                if (!targetHost.matches(pattern = pattern.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*"))) continue;
                requiresProxy = false;
                break;
            }
        }
        return requiresProxy;
    }

    static {
        httpClient = new ThreadLocal<HttpClient>(){

            @Override
            protected HttpClient initialValue() {
                logger.debug((Object)("Creating HttpClient instance for thread: " + Thread.currentThread().getName()));
                return new HttpClient((HttpClientParams)new NonBlockingHttpParams());
            }
        };
        DefaultHttpParams.setHttpParamsFactory((HttpParamsFactory)new NonBlockingHttpParamsFactory());
        s_httpProxyHost = RemoteClient.createProxyHost("http.proxyHost", "http.proxyPort", 80);
        s_httpsProxyHost = RemoteClient.createProxyHost("https.proxyHost", "https.proxyPort", 443);
    }

    public static class NonBlockingHttpParams
    extends HttpClientParams {
        private HashMap<String, Object> parameters = new HashMap(8);
        private ReadWriteLock paramLock = new ReentrantReadWriteLock();

        public NonBlockingHttpParams() {
        }

        public NonBlockingHttpParams(HttpParams defaults) {
            super(defaults);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getParameter(String name) {
            HttpParams defaults;
            Object param = null;
            this.paramLock.readLock().lock();
            try {
                param = this.parameters.get(name);
            }
            finally {
                this.paramLock.readLock().unlock();
            }
            if (param == null && (defaults = this.getDefaults()) != null) {
                param = defaults.getParameter(name);
            }
            return param;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setParameter(String name, Object value) {
            this.paramLock.writeLock().lock();
            try {
                this.parameters.put(name, value);
            }
            finally {
                this.paramLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isParameterSetLocally(String name) {
            this.paramLock.readLock().lock();
            try {
                boolean bl = this.parameters.get(name) != null;
                return bl;
            }
            finally {
                this.paramLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            this.paramLock.writeLock().lock();
            try {
                this.parameters.clear();
            }
            finally {
                this.paramLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object clone() throws CloneNotSupportedException {
            NonBlockingHttpParams clone = (NonBlockingHttpParams)((Object)super.clone());
            this.paramLock.readLock().lock();
            try {
                clone.parameters = (HashMap)this.parameters.clone();
            }
            finally {
                this.paramLock.readLock().unlock();
            }
            clone.setDefaults(this.getDefaults());
            return clone;
        }
    }

    public static class NonBlockingHttpParamsFactory
    extends DefaultHttpParamsFactory {
        private volatile HttpParams httpParams;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HttpParams getDefaultParams() {
            if (this.httpParams == null) {
                NonBlockingHttpParamsFactory nonBlockingHttpParamsFactory = this;
                synchronized (nonBlockingHttpParamsFactory) {
                    if (this.httpParams == null) {
                        this.httpParams = this.createParams();
                    }
                }
            }
            return this.httpParams;
        }

        protected HttpParams createParams() {
            NonBlockingHttpParams params = new NonBlockingHttpParams(null);
            params.setParameter("http.useragent", "Jakarta Commons-HttpClient/3.1");
            params.setVersion(HttpVersion.HTTP_1_1);
            params.setConnectionManagerClass(SimpleHttpConnectionManager.class);
            params.setCookiePolicy("ignoreCookies");
            params.setHttpElementCharset("US-ASCII");
            params.setContentCharset("ISO-8859-1");
            params.setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler());
            ArrayList<String> datePatterns = new ArrayList<String>();
            datePatterns.addAll(Arrays.asList("EEE, dd MMM yyyy HH:mm:ss zzz", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy", "EEE, dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MMM-yyyy HH-mm-ss z", "EEE, dd MMM yy HH:mm:ss z", "EEE dd-MMM-yyyy HH:mm:ss z", "EEE dd MMM yyyy HH:mm:ss z", "EEE dd-MMM-yyyy HH-mm-ss z", "EEE dd-MMM-yy HH:mm:ss z", "EEE dd MMM yy HH:mm:ss z", "EEE,dd-MMM-yy HH:mm:ss z", "EEE,dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MM-yyyy HH:mm:ss z"));
            params.setParameter("http.dateparser.patterns", datePatterns);
            String agent = null;
            try {
                agent = System.getProperty("httpclient.useragent");
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
            if (agent != null) {
                params.setParameter("http.useragent", agent);
            }
            String preemptiveDefault = null;
            try {
                preemptiveDefault = System.getProperty("httpclient.authentication.preemptive");
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
            if (preemptiveDefault != null) {
                if ((preemptiveDefault = preemptiveDefault.trim().toLowerCase()).equals("true")) {
                    params.setParameter("http.authentication.preemptive", Boolean.TRUE);
                } else if (preemptiveDefault.equals("false")) {
                    params.setParameter("http.authentication.preemptive", Boolean.FALSE);
                }
            }
            String defaultCookiePolicy = null;
            try {
                defaultCookiePolicy = System.getProperty("apache.commons.httpclient.cookiespec");
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
            if (defaultCookiePolicy != null) {
                if ("COMPATIBILITY".equalsIgnoreCase(defaultCookiePolicy)) {
                    params.setCookiePolicy("compatibility");
                } else if ("NETSCAPE_DRAFT".equalsIgnoreCase(defaultCookiePolicy)) {
                    params.setCookiePolicy("netscape");
                } else if ("RFC2109".equalsIgnoreCase(defaultCookiePolicy)) {
                    params.setCookiePolicy("rfc2109");
                }
            }
            return params;
        }
    }
}

