/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.surf.util.StringBuilderWriter;
import org.springframework.extensions.webscripts.connector.AbstractPersistentCredentialVault;
import org.springframework.extensions.webscripts.connector.Credentials;

public class XMLCredentialVault
extends AbstractPersistentCredentialVault {
    private static Log logger = LogFactory.getLog(XMLCredentialVault.class);
    protected String location;

    public XMLCredentialVault(String id) {
        super(id);
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() {
        boolean success = false;
        File file = new File(this.getLocation() + "/" + this.id + ".xml");
        if (file.exists()) {
            StringBuilder contents = new StringBuilder();
            try {
                BufferedReader input = new BufferedReader(new FileReader(file));
                try {
                    String line = null;
                    while ((line = input.readLine()) != null) {
                        contents.append(line);
                        contents.append(System.getProperty("line.separator"));
                    }
                    String xml = contents.toString();
                    this.deserialize(xml);
                    success = true;
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    input.close();
                    throw throwable;
                }
                input.close();
                {
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"Unable to load XML Credential Vault");
            logger.debug((Object)("Not found: " + file.getAbsolutePath()));
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean save() {
        boolean success = false;
        String xml = this.serialize();
        File file = new File(this.getLocation() + "/" + this.id + ".xml");
        if (file.exists()) {
            file.delete();
        }
        FileWriter fw = null;
        fw = new FileWriter(file, true);
        fw.write(xml);
        success = true;
        Object var7_5 = null;
        if (fw == null) return success;
        try {
            fw.close();
            return success;
        }
        catch (Exception ex2) {}
        return success;
        {
            catch (Exception ex) {
                ex.printStackTrace();
                Object var7_6 = null;
                if (fw == null) return success;
                try {
                    fw.close();
                    return success;
                }
                catch (Exception ex2) {}
                return success;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (fw == null) throw throwable;
            try {
                fw.close();
                throw throwable;
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected String serialize() {
        Element rootElement = DocumentHelper.createElement((String)"vault");
        rootElement.addAttribute("id", this.id);
        Document d = DocumentHelper.createDocument((Element)rootElement);
        for (String endpointId : this.credentialsMap.keySet()) {
            RemoteConfigElement.EndpointDescriptor descriptor = this.getRemoteConfig().getEndpointDescriptor(endpointId);
            if (!descriptor.getPersistent()) continue;
            Element endpointElement = rootElement.addElement("endpoint");
            endpointElement.addAttribute("id", endpointId);
            Credentials credentials = this.retrieve(endpointId);
            String[] keys = credentials.getPropertyKeys();
            for (int i = 0; i < keys.length; ++i) {
                String value = (String)credentials.getProperty(keys[i]);
                Element credentialElement = endpointElement.addElement("credential");
                credentialElement.addAttribute("id", keys[i]);
                credentialElement.setText(value);
            }
        }
        return XMLCredentialVault.toXML(d, true);
    }

    protected void deserialize(String xml) {
        Document d = null;
        try {
            d = DocumentHelper.parseText((String)xml);
            Element rootElement = d.getRootElement();
            this.id = rootElement.attributeValue("id");
            List endpoints = rootElement.elements("endpoint");
            for (int i = 0; i < endpoints.size(); ++i) {
                Element endpointElement = (Element)endpoints.get(i);
                String endpointId = endpointElement.attributeValue("id");
                RemoteConfigElement.EndpointDescriptor descriptor = this.getRemoteConfig().getEndpointDescriptor(endpointId);
                if (!descriptor.getPersistent()) continue;
                Credentials credz = this.newCredentials(endpointId);
                List credentialsList = endpointElement.elements("credential");
                for (int k = 0; k < credentialsList.size(); ++k) {
                    Element credential = (Element)credentialsList.get(k);
                    String credentialId = credential.attributeValue("id");
                    String credentialValue = credential.getTextTrim();
                    credz.setProperty(credentialId, credentialValue);
                }
                this.store(credz);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String toString() {
        return "XMLCredentialVault - " + this.location;
    }

    public static String toXML(Document document, boolean pretty) {
        String xml = null;
        if (pretty) {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setSuppressDeclaration(false);
            StringBuilderWriter writer = new StringBuilderWriter(256);
            XMLWriter xmlWriter = new XMLWriter((Writer)writer, format);
            try {
                xmlWriter.write(document);
                xmlWriter.flush();
                xml = writer.toString();
            }
            catch (IOException ioe) {
                logger.debug((Object)ioe);
            }
        }
        if (xml == null) {
            xml = document.asXML();
        }
        return xml;
    }
}

