/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.processor;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.extensions.webscripts.ScriptProcessorRegistry;
import org.springframework.extensions.webscripts.processor.BaseProcessor;

public abstract class BaseRegisterableScriptProcessor
extends BaseProcessor
implements ApplicationContextAware,
ApplicationListener {
    private ApplicationContext applicationContext;
    private ScriptProcessorRegistry scriptProcessorRegistry;

    public void setScriptProcessorRegistry(ScriptProcessorRegistry scriptProcessorRegistry) {
        this.scriptProcessorRegistry = scriptProcessorRegistry;
    }

    public ScriptProcessorRegistry getScriptProcessorRegistry() {
        return this.scriptProcessorRegistry;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        ContextRefreshedEvent refreshEvent;
        ApplicationContext refreshContext;
        if (event instanceof ContextRefreshedEvent && (refreshContext = (refreshEvent = (ContextRefreshedEvent)event).getApplicationContext()) != null && refreshContext.equals(this.applicationContext)) {
            this.init();
            this.register();
        }
    }

    public abstract void init();

    public abstract void register();
}

