/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.servlet.mvc;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.UrlBasedViewResolver;

public abstract class AbstractWebScriptViewResolver
extends UrlBasedViewResolver {
    private final Map<Object, View> viewCache = new HashMap<Object, View>(128);
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    protected boolean useNullSentinel = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View resolveViewName(String viewName, Locale locale) throws Exception {
        View view;
        block8: {
            if (!this.isCache()) {
                return this.createView(viewName, locale);
            }
            Object cacheKey = this.getCacheKey(viewName, locale);
            this.cacheLock.readLock().lock();
            try {
                view = this.viewCache.get(cacheKey);
                if (view != null) break block8;
                this.cacheLock.readLock().unlock();
                this.cacheLock.writeLock().lock();
                try {
                    view = this.viewCache.get(cacheKey);
                    if (view == null && (view = this.createView(viewName, locale)) == null && this.useNullSentinel) {
                        view = ViewSentinel.getInstance();
                        this.viewCache.put(cacheKey, view);
                    }
                }
                finally {
                    this.cacheLock.readLock().lock();
                    this.cacheLock.writeLock().unlock();
                }
            }
            finally {
                this.cacheLock.readLock().unlock();
            }
        }
        return view != ViewSentinel.getInstance() ? view : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        this.cacheLock.writeLock().lock();
        try {
            this.viewCache.clear();
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ViewSentinel
    implements View {
        private static ViewSentinel instance = new ViewSentinel();

        private ViewSentinel() {
        }

        static ViewSentinel getInstance() {
            return instance;
        }

        public String getContentType() {
            return null;
        }

        public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        }
    }
}

