/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.servlet.mvc;

import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.surf.exception.WebScriptsPlatformException;
import org.springframework.extensions.surf.util.Base64;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.ConnectorService;
import org.springframework.extensions.webscripts.connector.CredentialsImpl;
import org.springframework.extensions.webscripts.connector.HttpMethod;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.extensions.webscripts.servlet.mvc.ProxyControllerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class EndPointProxyController
extends AbstractController {
    private static Log logger = LogFactory.getLog(EndPointProxyController.class);
    private static final long serialVersionUID = -176412355613122789L;
    private static final String JSESSIONID = ";jsessionid=";
    private static final String USER_ID = "_alf_USER_ID";
    protected ConfigService configService;
    protected ConnectorService connectorService;
    protected ProxyControllerInterceptor proxyControllerInterceptor = new ProxyControllerInterceptor(){

        public boolean exceptionOnError(RemoteConfigElement.EndpointDescriptor endpoint, String uri) {
            return false;
        }

        public boolean allowHttpBasicAuthentication(RemoteConfigElement.EndpointDescriptor endpoint, String uri) {
            return false;
        }
    };
    protected RemoteConfigElement config;

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public void setConnectorService(ConnectorService connectorService) {
        this.connectorService = connectorService;
    }

    @Deprecated
    public void setBasicHttpAuthChallenge(boolean basicHttpAuthChallenge) {
    }

    public void setProxyControllerInterceptor(ProxyControllerInterceptor proxyControllerInterceptor) {
        if (proxyControllerInterceptor == null) {
            throw new IllegalArgumentException("ProxyControllerInterceptor is mandatory");
        }
        this.proxyControllerInterceptor = proxyControllerInterceptor;
    }

    public RemoteConfigElement getRemoteConfig() {
        if (this.config == null) {
            this.config = (RemoteConfigElement)this.configService.getConfig((Object)"Remote").getConfigElement("remote");
        }
        return this.config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse res) throws Exception {
        StringTokenizer t;
        String uri = (String)req.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        int jsessionid = uri.indexOf(JSESSIONID);
        if (jsessionid != -1) {
            uri = uri.substring(0, jsessionid);
        }
        if (!(t = new StringTokenizer(URLEncoder.encodeUri((String)uri), "/")).hasMoreTokens()) {
            throw new IllegalArgumentException("Proxy URL did not specify endpoint id.");
        }
        String endpointId = t.nextToken();
        StringBuilder buf = new StringBuilder(64);
        if (t.hasMoreTokens()) {
            do {
                buf.append('/');
                buf.append(t.nextToken());
            } while (t.hasMoreTokens());
        } else {
            buf.append('/');
        }
        try {
            Connector connector;
            RemoteConfigElement.EndpointDescriptor descriptor = this.getRemoteConfig().getEndpointDescriptor(endpointId);
            if (descriptor == null) throw new WebScriptsPlatformException("Invalid EndPoint Id: " + endpointId);
            if (descriptor.getUnsecure()) {
                throw new WebScriptsPlatformException("Invalid EndPoint Id: " + endpointId);
            }
            String userId = null;
            HttpSession session = req.getSession(false);
            if (session != null) {
                userId = (String)session.getAttribute(USER_ID);
            }
            if (userId != null && this.connectorService.getCredentialVault(req.getSession(), userId).hasCredentials(endpointId)) {
                connector = this.connectorService.getConnector(endpointId, userId, req.getSession());
            } else if (descriptor.getIdentity() == RemoteConfigElement.IdentityType.NONE || descriptor.getIdentity() == RemoteConfigElement.IdentityType.DECLARED || descriptor.getExternalAuth()) {
                connector = this.connectorService.getConnector(endpointId, req.getSession());
            } else {
                if (!descriptor.getBasicAuth() && !this.proxyControllerInterceptor.allowHttpBasicAuthentication(descriptor, uri)) {
                    res.setStatus(401, "No USER_ID found in session and requested endpoint requires authentication.");
                    return null;
                }
                String authorization = req.getHeader("Authorization");
                if (authorization == null || authorization.length() == 0) {
                    this.authorizedResponseStatus(res);
                    return null;
                }
                String[] authParts = authorization.split(" ");
                if (authParts[0].equalsIgnoreCase("negotiate")) {
                    this.authorizedResponseStatus(res);
                    return null;
                }
                if (!authParts[0].equalsIgnoreCase("basic")) {
                    throw new WebScriptsPlatformException("Authorization '" + authParts[0] + "' not supported.");
                }
                String[] values = new String(Base64.decode((String)authParts[1])).split(":");
                if (values.length != 2) {
                    this.authorizedResponseStatus(res);
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Authenticating (BASIC HTTP) user " + values[0]));
                }
                connector = this.connectorService.getConnector(endpointId, values[0], req.getSession());
                CredentialsImpl credentials = new CredentialsImpl(endpointId);
                credentials.setProperty("cleartextUsername", values[0]);
                credentials.setProperty("cleartextPassword", values[1]);
                connector.setCredentials(credentials);
            }
            HashMap<String, String> headers = new HashMap<String, String>(1, 1.0f);
            headers.put("Authorization", null);
            ConnectorContext context = new ConnectorContext(HttpMethod.valueOf(req.getMethod().toUpperCase()), null, headers);
            context.setExceptionOnError(this.proxyControllerInterceptor.exceptionOnError(descriptor, uri));
            context.setContentType(req.getContentType());
            String q = req.getQueryString();
            String url = buf.toString() + (q != null && q.length() != 0 ? "?" + q : "");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"EndPointProxyController preparing to proxy:");
                logger.debug((Object)(" - endpointId: " + endpointId));
                logger.debug((Object)(" - userId: " + userId));
                logger.debug((Object)(" - connector: " + connector));
                logger.debug((Object)(" - method: " + (Object)((Object)context.getMethod())));
                logger.debug((Object)(" - url: " + url));
            }
            Response response = connector.call(url, context, req, res);
            if (!logger.isDebugEnabled()) return null;
            logger.debug((Object)("Return code: " + response.getStatus().getCode()));
            if (response.getStatus().getCode() != 500) return null;
            logger.debug((Object)("Error detected: " + response.getStatus().getMessage() + "\n" + response.getStatus().getException().toString()));
            return null;
        }
        catch (Throwable err) {
            throw new WebScriptsPlatformException("Error during endpoint proxy processing: " + err.getMessage(), err);
        }
    }

    private void authorizedResponseStatus(HttpServletResponse res) {
        res.setStatus(401, "No USER_ID found in session and requested endpoint requires authentication.");
        res.setHeader("WWW-Authenticate", "Basic realm=\"Alfresco\"");
    }
}

